/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.realtime.MemoryArea;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.lang.Text;
import javolution.lang.TypeFormat;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.FastTable;
import javolution.util.LocalMap;
import javolution.xml.XmlElement;
import javolution.xml.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlFormat<T> {
    private static final FastMap DEFAULT_INSTANCES = new FastMap().setShared(true);
    private static final LocalMap DYNAMIC_INSTANCES = new LocalMap();
    private static final LocalMap CLASS_TO_FORMAT = new LocalMap();
    private static final LocalMap CLASS_TO_ALIAS = new LocalMap();
    private static FastMap CLASS_NAME_TO_CLASS = new FastMap().setShared(true);
    private static FastMap LOCAL_NAME_TO_URI_CLASS = new FastMap().setShared(true);
    private static final LocalMap ALIAS_TO_CLASS = new LocalMap();
    public static final XmlFormat<Object> DEFAULT_XML = new XmlFormat(){

        public void format(Object object, XmlElement xmlElement) {
        }

        public Object parse(XmlElement xmlElement) {
            return xmlElement.object();
        }
    };
    static final Null NULL = new Null();
    static final XmlFormat NULL_XML = new XmlFormat((Class)NULL.getClass()){

        public String identifier(boolean bl) {
            return null;
        }

        public void format(Object object, XmlElement xmlElement) {
        }

        public Object parse(XmlElement xmlElement) {
            return null;
        }
    };
    public static final XmlFormat<Class> CLASS_XML;
    public static final XmlFormat<String> STRING_XML;
    public static final XmlFormat<Text> TEXT_XML;
    public static final XmlFormat<Appendable> APPENDABLE_XML;
    static final XmlFormat FAST_COMPARATOR_XML;
    public static final XmlFormat<Collection> COLLECTION_XML;
    public static final XmlFormat<Map> MAP_XML;
    public static final XmlFormat<Boolean> BOOLEAN_XML;
    public static final XmlFormat<Byte> BYTE_XML;
    public static final XmlFormat<Character> CHARACTER_XML;
    public static final XmlFormat<Integer> INTEGER_XML;
    public static final XmlFormat<Long> LONG_XML;
    public static final XmlFormat<Short> SHORT_XML;
    public static final XmlFormat<Float> FLOAT_XML;
    public static final XmlFormat<Double> DOUBLE_XML;
    private static Reflection.Method STRING_INTERN;

    protected XmlFormat() {
    }

    protected XmlFormat(Class<T> clazz) {
        if (DEFAULT_INSTANCES.put(clazz, this) != null) {
            throw new IllegalStateException("XmlFormat already mapped to " + clazz);
        }
    }

    protected XmlFormat(String string) {
        this(XmlFormat.classForName(string));
    }

    private static Class classForName(String string) {
        Class clazz = Reflection.getClass(string);
        if (clazz == null) {
            throw new XmlException("Class: " + clazz + " not found");
        }
        return clazz;
    }

    public static void setFormat(Class clazz, XmlFormat xmlFormat) {
        DYNAMIC_INSTANCES.put(clazz, xmlFormat);
        CLASS_TO_FORMAT.clear();
    }

    public static <T> XmlFormat<T> getInstance(Class<T> clazz) {
        Object v = CLASS_TO_FORMAT.get(clazz);
        return v != null ? (XmlFormat)v : XmlFormat.searchInstanceFor(clazz, false);
    }

    public static void setAlias(Class clazz, String string) {
        CLASS_TO_ALIAS.put(clazz, string);
        ALIAS_TO_CLASS.put(string, clazz);
    }

    public String defaultName() {
        return null;
    }

    public String identifier(boolean bl) {
        return bl ? "j:ref" : "j:id";
    }

    public T allocate(XmlElement xmlElement) {
        return null;
    }

    public abstract void format(T var1, XmlElement var2);

    public abstract T parse(XmlElement var1);

    private static XmlFormat searchInstanceFor(Class clazz, boolean bl) {
        Class clazz2;
        Object object;
        ClassInitializer.initialize(clazz);
        XmlFormat xmlFormat = null;
        Class clazz3 = null;
        FastCollection fastCollection = (FastCollection)((Object)DYNAMIC_INSTANCES.entrySet());
        FastCollection.Record record = fastCollection.head();
        FastMap.Entry entry = fastCollection.tail();
        while ((record = record.getNext()) != entry) {
            object = (Map.Entry)((Object)record);
            clazz2 = (Class)object.getKey();
            if (clazz2 == clazz && bl || !clazz2.isAssignableFrom(clazz) || clazz3 != null && !clazz3.isAssignableFrom(clazz2)) continue;
            clazz3 = clazz2;
            xmlFormat = (XmlFormat)object.getValue();
        }
        record = DEFAULT_INSTANCES.head();
        entry = DEFAULT_INSTANCES.tail();
        while ((record = ((FastMap.Entry)record).getNext()) != entry) {
            object = (Class)((FastMap.Entry)record).getKey();
            if (object == clazz && bl || (clazz2 = (Class)((FastMap.Entry)record).getKey()) == clazz && bl || !clazz2.isAssignableFrom(clazz) || clazz3 != null && (clazz3 == clazz2 || !clazz3.isAssignableFrom(clazz2))) continue;
            clazz3 = clazz2;
            xmlFormat = (XmlFormat)((FastMap.Entry)record).getValue();
        }
        if (xmlFormat == null) {
            xmlFormat = DEFAULT_XML;
        }
        if (!bl) {
            CLASS_TO_FORMAT.put(clazz, xmlFormat);
        }
        return xmlFormat;
    }

    static String aliasFor(Class clazz) {
        return (String)CLASS_TO_ALIAS.get(clazz);
    }

    static Class classFor(CharSequence charSequence) {
        Class clazz = (Class)CLASS_NAME_TO_CLASS.get(charSequence);
        return clazz != null ? clazz : XmlFormat.searchClassFor(charSequence);
    }

    private static Class searchClassFor(CharSequence charSequence) {
        Class clazz = (Class)ALIAS_TO_CLASS.get(charSequence);
        if (clazz != null) {
            return clazz;
        }
        String string = ((Object)charSequence).toString();
        clazz = Reflection.getClass(string);
        if (clazz == null) {
            throw new XmlException("Class: " + clazz + " not found");
        }
        CLASS_NAME_TO_CLASS.put(XmlFormat.intern(string), clazz);
        return clazz;
    }

    static Class classFor(CharSequence charSequence, CharSequence charSequence2) {
        FastTable fastTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(charSequence2);
        if (fastTable != null) {
            for (int i = 0; i < fastTable.size(); i += 2) {
                if (!charSequence.equals(fastTable.get(i))) continue;
                return (Class)fastTable.get(i + 1);
            }
        }
        return XmlFormat.searchClassFor(charSequence, charSequence2);
    }

    private static Class searchClassFor(CharSequence charSequence, CharSequence charSequence2) {
        String string = ((Object)charSequence).toString();
        final String string2 = ((Object)charSequence2).toString();
        if (!string.startsWith("java:")) {
            throw new XmlException("Invalid package uri (" + string + "), the package uri should start with \"java:\"");
        }
        String string3 = string.substring(5) + (string.length() > 5 ? "." : "") + string2;
        Class clazz = Reflection.getClass(string3);
        if (clazz == null) {
            throw new XmlException("Class: " + clazz + " not found");
        }
        FastTable fastTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(charSequence2);
        if (fastTable == null) {
            MemoryArea.getMemoryArea(LOCAL_NAME_TO_URI_CLASS).executeInArea(new Runnable(){

                public void run() {
                    LOCAL_NAME_TO_URI_CLASS.put(XmlFormat.intern(string2), new FastTable());
                }
            });
            fastTable = (FastTable)LOCAL_NAME_TO_URI_CLASS.get(charSequence2);
        }
        fastTable.add(XmlFormat.intern(string));
        fastTable.add(clazz);
        return clazz;
    }

    private static String intern(String string) {
        return STRING_INTERN != null ? (String)STRING_INTERN.invoke(string) : string;
    }

    static {
        CLASS_TO_ALIAS.putDefault(NULL.getClass(), "null");
        ALIAS_TO_CLASS.putDefault("null", NULL.getClass());
        CLASS_XML = new XmlFormat("java.lang.Class"){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("name", ((Class)object).getName());
            }

            public Object parse(XmlElement xmlElement) {
                Class clazz = Reflection.getClass(xmlElement.getAttribute("name", ""));
                if (clazz == null) {
                    throw new XmlException("Class: " + clazz + " not found");
                }
                return clazz;
            }
        };
        STRING_XML = new XmlFormat("java.lang.String"){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (String)object);
            }

            public Object parse(XmlElement xmlElement) {
                return xmlElement.getAttribute("value", "");
            }
        };
        TEXT_XML = new XmlFormat("javolution.lang.Text"){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (Text)object);
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                return charSequence != null ? Text.valueOf(charSequence) : Text.EMPTY;
            }
        };
        APPENDABLE_XML = new XmlFormat("java.lang.Appendable"){

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", Text.valueOf(object));
            }

            public Object parse(XmlElement xmlElement) {
                Appendable appendable = (Appendable)xmlElement.object();
                CharSequence charSequence = xmlElement.getAttribute("value");
                try {
                    return charSequence != null ? appendable.append(charSequence) : appendable;
                }
                catch (IOException iOException) {
                    throw new XmlException(iOException);
                }
            }
        };
        FAST_COMPARATOR_XML = new XmlFormat("javolution.util.FastComparator"){

            public Object allocate(XmlElement xmlElement) {
                if (xmlElement.objectClass() == FastComparator.DEFAULT.getClass()) {
                    return FastComparator.DEFAULT;
                }
                if (xmlElement.objectClass() == FastComparator.DIRECT.getClass()) {
                    return FastComparator.DIRECT;
                }
                if (xmlElement.objectClass() == FastComparator.IDENTITY.getClass()) {
                    return FastComparator.IDENTITY;
                }
                if (xmlElement.objectClass() == FastComparator.LEXICAL.getClass()) {
                    return FastComparator.LEXICAL;
                }
                if (xmlElement.objectClass() == FastComparator.REHASH.getClass()) {
                    return FastComparator.REHASH;
                }
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
            }

            public Object parse(XmlElement xmlElement) {
                return xmlElement.object();
            }
        };
        COLLECTION_XML = new XmlFormat("java.util.Collection"){

            public Object allocate(XmlElement xmlElement) {
                return xmlElement.object();
            }

            public void format(Object object, XmlElement xmlElement) {
                Object object2;
                Collection collection = (Collection)object;
                if (collection instanceof FastCollection && (object2 = ((FastCollection)collection).getValueComparator()) != FastComparator.DEFAULT) {
                    xmlElement.add(object2, "ValueComparator");
                }
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    xmlElement.add(object2.next());
                }
            }

            public Object parse(XmlElement xmlElement) {
                FastComparator fastComparator;
                Collection collection = (Collection)xmlElement.object();
                if (collection instanceof FastCollection && (fastComparator = (FastComparator)xmlElement.get("ValueComparator")) != null) {
                    ((FastCollection)collection).setValueComparator(fastComparator);
                }
                while (xmlElement.hasNext()) {
                    collection.add(xmlElement.getNext());
                }
                return collection;
            }
        };
        MAP_XML = new XmlFormat("java.util.Map"){

            public Object allocate(XmlElement xmlElement) {
                return xmlElement.object();
            }

            public void format(Object object, XmlElement xmlElement) {
                Map map = (Map)object;
                if (map instanceof FastMap) {
                    FastComparator object2;
                    FastComparator fastComparator = ((FastMap)map).getKeyComparator();
                    if (fastComparator != FastComparator.DEFAULT) {
                        xmlElement.add(fastComparator, "KeyComparator");
                    }
                    if ((object2 = ((FastMap)map).getValueComparator()) != FastComparator.DEFAULT) {
                        xmlElement.add(object2, "ValueComparator");
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    xmlElement.add(entry.getKey(), "Key");
                    xmlElement.add(entry.getValue(), "Value");
                }
            }

            public Object parse(XmlElement xmlElement) {
                Object object;
                FastComparator fastComparator;
                Map map = (Map)xmlElement.object();
                if (map instanceof FastMap) {
                    fastComparator = (FastComparator)xmlElement.get("KeyComparator");
                    if (fastComparator != null) {
                        ((FastMap)map).setKeyComparator(fastComparator);
                    }
                    if ((object = (FastComparator)xmlElement.get("ValueComparator")) != null) {
                        ((FastMap)map).setValueComparator((FastComparator)object);
                    }
                }
                while (xmlElement.hasNext()) {
                    fastComparator = xmlElement.get("Key");
                    object = xmlElement.get("Value");
                    map.put(fastComparator, object);
                }
                return map;
            }
        };
        BOOLEAN_XML = new XmlFormat("java.lang.Boolean"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (boolean)((Boolean)object));
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Boolean(TypeFormat.parseBoolean(charSequence));
            }
        };
        BYTE_XML = new XmlFormat("java.lang.Byte"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (int)((Byte)object).byteValue());
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Byte(TypeFormat.parseByte(charSequence));
            }
        };
        CHARACTER_XML = new XmlFormat("java.lang.Character"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", Text.valueOf(((Character)object).charValue()));
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null || charSequence.length() != 1) {
                    throw new XmlException("Missing or invalid value attribute");
                }
                return new Character(charSequence.charAt(0));
            }
        };
        INTEGER_XML = new XmlFormat("java.lang.Integer"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (int)((Integer)object));
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Integer(TypeFormat.parseInt(charSequence));
            }
        };
        LONG_XML = new XmlFormat("java.lang.Long"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (long)((Long)object));
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Long(TypeFormat.parseLong(charSequence));
            }
        };
        SHORT_XML = new XmlFormat("java.lang.Short"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (int)((Short)object).shortValue());
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Short(TypeFormat.parseShort(charSequence));
            }
        };
        FLOAT_XML = new XmlFormat("java.lang.Float"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", ((Float)object).floatValue());
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Float(TypeFormat.parseFloat(charSequence));
            }
        };
        DOUBLE_XML = new XmlFormat("java.lang.Double"){

            public String identifier(boolean bl) {
                return null;
            }

            public void format(Object object, XmlElement xmlElement) {
                xmlElement.setAttribute("value", (double)((Double)object));
            }

            public Object parse(XmlElement xmlElement) {
                CharSequence charSequence = xmlElement.getAttribute("value");
                if (charSequence == null) {
                    throw new XmlException("Missing value attribute");
                }
                return new Double(TypeFormat.parseDouble(charSequence));
            }
        };
        STRING_INTERN = Reflection.getMethod("java.lang.String.intern()");
    }

    private static class Null {
        private Null() {
        }
    }
}

