/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import keel.Algorithms.Decision_Trees.C45.Algorithm;
import keel.Algorithms.Decision_Trees.C45.Dataset;
import keel.Algorithms.Decision_Trees.C45.Itemset;
import keel.Algorithms.Decision_Trees.C45.SelectCut;
import keel.Algorithms.Decision_Trees.C45.Tree;
import keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter.Parameters;
import keel.Dataset.Attributes;

public class C45
extends Algorithm {
    private Tree root;
    private boolean prune = true;
    private float confidence = 0.25f;
    private int minItemsets = 2;
    private double[] priorsProbabilities;
    private static int marginResolution = 500;
    private double[] marginCounts;
    private double classPriorsSum;

    public C45(String trainfn, String testfn) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            this.setOptions(trainfn, testfn);
            Attributes.clearAll();
            this.modelDataset = new Dataset(modelFileName, true);
            this.trainDataset = new Dataset(trainFileName, false);
            this.testDataset = new Dataset(testFileName, false);
            this.priorsProbabilities = new double[this.modelDataset.numClasses()];
            this.priorsProbabilities();
            this.marginCounts = new double[marginResolution + 1];
            this.generateTree(this.modelDataset);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    public int[] getPredictions() {
        int[] classesp = new int[this.testDataset.numItemsets()];
        for (int i = 0; i < this.testDataset.numItemsets(); ++i) {
            try {
                classesp[i] = (int)this.evaluateItemset(this.testDataset.itemset(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classesp;
    }

    @Override
    protected void setOptions(StreamTokenizer option) throws Exception {
    }

    protected void setOptions(String trainfn, String testfn) throws Exception {
        modelFileName = trainfn;
        trainFileName = trainfn;
        testFileName = testfn;
        trainOutputFileName = "salidac45train.dat";
        testOutputFileName = "salidac45test.dat";
        resultFileName = "salidac45result.dat";
        this.prune = Parameters.prune;
        this.confidence = (float)Parameters.confidence;
        this.minItemsets = Parameters.itemsetsPerLeaf;
    }

    public void generateTree(Dataset itemsets) throws Exception {
        SelectCut selectCut = new SelectCut(this.minItemsets, itemsets);
        this.root = new Tree(selectCut, this.prune, this.confidence);
        this.root.buildTree(itemsets);
    }

    public double evaluateItemset(Itemset itemset) throws Exception {
        Itemset classMissing = (Itemset)itemset.copy();
        double prediction = 0.0;
        classMissing.setDataset(itemset.getDataset());
        classMissing.setClassMissing();
        double[] classification = this.classificationForItemset(classMissing);
        prediction = C45.maxIndex(classification);
        this.updateStats(classification, itemset, itemset.numClasses());
        return prediction;
    }

    private void updateStats(double[] predictedClassification, Itemset itemset, int nClasses) {
        int actualClass = (int)itemset.getClassValue();
        if (!itemset.classIsMissing()) {
            this.updateMargins(predictedClassification, actualClass, nClasses);
            int predictedClass = -1;
            double bestProb = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                if (!(predictedClassification[i] > bestProb)) continue;
                predictedClass = i;
                bestProb = predictedClassification[i];
            }
            if (predictedClass < 0) {
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedClassification[actualClass]);
            double priorProb = Math.max(Double.MIN_VALUE, this.priorsProbabilities[actualClass] / this.classPriorsSum);
        }
    }

    public final double[] classificationForItemset(Itemset itemset) throws Exception {
        return this.root.classificationForItemset(itemset);
    }

    private void updateMargins(double[] predictedClassification, int actualClass, int nClasses) {
        int bin;
        double probActual = predictedClassification[actualClass];
        double probNext = 0.0;
        for (int i = 0; i < nClasses; ++i) {
            if (i == actualClass || !(predictedClassification[i] > probNext)) continue;
            probNext = predictedClassification[i];
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)marginResolution);
        this.marginCounts[n] = this.marginCounts[n] + 1.0;
    }

    private boolean isBoolean(String value) {
        return value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE");
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public void priorsProbabilities() throws Exception {
        int i;
        for (i = 0; i < this.modelDataset.numClasses(); ++i) {
            this.priorsProbabilities[i] = 1.0;
        }
        this.classPriorsSum = this.modelDataset.numClasses();
        for (i = 0; i < this.modelDataset.numItemsets(); ++i) {
            if (this.modelDataset.itemset(i).classIsMissing()) continue;
            try {
                int n = (int)this.modelDataset.itemset(i).getClassValue();
                this.priorsProbabilities[n] = this.priorsProbabilities[n] + this.modelDataset.itemset(i).getWeight();
                this.classPriorsSum += this.modelDataset.itemset(i).getWeight();
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    @Override
    public void printResult() throws IOException {
        long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        long seconds = totalTime % 60L;
        long minutes = (totalTime - seconds) % 3600L / 60L;
        String tree = "";
        tree = tree + this.toString();
        tree = tree + "\n@TotalNumberOfNodes " + Tree.NumberOfNodes;
        tree = tree + "\n@NumberOfLeafs " + Tree.NumberOfLeafs;
        tree = tree + "\n\n@NumberOfItemsetsTraining " + this.trainDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTraining " + this.correct;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTraining " + (float)((double)this.correct * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTraining " + (this.trainDataset.numItemsets() - this.correct);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTraining " + (float)((double)(this.trainDataset.numItemsets() - this.correct) * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n\n@NumberOfItemsetsTest " + this.testDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTest " + this.testCorrect;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTest " + (float)((double)this.testCorrect * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTest " + (this.testDataset.numItemsets() - this.testCorrect);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTest " + (float)((double)(this.testDataset.numItemsets() - this.testCorrect) * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n\n@ElapsedTime " + (totalTime - minutes * 60L - seconds) / 3600L + ":" + minutes / 60L + ":" + seconds;
        PrintWriter resultPrint = new PrintWriter(new FileWriter(resultFileName));
        resultPrint.print(this.getHeader() + "\n@decisiontree\n\n" + tree);
        resultPrint.close();
    }

    @Override
    public void printTrain() {
        String text = this.getHeader();
        for (int i = 0; i < this.trainDataset.numItemsets(); ++i) {
            try {
                Itemset itemset = this.trainDataset.itemset(i);
                int cl = (int)this.evaluateItemset(itemset);
                if (cl == (int)itemset.getValue(this.trainDataset.getClassIndex())) {
                    ++this.correct;
                }
                text = text + this.trainDataset.getClassAttribute().value((int)itemset.getClassValue()) + " " + this.trainDataset.getClassAttribute().value(cl) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(trainOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    @Override
    public void printTest() {
        String text = this.getHeader();
        for (int i = 0; i < this.testDataset.numItemsets(); ++i) {
            try {
                int cl = (int)this.evaluateItemset(this.testDataset.itemset(i));
                Itemset itemset = this.testDataset.itemset(i);
                if (cl == (int)itemset.getValue(this.testDataset.getClassIndex())) {
                    ++this.testCorrect;
                }
                text = text + this.testDataset.getClassAttribute().value((int)itemset.getClassValue()) + " " + this.testDataset.getClassAttribute().value(cl) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(testOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file.");
        }
    }

    public String toString() {
        return this.root.toString();
    }
}

