/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.PSO_ACO;

import java.util.Collections;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Atributo;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ComparadorParticulas;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Condicion;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ConjuntoDatos;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Regla;
import org.core.Randomize;

public class Particula {
    float[] velocidad;
    Regla posicion = new Regla();
    Regla mPosicion = new Regla();
    float[][] feromona;
    private static ComparadorParticulas c;

    public Particula() {
        c = new ComparadorParticulas();
    }

    public Particula(int numCondiciones) {
        c = new ComparadorParticulas();
        this.velocidad = new float[numCondiciones];
    }

    public void reservaVelocidad(int numCondiciones) {
        this.velocidad = new float[numCondiciones];
    }

    public ComparadorParticulas getComparadorParticulas() {
        return c;
    }

    public void inicializaPosicionActualContinua(Vector pos) {
        this.posicion.insertaCondicionesContinuos(pos);
    }

    public void inicializaPosicionActualNominal(Vector pos) {
        this.posicion.insertaCondicionesNominales(pos);
    }

    public void inicializaMejorPosicionContinua(Vector pos) {
        this.mPosicion.insertaCondicionesContinuos(pos);
    }

    public void inicializaMejorPosicionNominal(Vector pos) {
        this.mPosicion.insertaCondicionesNominales(pos);
    }

    public void inicializaVelocidad(int numCondiciones, float valorInicial) {
        for (int i = 0; i < numCondiciones; ++i) {
            this.velocidad[i] = valorInicial;
        }
    }

    public void inicializaFeromona(Vector listaCondiciones) {
        int numValores;
        Vector condiciones;
        int i;
        int numCondiciones = listaCondiciones.size();
        this.feromona = new float[numCondiciones][];
        for (i = 0; i < numCondiciones; ++i) {
            condiciones = (Vector)listaCondiciones.get(i);
            numValores = condiciones.size();
            this.feromona[i] = new float[numValores + 1];
        }
        for (i = 0; i < numCondiciones; ++i) {
            condiciones = (Vector)listaCondiciones.get(i);
            numValores = condiciones.size();
            for (int j = 0; j < numValores; ++j) {
                this.feromona[i][j] = 0.9f / (float)numValores;
            }
            this.feromona[i][numValores] = 0.1f;
        }
    }

    public void asignarClasePosicionActual(Atributo clase) {
        this.posicion.insertarClase(clase);
    }

    public void asignarClasePosicionMejor(Atributo clase) {
        this.mPosicion.insertarClase(clase);
    }

    public void asignarCondicionNominalPosicionMejor(Condicion condicion) {
        this.mPosicion.insertarCondicionNominal(condicion);
    }

    public void asignarCondicionContinuaPosicionMejor(Condicion condicion) {
        this.mPosicion.insertarCondicionContinua(condicion);
    }

    public void asignarCondicionNominalPosicionActual(Condicion condicion) {
        this.posicion.insertarCondicionNominal(condicion);
    }

    public void asignarCondicionContinuaPosicionActual(Condicion condicion) {
        this.posicion.insertarCondicionContinua(condicion);
    }

    public Regla getPosActual() {
        return this.posicion;
    }

    public Regla getMejorPosicion() {
        return this.mPosicion;
    }

    public void asignarCalidadPosActual(float calidad) {
        this.posicion.asignarCalidad(calidad);
    }

    public void asignarCalidadMPosicion(float calidad) {
        this.mPosicion.asignarCalidad(calidad);
    }

    public void actualizaFeromona(Vector particulas, int indice, int tamEntorno, Vector listaCondiciones) {
        Vector entorno = this.obtenerVecinos(indice, tamEntorno, particulas);
        Collections.sort(entorno, c);
        Particula vecino = (Particula)entorno.get(0);
        this.modificarFeromona(vecino, listaCondiciones);
    }

    private void modificarFeromona(Particula vecino, Vector listaCondiciones) {
        Vector condiciones;
        int valor;
        Condicion c;
        int i;
        Regla reglaVecino = vecino.getPosActual();
        Vector condicionesVecino = reglaVecino.listaCondicionesNominales();
        float calidadVecino = reglaVecino.obtenerCalidad();
        float calidad = this.posicion.obtenerCalidad();
        int numCondicionesVecino = condicionesVecino.size();
        if (calidadVecino > calidad) {
            for (i = 0; i < numCondicionesVecino; ++i) {
                c = (Condicion)condicionesVecino.get(i);
                valor = (int)c.getValor().getValor();
                condiciones = (Vector)listaCondiciones.get(i);
                if (valor != -1) {
                    float[] fArray = this.feromona[i];
                    int n = valor;
                    fArray[n] = fArray[n] + this.feromona[i][valor] * calidadVecino;
                    continue;
                }
                float[] fArray = this.feromona[i];
                int n = condiciones.size();
                fArray[n] = fArray[n] + this.feromona[i][condiciones.size()] * calidadVecino;
            }
        } else {
            for (i = 0; i < numCondicionesVecino; ++i) {
                c = this.posicion.getCondicionNominal(i);
                valor = (int)c.getValor().getValor();
                condiciones = (Vector)listaCondiciones.get(i);
                if (valor != -1) {
                    float[] fArray = this.feromona[i];
                    int n = valor;
                    fArray[n] = fArray[n] + this.feromona[i][valor] * calidad;
                    continue;
                }
                float[] fArray = this.feromona[i];
                int n = condiciones.size();
                fArray[n] = fArray[n] + this.feromona[i][condiciones.size()] * calidad;
            }
        }
        for (i = 0; i < numCondicionesVecino; ++i) {
            c = this.mPosicion.getCondicionNominal(i);
            valor = (int)c.getValor().getValor();
            condiciones = (Vector)listaCondiciones.get(i);
            if (valor != -1) {
                float[] fArray = this.feromona[i];
                int n = valor;
                fArray[n] = fArray[n] + this.feromona[i][valor] * calidad;
                continue;
            }
            float[] fArray = this.feromona[i];
            int n = condiciones.size();
            fArray[n] = fArray[n] + this.feromona[i][condiciones.size()] * calidad;
        }
        for (i = 0; i < numCondicionesVecino; ++i) {
            int j;
            condiciones = (Vector)listaCondiciones.get(i);
            int tam = condiciones.size();
            float sumatoria = 0.0f;
            for (j = 0; j <= tam; ++j) {
                sumatoria += this.feromona[i][j];
            }
            for (j = 0; j <= tam; ++j) {
                this.feromona[i][j] = this.feromona[i][j] / sumatoria;
            }
        }
    }

    private int obtenerCondicion(int indice, int numCondiciones, Randomize generadorA, float[][] heuristica) {
        int i;
        float probabilidadAcumulada = 0.0f;
        boolean devolver = false;
        float division = 0.0f;
        for (i = 0; i <= numCondiciones; ++i) {
            division += this.feromona[indice][i] * heuristica[indice][i];
        }
        float probabilidadEscoger = (float)generadorA.Rand();
        i = 0;
        probabilidadAcumulada += this.feromona[indice][i] * heuristica[indice][i] / division;
        while (probabilidadAcumulada < probabilidadEscoger) {
            probabilidadAcumulada += this.feromona[indice][++i] * heuristica[indice][i] / division;
        }
        return i;
    }

    public void generaPosicion(Vector listaCondiciones, Vector listaCondicionesVacias, int minimoCasosRegla, ConjuntoDatos cTrain, Randomize generadorA, float[][] heuristica) {
        Condicion elegir;
        int i;
        boolean parada = false;
        this.posicion.eliminaCondicionesNominales();
        this.posicion.limpiaCNominales();
        for (i = 0; i < listaCondiciones.size() && cTrain.cubreMinimo(this.posicion, minimoCasosRegla); ++i) {
            Vector condiciones;
            int pos = this.obtenerCondicion(i, ((Vector)listaCondiciones.get(i)).size(), generadorA, heuristica);
            elegir = pos >= (condiciones = (Vector)listaCondiciones.get(i)).size() ? (Condicion)listaCondicionesVacias.get(i) : (Condicion)condiciones.get(pos);
            this.posicion.insertarCondicionNominal(elegir);
        }
        if (i < listaCondiciones.size()) {
            for (int j = i; j < listaCondiciones.size(); ++j) {
                elegir = (Condicion)listaCondicionesVacias.get(j);
                this.posicion.insertarCondicionNominal(elegir);
            }
        }
    }

    public float obtenerCalidadPosicionActual() {
        float devolver = this.posicion.obtenerCalidad();
        return devolver;
    }

    public float obtenerCalidadMejorPosicion() {
        float devolver = this.mPosicion.obtenerCalidad();
        return devolver;
    }

    public void copiaPosicionMejorPosicion() {
        this.mPosicion.copia(this.posicion);
    }

    public void inicializaVelocidad(float[][] intervalos, int numCondicionesContinuas, Randomize generadorA) {
        for (int i = 0; i < numCondicionesContinuas; ++i) {
            float aleatoreo;
            float minimo = intervalos[i][0];
            float maximo = intervalos[i][1];
            float tamIntervalo = maximo - minimo;
            float velocidadMax = 0.25f * tamIntervalo;
            this.velocidad[i] = aleatoreo = (float)Randomize.Randdouble(0.0, velocidadMax);
            this.velocidad[++i] = aleatoreo = (float)Randomize.Randdouble(-velocidadMax, 0.0);
        }
    }

    public Vector obtenerVecinos(int indice, int tamEntorno, Vector particulas) {
        Vector<Particula> entorno;
        block10: {
            Particula vecino;
            int i;
            int despues;
            block9: {
                int recorrer;
                int antes;
                int numParticulas = particulas.size();
                despues = antes = tamEntorno / 2;
                entorno = new Vector<Particula>();
                if (antes > indice) {
                    recorrer = antes - indice;
                    for (i = numParticulas - recorrer; i < numParticulas; ++i) {
                        vecino = (Particula)particulas.get(i);
                        entorno.addElement(vecino);
                    }
                    if (indice > 0) {
                        for (i = 0; i < indice; ++i) {
                            vecino = (Particula)particulas.get(i);
                            entorno.addElement(vecino);
                        }
                    }
                } else {
                    for (i = indice - antes; i < indice; ++i) {
                        vecino = (Particula)particulas.get(i);
                        entorno.addElement(vecino);
                    }
                }
                if (indice + despues <= numParticulas) break block9;
                recorrer = indice + despues - numParticulas;
                for (i = 0; i < recorrer; ++i) {
                    vecino = (Particula)particulas.get(i);
                    entorno.addElement(vecino);
                }
                if (indice >= numParticulas) break block10;
                for (i = indice + 1; i < numParticulas; ++i) {
                    vecino = (Particula)particulas.get(i);
                    entorno.addElement(vecino);
                }
                break block10;
            }
            for (i = indice + 1; i < indice + despues; ++i) {
                vecino = (Particula)particulas.get(i);
                entorno.addElement(vecino);
            }
        }
        return entorno;
    }

    public void calculaVelocidad(int numCondiciones, Vector particulas, int entorno, int indice, float[][] intervalos, float x, float c1, float c2, Randomize generadorA) {
        Vector vecinos = this.obtenerVecinos(indice, entorno, particulas);
        Collections.sort(vecinos, c);
        Particula mejorVecino = (Particula)vecinos.get(0);
        Regla posicionVecino = mejorVecino.getPosActual();
        for (int i = 0; i < numCondiciones; ++i) {
            float valorCalculado;
            Condicion co = this.posicion.getCondicionContinua(i);
            float valorActual = co.getValor().getValor();
            co = posicionVecino.getCondicionContinua(i);
            float valorVecino = co.getValor().getValor();
            co = this.mPosicion.getCondicionContinua(i);
            float mejorValor = co.getValor().getValor();
            float aleatoreo1 = (float)generadorA.Rand();
            float aleatoreo2 = (float)generadorA.Rand();
            this.velocidad[i] = valorCalculado = x * (this.velocidad[i] + c1 * aleatoreo1 * (mejorValor - valorActual) + c2 * aleatoreo2 * (valorVecino - valorActual));
            float tamIntervalo = intervalos[i][1] - intervalos[i][0];
            if ((double)this.velocidad[i] > (double)tamIntervalo * 0.25) {
                this.velocidad[i] = tamIntervalo * 0.25f;
            }
            if (!((double)this.velocidad[i] < (double)(0.0f - tamIntervalo) * 0.25)) continue;
            this.velocidad[i] = (0.0f - tamIntervalo) * 0.25f;
        }
    }

    public void moverParticula(int numCondiciones, float[][] intervalos) {
        int i = 0;
        int intervalo = 0;
        while (i < numCondiciones) {
            Condicion co = this.posicion.getCondicionContinua(i);
            float valor1 = co.getValor().getValor();
            if ((valor1 += this.velocidad[i]) >= intervalos[intervalo][1]) {
                valor1 = intervalos[intervalo][0];
            }
            if (valor1 < intervalos[intervalo][0]) {
                valor1 = intervalos[intervalo][0];
            }
            Atributo at = new Atributo(valor1, co.getValor().getAtributo(), co.getValor().getTipo());
            int operador = co.getOperador();
            Condicion con = new Condicion(at, operador);
            this.posicion.setCondicionContinua(i, con);
            co = this.posicion.getCondicionContinua(++i);
            float valor2 = co.getValor().getValor();
            valor2 += this.velocidad[i];
            if (valor1 > valor2) {
                valor2 = valor1 + 1.0f;
            }
            if (valor2 > intervalos[intervalo][1]) {
                valor2 = intervalos[intervalo][1];
            }
            if (valor2 < intervalos[intervalo][0]) {
                valor2 = intervalos[intervalo][0];
            }
            at = new Atributo(valor2, co.getValor().getAtributo(), co.getValor().getTipo());
            operador = co.getOperador();
            con = new Condicion(at, operador);
            this.posicion.setCondicionContinua(i, con);
            ++i;
            ++intervalo;
        }
    }

    public void imprimePosicion(int numCondiciones) {
        this.posicion.imprime(numCondiciones);
    }

    public void limpiaCNominales() {
        this.posicion.limpiaCNominales();
    }

    public void asignarMuestrasCubiertasActual(int numero) {
        this.posicion.asignarNumeroMuestrasCubiertas(numero);
    }

    public void asignarMuestrasCubiertasPasado(int numero) {
        this.mPosicion.asignarNumeroMuestrasCubiertas(numero);
    }
}

