/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR;

import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.DataBase;

public class Rule
implements Comparable {
    int[] antecedente;
    int clase;
    int RightN;
    int WrongN;
    int typeOrder;
    long time;
    double DF;
    double Dconf;
    double Dsupp;
    DataBase dataBase;

    public Rule(Rule r) {
        this.antecedente = new int[r.antecedente.length];
        for (int k = 0; k < this.antecedente.length; ++k) {
            this.antecedente[k] = r.antecedente[k];
        }
        this.clase = r.clase;
        this.dataBase = r.dataBase;
        this.Dconf = r.Dconf;
        this.Dsupp = r.Dsupp;
        this.time = r.time;
        this.DF = r.DF;
        this.RightN = r.RightN;
        this.WrongN = r.WrongN;
        this.typeOrder = r.typeOrder;
    }

    public Rule(DataBase dataBase) {
        this.antecedente = new int[dataBase.numVariables()];
        for (int i = 0; i < this.antecedente.length; ++i) {
            this.antecedente[i] = -1;
        }
        this.clase = -1;
        this.dataBase = dataBase;
        this.Dconf = 0.0;
        this.Dsupp = 0.0;
        this.time = 0L;
        this.DF = 0.0;
        this.RightN = 0;
        this.WrongN = 0;
        this.typeOrder = 0;
    }

    public Rule clone() {
        Rule r = new Rule(this.dataBase);
        r.antecedente = new int[this.antecedente.length];
        for (int i = 0; i < this.antecedente.length; ++i) {
            r.antecedente[i] = this.antecedente[i];
        }
        r.clase = this.clase;
        r.dataBase = this.dataBase;
        r.Dconf = this.Dconf;
        r.Dsupp = this.Dsupp;
        r.time = this.time;
        r.DF = this.DF;
        r.RightN = this.RightN;
        r.WrongN = this.WrongN;
        r.typeOrder = this.typeOrder;
        return r;
    }

    public void asignaAntecedente(int[] antecedente) {
        for (int i = 0; i < antecedente.length; ++i) {
            this.antecedente[i] = antecedente[i];
        }
    }

    public void setConsequent(int clas) {
        this.clase = clas;
    }

    public double matching(double[] ejemplo) {
        return this.degreeMinimum(ejemplo);
    }

    private double degreeMinimum(double[] ejemplo) {
        double minimum = 1.0;
        for (int i = 0; i < this.antecedente.length; ++i) {
            double degree = this.dataBase.matching(i, this.antecedente[i], ejemplo[i]);
            minimum = Math.min(minimum, degree);
        }
        this.DF = minimum * this.Dconf;
        return this.DF;
    }

    public void setConfidence(double Dconf) {
        this.Dconf = Dconf;
    }

    public void setSupport(double Dsupp) {
        this.Dsupp = Dsupp;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setIni() {
        this.RightN = 0;
        this.WrongN = 0;
    }

    public void incrRightN() {
        ++this.RightN;
    }

    public void incrWrongN() {
        ++this.WrongN;
    }

    public void orderPrecede() {
        this.typeOrder = 0;
    }

    public void orderDF() {
        this.typeOrder = 1;
    }

    public double getConfidence() {
        return this.Dconf;
    }

    public double getSupport() {
        return this.Dsupp;
    }

    public long getTime() {
        return this.time;
    }

    public int getRightN() {
        return this.RightN;
    }

    public int getWrongN() {
        return this.WrongN;
    }

    public double getDF() {
        return this.DF;
    }

    public int getClas() {
        return this.clase;
    }

    public boolean isSubset(Rule a) {
        for (int k = 0; k < this.antecedente.length; ++k) {
            if (this.antecedente[k] <= -1 || this.antecedente[k] == a.antecedente[k]) continue;
            return false;
        }
        return true;
    }

    public void setLabel(int pos, int label) {
        this.antecedente[pos] = label;
    }

    public int compareTo(Object a) {
        if (this.typeOrder < 1) {
            if (((Rule)a).Dconf < this.Dconf) {
                return -1;
            }
            if (((Rule)a).Dconf > this.Dconf) {
                return 1;
            }
            if (((Rule)a).Dsupp < this.Dsupp) {
                return -1;
            }
            if (((Rule)a).Dsupp > this.Dsupp) {
                return 1;
            }
            if (((Rule)a).time < this.time) {
                return 1;
            }
            if (((Rule)a).time > this.time) {
                return -1;
            }
            return 0;
        }
        if (((Rule)a).DF < this.DF) {
            return -1;
        }
        if (((Rule)a).DF > this.DF) {
            return 1;
        }
        return 0;
    }
}

