/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.Slipper.Mask;
import keel.Algorithms.Rule_Learning.Slipper.MyDataset;
import keel.Algorithms.Rule_Learning.Slipper.SimpleRule;
import keel.Algorithms.Rule_Learning.Slipper.Stats;

public class Rule {
    public static int GREATER = SimpleRule.GREATER;
    public static int LOWER = SimpleRule.LOWER;
    public static int EQUAL = SimpleRule.EQUAL;
    private Vector chain = new Vector();
    private String type = "";
    private double Cr = Double.NaN;

    private boolean contains(SimpleRule sr) {
        boolean is_contained = false;
        for (int i = 0; i < this.chain.size() && !is_contained; ++i) {
            is_contained = sr.isEqual((SimpleRule)this.chain.elementAt(i));
        }
        return is_contained;
    }

    public int apply(MyDataset data, Mask select, int ignore) {
        int output = 0;
        select.resetIndex();
        while (select.next()) {
            double[] exemple = data.getExample(select);
            boolean salir = false;
            for (int j = 0; j < this.chain.size() && !salir; ++j) {
                if (data.isMissing(select, j) && j != ignore) {
                    salir = true;
                    continue;
                }
                if (j == ignore) continue;
                SimpleRule sr = (SimpleRule)this.chain.elementAt(j);
                int attribute = sr.getAttribute();
                double value = sr.getValue();
                salir = sr.isDiscret() ? exemple[sr.getAttribute()] != sr.getValue() : (sr.getOperator() == SimpleRule.GREATER ? !(exemple[sr.getAttribute()] > sr.getValue()) : !(exemple[sr.getAttribute()] <= sr.getValue()));
            }
            if (salir) continue;
            ++output;
        }
        return output;
    }

    public int apply(MyDataset data, Mask select) {
        return this.apply(data, select, -1);
    }

    public int apply(MyDataset data) {
        return this.apply(data, new Mask(data.size()), -1);
    }

    public Stats apply(MyDataset data, Mask positives, Mask negatives) {
        Stats stats = new Stats();
        stats.tp = this.apply(data, positives);
        stats.fn = positives.getnActive() - stats.tp;
        stats.fp = this.apply(data, negatives);
        stats.tn = negatives.getnActive() - stats.fp;
        return stats;
    }

    public static double getDefaultW(MyDataset data, Mask actives, double[] distribution) {
        double w = 0.0;
        actives.resetIndex();
        while (actives.next()) {
            w += distribution[actives.getIndex()];
        }
        return w;
    }

    public double getW(MyDataset data, Mask actives, double[] distribution) {
        double w = 0.0;
        Mask covered = actives.copy();
        data.filter(covered, this);
        covered.resetIndex();
        while (covered.next()) {
            w += distribution[covered.getIndex()];
        }
        return w;
    }

    public void setCr(MyDataset data, Mask positives, Mask negatives, double[] distribution) {
        double w_plus = this.getW(data, positives, distribution);
        double w_minus = this.getW(data, negatives, distribution);
        double n = positives.getnActive() + negatives.getnActive();
        this.Cr = 0.5 * Math.log((w_plus + 1.0 / (2.0 * n)) / (w_minus + 1.0 / (2.0 * n)));
    }

    public void setCr(double newCr) {
        this.Cr = newCr;
    }

    public double getCr() {
        return this.Cr;
    }

    public SimpleRule getSimpleRule(int i) {
        return (SimpleRule)this.chain.elementAt(i);
    }

    public void grow(int attribute, double value, int operator) {
        SimpleRule sr = new SimpleRule(attribute, value, operator);
        this.chain.add(sr);
    }

    public void grow(SimpleRule sr) {
        if (sr != null) {
            this.chain.add(sr);
        }
    }

    public void setType(String new_class) {
        this.type = new_class;
    }

    public String getType() {
        return this.type;
    }

    public Rule getCopy() {
        Rule r = new Rule();
        for (int i = 0; i < this.chain.size(); ++i) {
            r.grow(this.getSimpleRule(i).getCopy());
        }
        return r;
    }

    public void prune(int pos) {
        this.chain.remove(pos);
    }

    public int size() {
        return this.chain.size();
    }

    public boolean isEqual(Rule r) {
        if (this.chain.size() != r.size()) {
            return false;
        }
        boolean is_equal = true;
        for (int i = 0; i < r.size() && is_equal; ++i) {
            is_equal = this.contains(r.getSimpleRule(i));
        }
        return is_equal;
    }

    public String toString() {
        String output = "(";
        if (this.chain.size() != 0) {
            output = output + ((SimpleRule)this.chain.elementAt(0)).toString();
        }
        for (int i = 1; i < this.chain.size(); ++i) {
            output = output + " && " + ((SimpleRule)this.chain.elementAt(i)).toString();
        }
        output = output + ")";
        if (!this.type.equals("")) {
            output = output + "-> ";
            output = output + this.type;
        }
        output = output + " (" + this.Cr + ")";
        return output;
    }
}

