/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN_incremental_CL;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import keel.Algorithms.Neural_Networks.RBFN_incremental_CL.ProcDataset;
import keel.Algorithms.Neural_Networks.RBFN_incremental_CL.RBFUtils;
import keel.Algorithms.Neural_Networks.RBFN_incremental_CL.Rbfn;
import org.core.Randomize;

public class doRbfnIncCl {
    static String trnFile;
    static String tstFile;
    static String outTrnFile;
    static String outTstFile;
    static String outRbfFile;
    static double epsilon;
    static double delta;
    static double alfa;
    static double seed;
    static boolean reallySeed;

    private static boolean setParameters(String fileName) {
        Hashtable parameters = RBFUtils.parameters(fileName);
        RBFUtils.setVerbosity(parameters);
        String tmp = (String)((Vector)parameters.get("inputData")).get(0);
        trnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("inputData")).get(2);
        tstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(0);
        outTrnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(1);
        outTstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(2);
        outRbfFile = tmp.substring(1, tmp.length() - 1);
        epsilon = Double.parseDouble((String)((Vector)parameters.get("epsilon")).get(0));
        delta = Double.parseDouble((String)((Vector)parameters.get("delta")).get(0));
        alfa = Double.parseDouble((String)((Vector)parameters.get("alfa")).get(0));
        if (parameters.containsKey("seed")) {
            reallySeed = true;
            seed = Double.parseDouble((String)((Vector)parameters.get("seed")).get(0));
        } else {
            reallySeed = false;
        }
        RBFUtils.verboseln("Training file      : " + trnFile);
        RBFUtils.verboseln("Test file          : " + tstFile);
        RBFUtils.verboseln("Ouput Training file: " + outTrnFile);
        RBFUtils.verboseln("Ouput Test file    : " + outTstFile);
        RBFUtils.verboseln("Ouput RBF file     : " + outRbfFile);
        RBFUtils.verboseln("epsilon            : " + epsilon);
        RBFUtils.verboseln("delta              : " + delta);
        RBFUtils.verboseln("alfa               : " + alfa);
        RBFUtils.verbose("Seed               : ");
        if (reallySeed) {
            RBFUtils.verboseln("" + seed);
        } else {
            RBFUtils.verboseln("No seed, i.e., pure random execution");
        }
        RBFUtils.verboseln("Verbosity          : " + RBFUtils.getVerbosity());
        return trnFile != "" && tstFile != "" && outTrnFile != "" && outTstFile != "" && epsilon > 0.0 && alfa > 0.0 && delta > 0.0;
    }

    private static void doHelp() {
        System.out.println("Usage: doRbfnIncCl paramFile");
        System.out.println("       doRbfnIncCl --help");
        System.out.println("  Where: ");
        System.out.println("   paramFile  Name of file containing the parameters, according to Keel format.");
        System.out.println("              inputData = \"sintetica.trn\" \"sintetica.tst\" ");
        System.out.println("              outputData = \"result1.trn\" \"result1.tst\" \"result1.rbf\" ");
        System.out.println("\n---\nAuthors: Antonio Rivera (arivera@ujaen.es),  \n         Loli Perez (lperez@ujaen.es), \n         Victor Rivas  (vrivas@ujaen.es)\n         Univ. of Jaen (Spain) for Keel Project.\n\n");
    }

    public static void main(String[] args) throws IOException {
        try {
            ProcDataset Dtst;
            Rbfn net;
            int i;
            Object[] auxY;
            double[][] X;
            double[][] Y;
            int ndata;
            int nOutpl;
            int nInpt;
            ProcDataset Dtrn;
            if (args.length > 0 && (args[0].equals("--help") || args[0].equals("-help") || args[0].equals("-h") || args[0].equals("-?"))) {
                doRbfnIncCl.doHelp();
                return;
            }
            System.out.println("- Executing doRbfnInc " + args.length);
            String paramFile = args.length > 0 ? args[0] : "parameters.txt";
            doRbfnIncCl.setParameters(paramFile);
            System.out.println("    - Parameters file: " + paramFile);
            if (reallySeed) {
                Randomize.setSeed((long)seed);
            }
            if ((Dtrn = new ProcDataset(trnFile, true)).datasetType() == 0) {
                System.out.println("Modeling Dataset");
                Dtrn.processModelDataset();
                nInpt = Dtrn.getninputs();
                nOutpl = 1;
                ndata = Dtrn.getndata();
                Y = new double[ndata][1];
                X = Dtrn.getX();
                auxY = Dtrn.getY();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net = new Rbfn(nInpt, nOutpl);
                net.RAN(X, Y, ndata, delta, epsilon, alfa);
                double[] obtained = new double[ndata];
                net.testModeling(X, ndata, obtained);
                Dtrn.generateResultsModeling(outTrnFile, (double[])auxY, obtained);
                Dtst = new ProcDataset(tstFile, false);
                Dtst.processModelDataset();
                nInpt = Dtst.getninputs();
                nOutpl = 1;
                ndata = Dtst.getndata();
                X = Dtst.getX();
                auxY = Dtst.getY();
                Y = new double[ndata][1];
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                obtained = new double[ndata];
                net.testModeling(X, ndata, obtained);
                Dtst.generateResultsModeling(outTstFile, (double[])auxY, obtained);
                RBFUtils.createOutputFile("", outRbfFile);
                net.printRbfn(outRbfFile);
            }
            if (Dtrn.datasetType() == 1) {
                System.out.println("Clasification Dataset");
                Dtrn.processClassifierDataset();
                nInpt = Dtrn.getninputs();
                nOutpl = 1;
                ndata = Dtrn.getndata();
                Y = new double[ndata][1];
                X = Dtrn.getX();
                auxY = Dtrn.getC();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net = new Rbfn(nInpt, nOutpl);
                net.RAN(X, Y, ndata, delta, epsilon, alfa);
                int[] obtenido = new int[ndata];
                net.testClasification(X, ndata, obtenido, Dtrn.getnclasses() - 1, 0);
                Dtrn.generateResultsClasification(outTrnFile, (int[])auxY, obtenido);
                Dtst = new ProcDataset(tstFile, false);
                Dtst.processClassifierDataset();
                nInpt = Dtst.getninputs();
                nOutpl = 1;
                ndata = Dtst.getndata();
                Y = new double[ndata][1];
                obtenido = new int[ndata];
                X = Dtst.getX();
                auxY = Dtst.getC();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net.testClasification(X, ndata, obtenido, Dtrn.getnclasses() - 1, 0);
                Dtst.generateResultsClasification(outTstFile, (int[])auxY, obtenido);
                RBFUtils.createOutputFile(trnFile, outRbfFile);
                net.printRbfn(outRbfFile);
            }
            if (Dtrn.datasetType() == 2) {
                System.out.println("This is not a clustering algorithm");
            }
            System.out.println("- End of doRbfnInc. See results in output files named according to " + paramFile + " parameters file.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError(e.toString());
        }
    }
}

