/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.MCA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.MCA.PairOfPrototypes;
import keel.Algorithms.Instance_Generation.utilities.Distance;

class SymmetricDistanceMatrix {
    ArrayList<ArrayList<Double>> matrix;
    PrototypeSet original;

    public SymmetricDistanceMatrix() {
        this.matrix = new ArrayList();
    }

    protected void updateDistances() {
        int _size = this.original.size();
        this.matrix = new ArrayList(_size);
        for (int i = 0; i < _size; ++i) {
            this.matrix.add(new ArrayList(_size - i));
            for (int j = i + 1; j < _size; ++j) {
                this.matrix.get(i).add(Distance.dSquared((Prototype)this.original.get(i), (Prototype)this.original.get(j)));
            }
        }
    }

    public SymmetricDistanceMatrix(PrototypeSet V) {
        this.original = V;
        this.updateDistances();
    }

    public double get(int i, int j) {
        double value = 0.0;
        if (j > i) {
            value = this.matrix.get(i).get(j);
        } else if (j == i) {
            value = 0.0;
        } else if (j < i + 1) {
            int tmp = j;
            j = i;
            i = tmp;
            value = this.matrix.get(i).get(j);
        }
        return value;
    }

    ArrayList<PairOfPrototypes> sortByNearness() {
        ArrayList<PairOfPrototypes> pairs = new ArrayList<PairOfPrototypes>();
        int _size = this.original.size();
        for (int i = 0; i < _size; ++i) {
            for (int j = 0; j < _size; ++j) {
                if (i == j) continue;
                pairs.add(new PairOfPrototypes((Prototype)this.original.get(i), (Prototype)this.original.get(j)));
            }
        }
        Collections.sort(pairs);
        return pairs;
    }

    boolean remove(Prototype p) {
        boolean removed = false;
        int index = this.original.indexOf(p);
        int _size = this.original.size();
        if (index > -1 && index < _size) {
            this.original.remove(index);
            removed = true;
        }
        return removed;
    }

    boolean remove(Prototype p, boolean makeUpdate) {
        boolean removed = false;
        int index = this.original.indexOf(p);
        int _size = this.original.size();
        if (index > -1 && index < _size) {
            this.original.remove(index);
            if (makeUpdate) {
                this.updateDistances();
            }
            removed = true;
        }
        return removed;
    }
}

