/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.DataBase;

public class Rule
implements Comparable {
    int[] antecedent;
    int clas;
    int nAnts;
    double conf;
    double supp;
    DataBase dataBase;

    public Rule(Rule r) {
        this.antecedent = new int[r.antecedent.length];
        for (int k = 0; k < this.antecedent.length; ++k) {
            this.antecedent[k] = r.antecedent[k];
        }
        this.clas = r.clas;
        this.dataBase = r.dataBase;
        this.conf = r.conf;
        this.supp = r.supp;
        this.nAnts = r.nAnts;
    }

    public Rule(DataBase dataBase) {
        this.antecedent = new int[dataBase.numVariables()];
        for (int i = 0; i < this.antecedent.length; ++i) {
            this.antecedent[i] = -1;
        }
        this.clas = -1;
        this.dataBase = dataBase;
        this.conf = 0.0;
        this.supp = 0.0;
        this.nAnts = 0;
    }

    public Rule clone() {
        Rule r = new Rule(this.dataBase);
        r.antecedent = new int[this.antecedent.length];
        for (int i = 0; i < this.antecedent.length; ++i) {
            r.antecedent[i] = this.antecedent[i];
        }
        r.clas = this.clas;
        r.dataBase = this.dataBase;
        r.conf = this.conf;
        r.supp = this.supp;
        r.nAnts = this.nAnts;
        return r;
    }

    public void asignaAntecedente(int[] antecedent) {
        this.nAnts = 0;
        for (int i = 0; i < antecedent.length; ++i) {
            this.antecedent[i] = antecedent[i];
            if (this.antecedent[i] <= -1) continue;
            ++this.nAnts;
        }
    }

    public void setConsequent(int clas) {
        this.clas = clas;
    }

    public double matching(double[] example) {
        return this.degreeProduct(example);
    }

    private double degreeProduct(double[] example) {
        double degree = 1.0;
        for (int i = 0; i < this.antecedent.length && degree > 0.0; degree *= this.dataBase.matching(i, this.antecedent[i], example[i]), ++i) {
        }
        return degree * this.conf;
    }

    public void setConfidence(double conf) {
        this.conf = conf;
    }

    public void setSupport(double supp) {
        this.supp = supp;
    }

    public double getConfidence() {
        return this.conf;
    }

    public double getSupport() {
        return this.supp;
    }

    public int getClas() {
        return this.clas;
    }

    public boolean isSubset(Rule a) {
        if (this.clas != a.clas || this.nAnts > a.nAnts) {
            return false;
        }
        for (int k = 0; k < this.antecedent.length; ++k) {
            if (this.antecedent[k] <= -1 || this.antecedent[k] == a.antecedent[k]) continue;
            return false;
        }
        return true;
    }

    public void setLabel(int pos, int label) {
        if (this.antecedent[pos] < 0 && label > -1) {
            ++this.nAnts;
        }
        if (this.antecedent[pos] > -1 && label < 0) {
            --this.nAnts;
        }
        this.antecedent[pos] = label;
    }

    public int compareTo(Object a) {
        if (((Rule)a).nAnts < this.nAnts) {
            return 1;
        }
        if (((Rule)a).nAnts > this.nAnts) {
            return -1;
        }
        return 0;
    }
}

