/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut.util;

import weka.core.Instance;

public class DataObject {
    private int id;
    private Instance inst;
    private double[] features;
    private int classLabel;
    private boolean isOutiler;

    public double[] getFeatures() {
        double[] filteredFeatures = new double[this.features.length - 1];
        for (int i = 0; i < filteredFeatures.length; ++i) {
            filteredFeatures[i] = this.features[i];
        }
        return filteredFeatures;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getClassLabel() {
        return this.classLabel;
    }

    public Instance getInstance() {
        return this.inst;
    }

    public DataObject(int idCounter, Instance inst) {
        this.id = idCounter;
        this.inst = inst;
        this.features = inst.toDoubleArray();
        this.classLabel = (int)inst.classValue();
        this.isOutiler = false;
    }

    public int getNrOfDimensions() {
        return this.features.length - 1;
    }

    public String toString() {
        String res = "(";
        for (int i = 0; i < this.features.length; ++i) {
            double d = this.features[i];
            res = res + d;
            if (i == this.features.length - 1) continue;
            res = res + ",";
        }
        res = res + ")";
        res = res + "[" + this.classLabel + "]";
        return res;
    }

    public void setOutiler(boolean val) {
        this.isOutiler = val;
    }

    public boolean isOutiler() {
        return this.isOutiler;
    }
}

