## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----include = FALSE----------------------------------------------------------
# Set up a temp directory and set it as the root directory for all chunks
temp_dir <- tempdir()
knitr::opts_knit$set(root.dir = temp_dir)

## ----setup--------------------------------------------------------------------
library(basepenguins)

## -----------------------------------------------------------------------------
# List all example files
example_files()

## -----------------------------------------------------------------------------
penguins_script <- example_files("penguins.R")
cat(readLines(penguins_script), sep = "\n")

## -----------------------------------------------------------------------------
# Copy all example files to a new subdirectory of the working directory
example_dir("examples")

# List the files in the copied directory
list.files("examples", recursive = TRUE)

## -----------------------------------------------------------------------------
# Convert a single file to a new output file
convert_files(penguins_script, "converted_penguins.R")

## -----------------------------------------------------------------------------
# Look at the converted file
cat(readLines("converted_penguins.R"), sep = "\n")

## -----------------------------------------------------------------------------
result <- convert_dir("examples", "converted_examples")
result

## -----------------------------------------------------------------------------
example_dir("in_place_dir")

result <- convert_dir_inplace("in_place_dir")
result

## -----------------------------------------------------------------------------
# List all files with convertible extensions in a directory
potential_files <- files_to_convert("examples")
potential_files

## -----------------------------------------------------------------------------
# Only look for R scripts
files_to_convert("examples", extensions = "R")

## -----------------------------------------------------------------------------
# All extensions
files_to_convert("examples", extensions = NULL)

## -----------------------------------------------------------------------------
input_files <- files_to_convert("examples")

# Default
output_paths(input_files)

## -----------------------------------------------------------------------------
# Generate output paths with prefix instead, in new directory
output_paths(input_files, prefix = "base_", suffix = "", dir = "~/output")

## ----eval = FALSE-------------------------------------------------------------
#  penguins |>
#    select(bill_len, bill_dep) |>
#    select(flipper_len, starts_with("bill_"))

## -----------------------------------------------------------------------------
no_penguins_file <- "examples/no_penguins.Rmd"
cat(readLines(no_penguins_file), sep = "\n")

## -----------------------------------------------------------------------------
# Pass it to a convert function
convert_files(no_penguins_file, "no_penguins_converted.Rmd")

# The content doesn't change
cat(readLines("no_penguins_converted.Rmd"), sep = "\n")

