## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(branchingprocess)

## -----------------------------------------------------------------------------
pNextGenSize(x=2, y=5, R=0.8, k=0.1)

## -----------------------------------------------------------------------------
pNextGenSize(x=2, y=c(0,1,5,10), R=0.8, k=10)*100
pNextGenSize(x=2, y=c(0,1,5,10), R=0.8, k=0.1)*100

## -----------------------------------------------------------------------------
pFinalSize(n=2, j=12, R=0.8, k=0.1)

## -----------------------------------------------------------------------------
pClusterSizes <- function(R,k) pFinalSize(n=1, j=c(1,2,20,50), R=R, k=k)

## -----------------------------------------------------------------------------
pClusterSizes(R = 1.5, k = 1) * 100

## -----------------------------------------------------------------------------
logLikData <- function(R,k) sum(c(25,3,1,1)*log(pClusterSizes(R,k)))

## -----------------------------------------------------------------------------
exp(logLikData(1.5,1))

## -----------------------------------------------------------------------------
optim(f = function(x) ifelse(all(x>0), -logLikData(x[1],x[2]), Inf), par = c(R=1,k=1))$par

## -----------------------------------------------------------------------------
pClusterSizesSwitch1 <- function(R0,k0) Vectorize(pFinalSizeSwitch1)(n=1, j=c(1,2,20,50), R0=R0, k0=k0, Rc=R0/2, kc=k0)
logLikDataSwitch1 <- function(R0,k0) sum(c(25,3,1,1)*log(pClusterSizesSwitch1(R0,k0)))
optim(f = function(x) ifelse(all(x>0), -logLikDataSwitch1(x[1],x[2]), Inf), par = c(R0=1,k0=1))$par

## -----------------------------------------------------------------------------
finalSize10 <- Vectorize(pFinalSizeAndGen,'g')(g=1:9,n=1,j=10,R=0.8,k=0.07)
finalSize10
c(sum(finalSize10), pFinalSize(n=1,j=10,R=0.8,k=0.07))

## -----------------------------------------------------------------------------
pClusterSizeAndGen <- function(R,k) Vectorize(pFinalSizeAndGen)(g=c(0,1,3,4),n=1, j=c(1,2,20,50), R=R, k=k)
logLikDataGen <- function(R,k) sum(c(25,3,1,1)*log(pClusterSizeAndGen(R,k)))
optim(f = function(x) ifelse(all(x>0), -logLikDataGen(x[1],x[2]), Inf), par = c(R=1,k=1))$par

## -----------------------------------------------------------------------------
pClusterSizeAndGenControl <- function(R0,Rc,k) Vectorize(pFinalSizeAndGenSwitch1)(g=c(0,1,3,4),n=1, j=c(1,2,20,50), R0=R0, k0=k, Rc=Rc, kc=k)
logLikDataGenControl <- function(R0,Rc,k) sum(c(25,3,1,1)*log(pClusterSizeAndGenControl(R0,Rc,k)))
optim(f = function(x) ifelse(all(x>0), -logLikDataGenControl(x[1],x[2],x[3]), Inf), par = c(R0=1,Rc=1,k=1))$par

## -----------------------------------------------------------------------------
1-sum(pFinalSize(1,1:99,0.7,0.08))

## -----------------------------------------------------------------------------
1-sum(Vectorize(pFinalSizeSwitch1)(1,1:99,R0=1.08,k0=0.06,Rc=0.54,kc=0.06))

## -----------------------------------------------------------------------------
1-sum(pFinalSize(1,1:99,R=1.08,k=0.06))

## -----------------------------------------------------------------------------
1-pExtinct(R=1.08,k=0.06)

## -----------------------------------------------------------------------------
pGen(gMax=10,R=0.7,k=0.08)

## -----------------------------------------------------------------------------
pGenSwitch1(gMax=10,R0=1.08,k0=0.06,Rc=0.54,kc=0.06)

## -----------------------------------------------------------------------------
pSizeAtGen(g=2,n=1,j=10,R=0.7,k=0.08)
pSizeAtGenSwitch1(g=2,n=1,j=10,R0=1.08,k0=0.06,Rc=0.54,kc=0.06)

