## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## -----------------------------------------------------------------------------
# install.packages('netknitr')
# netknitr::knitNet()

## -----------------------------------------------------------------------------
# install.packages('netknitr')
library(netknitr)
library(dplyr)
library(visNetwork)

## ----attr.message=F, attr.warning=F, cache=FALSE------------------------------
set.seed(0009)

mtcars$name <- row.names(mtcars)
cols <- c('gear', 'name', "cyl")
my_data <- mtcars[,cols]
my_data

## -----------------------------------------------------------------------------
res <- lapply(names(my_data), FUN = function(i) {
  paste0(i, " : ", my_data[[i]])
}) %>% do.call('cbind', .) %>% as.data.frame()
names(res) <- names(my_data)
res %>% head()
my_data <- res
head(my_data)

## ----pressure, echo=FALSE-----------------------------------------------------
nodes <- getNodes(my_data, columns_for_nodes = cols, group = TRUE)
nodes

## -----------------------------------------------------------------------------
nodes$shape <- getShapes(nodes)
nodes$colors <- sample(c("darkred", "grey", "orange", "darkblue", "purple", 'green'), nrow(nodes), replace = T)
head(nodes)

## -----------------------------------------------------------------------------
associations <- getAssociation(my_data[,cols])
edges <- getEdges(associations, nodes)
head(edges)

## -----------------------------------------------------------------------------
createVisNetwork(nodes, edges)

