## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  message = FALSE,
  warning = FALSE,
  error = FALSE,
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo = FALSE------------------------------------------------------
library(oldr)

## ----workflow, echo = FALSE, eval = TRUE, fig.alt = "RAM-OP workflow", out.width = "80%"----
knitr::include_graphics("figures/ramOPworkflow.png")

## ----data, echo = TRUE, eval = TRUE-------------------------------------------
testSVY

## ----step1, echo = TRUE, eval = FALSE-----------------------------------------
# ## Process and recode all standard RAM-OP indicators in the testSVY dataset
# create_op(svy = testSVY)

## ----step1a, echo = FALSE, eval = TRUE----------------------------------------
## Process and recode all standard RAM-OP indicators in the testSVY dataset
create_op(svy = testSVY)

## ----bbw, echo = FALSE, eval = TRUE, fig.alt = "Blocked weighted bootstrap", fig.align = "center", out.width = "85%"----
knitr::include_graphics(path = "https://rapidsurveys.io/ramOPmanual/figures/bbw.png")

## ----probit, echo = FALSE, eval = TRUE, fig.alt = "RAM-OP estimators", out.width = "100%", fig.align = "center"----
knitr::include_graphics(path = "https://rapidsurveys.io/ramOPmanual/figures/indicators26.png")

## ----classicEstimator, echo = TRUE, eval = FALSE------------------------------
# ## Process and recode RAM-OP data (testSVY)
# df <- create_op(svy = testSVY)
# 
# ## Perform classic estimation on recoded data using appropriate weights provided by testPSU
# classicDF <- estimate_classic(x = df, w = testPSU)

## ----classicEstimatorX, echo = FALSE, eval = TRUE-----------------------------
## Process and recode RAM-OP data (testSVY)
df <- create_op(svy = testSVY)

## Perform classic estimation on recoded data using appropriate weights provided by testPSU
classicDF <- estimate_classic(x = df, w = testPSU, replicates = 9)

## Return results
classicDF

## ----probitEstimator, echo = TRUE, eval = FALSE-------------------------------
# ## Process and recode RAM-OP data (testSVY)
# df <- create_op(svy = testSVY)
# 
# ## Perform probit estimation on recoded data using appropriate weights provided by testPSU
# probitDF <- estimate_probit(x = df, w = testPSU)

## ----probitEstimatorX, echo = FALSE, eval = TRUE------------------------------
## Process and recode RAM-OP data (testSVY)
df <- create_op(svy = testSVY)

## Perform classic estimation on recoded data using appropriate weights provided by testPSU
probitDF <- estimate_probit(x = df, w = testPSU, replicates = 9)

## Return results
probitDF

## ----mergeResults, echo = TRUE, eval = FALSE----------------------------------
# ## Merge classicDF and probitDF
# resultsDF <- merge_op(x = classicDF, y = probitDF)
# 
# resultsDF

## ----mergeResultsX, echo = FALSE, eval = TRUE---------------------------------
## Merge classicDF and probitDF
resultsDF <- merge_op(x = classicDF, y = probitDF)

resultsDF

## ----chartADL, echo = TRUE, eval = TRUE---------------------------------------
chart_op_adl(x = create_op(testSVY), filename = file.path(tempdir(), "test"))

## ----checkChart, echo = TRUE, eval = TRUE-------------------------------------
file.exists(path = file.path(tempdir(), "test.png"))

## ----showChart, echo = FALSE, eval = TRUE, fig.alt = "RAM-OP chart showing information on activities of daily living", out.width = "85%", fig.align = "center"----
#knitr::include_graphics(path = "man/figures/test.ADL.png")
chart_op_adl(x = create_op(testSVY), save_chart = FALSE)

## ----report, echo = TRUE, eval = TRUE-----------------------------------------
report_op_table(estimates = resultsDF, filename = file.path(tempdir(), "TEST"))

## ----checkTable, echo = TRUE, eval = TRUE-------------------------------------
file.exists(path = file.path(tempdir(), "TEST.csv"))

## ----showTable, echo = FALSE, eval = TRUE-------------------------------------
read.csv(
  file = file.path(tempdir(), "TEST.report.csv"),
  stringsAsFactors = FALSE
)

## ----estimatePipe1, echo = TRUE, eval = TRUE----------------------------------
testSVY |>
  create_op() |>
  estimate_op(w = testPSU, replicates = 9) |>
  report_op_table(filename = file.path(tempdir(), "TEST"))

## ----estimatePipe2, echo = TRUE, eval = TRUE----------------------------------
file.exists(file.path(tempdir(), "TEST.report.csv"))

## ----estimatePipe3, echo = FALSE, eval = TRUE---------------------------------
read.csv(
  file = paste(tempdir(), "TEST.report.csv", sep = "/"), 
  stringsAsFactors = FALSE
)

## ----estimateReport1, echo = TRUE, eval = FALSE-------------------------------
# testSVY |>
#   create_op() |>
#   estimate_op(w = testPSU, replicates = 9) |>
#   report_op_html(
#     svy = testSVY, filename = file.path(tempdir(), "ramOPreport")
#   )

## ----estimateReport2, echo = FALSE, eval = TRUE, fig.alt = "Example of a RAM-OP HTML report"----
knitr::include_graphics("figures/htmlReport.png")

