/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionaryEntryPersistor;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.model.DictionarySerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class Dictionary
implements Iterable<StringList>,
SerializableArtifact {
    private Set<StringListWrapper> entrySet = new HashSet<StringListWrapper>();
    private final boolean isCaseSensitive;
    private int minTokenCount = 99999;
    private int maxTokenCount = 0;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public Dictionary(InputStream in) throws IOException {
        this.isCaseSensitive = DictionaryEntryPersistor.create(in, entry -> this.put(entry.getTokens()));
    }

    public void put(StringList tokens) {
        this.entrySet.add(new StringListWrapper(tokens));
        this.minTokenCount = Math.min(this.minTokenCount, tokens.size());
        this.maxTokenCount = Math.max(this.maxTokenCount, tokens.size());
    }

    public int getMinTokenCount() {
        return this.minTokenCount;
    }

    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public boolean contains(StringList tokens) {
        return this.entrySet.contains(new StringListWrapper(tokens));
    }

    public void remove(StringList tokens) {
        this.entrySet.remove(new StringListWrapper(tokens));
    }

    @Override
    public Iterator<StringList> iterator() {
        final Iterator<StringListWrapper> entries = this.entrySet.iterator();
        return new Iterator<StringList>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public StringList next() {
                return ((StringListWrapper)entries.next()).getStringList();
            }

            @Override
            public void remove() {
                entries.remove();
            }
        };
    }

    public int size() {
        return this.entrySet.size();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entryIterator = new Iterator<Entry>(){
            private Iterator<StringList> dictionaryIterator;
            {
                this.dictionaryIterator = Dictionary.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.dictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList tokens = this.dictionaryIterator.next();
                return new Entry(tokens, new Attributes());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionaryEntryPersistor.serialize(out, entryIterator, this.isCaseSensitive);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)obj;
            result = this.entrySet.equals(dictionary.entrySet);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.entrySet.hashCode();
    }

    public String toString() {
        return this.entrySet.toString();
    }

    public static Dictionary parseOneEntryPerLine(Reader in) throws IOException {
        String line;
        BufferedReader lineReader = new BufferedReader(in);
        Dictionary dictionary = new Dictionary();
        while ((line = lineReader.readLine()) != null) {
            StringTokenizer whiteSpaceTokenizer = new StringTokenizer(line, " ");
            String[] tokens = new String[whiteSpaceTokenizer.countTokens()];
            if (tokens.length <= 0) continue;
            int tokenIndex = 0;
            while (whiteSpaceTokenizer.hasMoreTokens()) {
                tokens[tokenIndex++] = whiteSpaceTokenizer.nextToken();
            }
            dictionary.put(new StringList(tokens));
        }
        return dictionary;
    }

    public Set<String> asStringSet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator entries = Dictionary.this.entrySet.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((StringListWrapper)entries.next()).getStringList().getToken(0);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Dictionary.this.entrySet.size();
            }

            @Override
            public boolean contains(Object obj) {
                boolean result = false;
                if (obj instanceof String) {
                    String str = (String)obj;
                    result = Dictionary.this.entrySet.contains(new StringListWrapper(new StringList(str)));
                }
                return result;
            }
        };
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return DictionarySerializer.class;
    }

    private class StringListWrapper {
        private final StringList stringList;

        private StringListWrapper(StringList stringList) {
            this.stringList = stringList;
        }

        private StringList getStringList() {
            return this.stringList;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof StringListWrapper) {
                StringListWrapper other = (StringListWrapper)obj;
                result = Dictionary.this.isCaseSensitive ? this.stringList.equals(other.getStringList()) : this.stringList.compareToIgnoreCase(other.getStringList());
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return StringUtil.toLowerCase(this.stringList.toString()).hashCode();
        }

        public String toString() {
            return this.stringList.toString();
        }
    }
}

