/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleFamily;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.ruleFamily.Coverage;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.ruleSet.SelectRules;
import dmLab.classifier.adx.selector.SelectorList;
import dmLab.utils.ArrayUtils;
import dmLab.utils.GeneralUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.list.ObjectList;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public final class RuleFamily {
    private RuleSet[] ruleSetArray;
    public SelectorList[] selectorListArray;
    private FArray trainArray;
    private double[] classSensitivity;
    private ADXParams adxParams;
    private double[] scores;
    private float finalSelectionTime = 0.0f;
    public boolean verbose = false;

    public RuleFamily(int decisionValuesNumber, int maxComplexLength, ADXParams adxParams) {
        this.adxParams = adxParams;
        this.ruleSetArray = new RuleSet[decisionValuesNumber];
        this.selectorListArray = new SelectorList[decisionValuesNumber];
        this.classSensitivity = new double[decisionValuesNumber];
        Arrays.fill(this.classSensitivity, 1.0);
        for (int i = 0; i < this.ruleSetArray.length; ++i) {
            this.ruleSetArray[i] = new RuleSet(maxComplexLength, adxParams);
            this.selectorListArray[i] = new SelectorList();
        }
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean createRules(FArray trainArray) {
        float[] decisionValues = trainArray.getDecValues();
        int decisionValuesNumber = decisionValues.length;
        int eventNumber = ((Array)trainArray).rowsNumber();
        this.trainArray = trainArray;
        this.init();
        for (int decValIndex = 0; decValIndex < decisionValuesNumber; ++decValIndex) {
            void var2_8;
            int n;
            int n2;
            RuleSet ruleSet;
            Object object;
            if (this.verbose) {
                System.out.println("-----> Building Rules for Decision: " + trainArray.attributes[trainArray.getDecAttrIdx()].name + "=" + ((Array)trainArray).getDecValuesStr()[decValIndex] + " <-----");
            }
            this.selectorListArray[decValIndex] = new SelectorList();
            this.selectorListArray[decValIndex].verbose = this.verbose;
            if (this.verbose) {
                System.out.println("Creating selectors base...");
            }
            this.selectorListArray[decValIndex].createSelectorBase(trainArray, decValIndex);
            if (this.verbose) {
                System.out.println(" Selectors base created. Selectors base size = " + this.selectorListArray[decValIndex].size());
            }
            if (this.verbose) {
                System.out.println("Creating rules...");
            }
            this.ruleSetArray[decValIndex].createRules(trainArray, this.selectorListArray[decValIndex], decValIndex);
            this.ruleSetArray[decValIndex].deleteComplexesPosLessNeg();
            if (this.adxParams.mergeCondition != 0) {
                if (this.verbose) {
                    System.out.print("Merging rules...");
                }
                FArray fArray = trainArray;
                object = this.selectorListArray[decValIndex];
                ruleSet = this.ruleSetArray[decValIndex];
                for (n2 = 0; n2 < ruleSet.complexSetArray.length; ++n2) {
                    if (ruleSet.complexSetArray[n2] == null) continue;
                    ruleSet.complexSetArray[n2].mergeComplexes((SelectorList)object, fArray);
                }
                if (this.verbose) {
                    System.out.println(" Rules merged.");
                }
            }
            if (this.adxParams.useSensitivity == 1) {
                this.classSensitivity[decValIndex] = this.adxParams.getSensitivity(decValIndex);
            } else {
                FArray fArray = trainArray;
                double posEvents = fArray.getADXDomain(fArray.getDecAttrIdx()).getTotalPositives(decValIndex);
                this.classSensitivity[decValIndex] = posEvents / (double)eventNumber;
                if (this.verbose) {
                    System.out.println(" Probability of the class occurence = " + GeneralUtils.formatFloat(this.classSensitivity[decValIndex], 5));
                }
            }
            if (this.verbose) {
                System.out.print("Calculating Coverages...");
                Coverage coverage = RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]);
                RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]).precision = 5;
                System.out.println(coverage.toString());
            }
            long start = System.currentTimeMillis();
            Object selectRules = new SelectRules();
            if (this.verbose) {
                System.out.print("Selecting significant rules...");
            }
            if (this.adxParams.selSignificantMethod == 0) {
                ruleSet = this.ruleSetArray[decValIndex];
                int n3 = 0;
                for (int i = 0; i < ruleSet.complexSetArray.length; ++i) {
                    if (ruleSet.complexSetArray[i] != null) {
                        ruleSet.complexSetArray[i].deleteComplexesCoversNeg();
                        ++n3;
                    }
                    if (ruleSet.complexSetArray[i] == null || ruleSet.complexSetArray[i].size() != 0) continue;
                    ruleSet.complexSetArray[i] = null;
                }
            } else if (this.adxParams.selSignificantMethod == 1) {
                this.ruleSetArray[decValIndex].deleteComplexesPosLessNeg();
            } else if (this.adxParams.selSignificantMethod == 2) {
                double d = this.adxParams.qMin;
                ruleSet = this.ruleSetArray[decValIndex];
                n2 = 0;
                for (n = 0; n < ruleSet.complexSetArray.length; ++n) {
                    if (ruleSet.complexSetArray[n] != null) {
                        n2 += ruleSet.complexSetArray[n].deleteComplexesQLess(d);
                    }
                    if (ruleSet.complexSetArray[n] == null || ruleSet.complexSetArray[n].size() != 0) continue;
                    ruleSet.complexSetArray[n] = null;
                }
            } else if (this.adxParams.selSignificantMethod == 3) {
                int n4;
                int n5 = this.adxParams.getFinalBeam(decValIndex);
                object = this.adxParams;
                ruleSet = this.ruleSetArray[decValIndex];
                n = 0;
                n2 = 0;
                for (n4 = 0; n4 < ruleSet.complexSetArray.length; ++n4) {
                    if (ruleSet.complexSetArray[n4] == null) continue;
                    n += ruleSet.complexSetArray[n4].size();
                }
                if (n <= n5) {
                    n2 = 0 + ruleSet.deleteComplexesPosLessNeg();
                } else {
                    int n6;
                    int n7 = ((ADXParams)object).qMethodFinal;
                    int n8 = n5;
                    selectRules = ruleSet;
                    double[] dArray = new double[n8];
                    Arrays.fill(dArray, Double.NEGATIVE_INFINITY);
                    int n9 = dArray.length;
                    for (n6 = 0; n6 < ((RuleSet)selectRules).complexSetArray.length; ++n6) {
                        if (((RuleSet)selectRules).complexSetArray[n6] == null) continue;
                        int n10 = ((RuleSet)selectRules).complexSetArray[n6].size();
                        for (n4 = 0; n4 < n10; ++n4) {
                            Complex complex = ((RuleSet)selectRules).complexSetArray[n6].getComplex(n4);
                            if (!complex.reproduce) continue;
                            double d = complex.calcQuality(n7);
                            if (n9 > 0) {
                                dArray[--n9] = d;
                                continue;
                            }
                            if (!(dArray[0] < d)) continue;
                            dArray[0] = d;
                            Arrays.sort(dArray);
                        }
                    }
                    if (n9 > 0) {
                        Arrays.sort(dArray);
                    }
                    double d = dArray[n9];
                    selectRules = new ObjectList();
                    for (n8 = 0; n8 < ruleSet.complexSetArray.length; ++n8) {
                        if (ruleSet.complexSetArray[n8] == null) continue;
                        n7 = ruleSet.complexSetArray[n8].size();
                        for (n9 = 0; n9 < n7; ++n9) {
                            double d2;
                            Complex complex = ruleSet.complexSetArray[n8].getComplex(n9);
                            double d3 = complex.calcQuality(((ADXParams)object).qMethodFinal);
                            if (d2 < d) {
                                ruleSet.complexSetArray[n8].removeComplex(n9);
                                ++n2;
                                continue;
                            }
                            if (d3 != d) continue;
                            ((ObjectList)selectRules).add(new ComplexLink(complex, n8, n9, d3));
                        }
                    }
                    if (n5 < n - n2) {
                        n8 = n - n2 - n5;
                        int[] nArray = new int[((ObjectList)selectRules).size()];
                        ArrayUtils arrayUtils = new ArrayUtils();
                        arrayUtils.randomSelect(nArray, n8, 1, 0);
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            if (nArray[n6] != 1) continue;
                            ComplexLink complexLink = (ComplexLink)((ObjectList)selectRules).get(n6);
                            ruleSet.complexSetArray[complexLink.setIndex].removeComplex(complexLink.complexIndex);
                            ++n2;
                        }
                    }
                }
                for (n4 = 0; n4 < ruleSet.complexSetArray.length; ++n4) {
                    if (ruleSet.complexSetArray[n4] == null) continue;
                    ruleSet.complexSetArray[n4].trimList();
                    if (ruleSet.complexSetArray[n4].size() != 0) continue;
                    ruleSet.complexSetArray[n4] = null;
                }
            } else if (this.adxParams.selSignificantMethod == 4) {
                ((SelectRules)selectRules).selectMinFinalRuleSet_fast(this.ruleSetArray[decValIndex], trainArray, this.selectorListArray[decValIndex], this.adxParams, this.adxParams.getFinalBeam(decValIndex));
            } else {
                System.err.println("Incorrect adxParams.selSignificantMethod");
            }
            long stop = System.currentTimeMillis();
            this.finalSelectionTime += (float)(stop - start) / 1000.0f;
            if (!this.verbose) continue;
            System.out.println(" Significant rules have been selected.");
            System.out.print("Calculating Coverages...");
            Coverage coverage = RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]);
            RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]).precision = 5;
            System.out.println(var2_8.toString());
        }
        return true;
    }

    public final void saveRuleFamily(String inputFileName) {
        for (int decisionValIndex = 0; decisionValIndex < this.trainArray.getDecValues().length; ++decisionValIndex) {
            FileWriter fileWriter;
            String string = inputFileName + "_" + ((Array)this.trainArray).getDecValuesStr()[decisionValIndex];
            FArray fArray = this.trainArray;
            SelectorList selectorList = this.selectorListArray[decisionValIndex];
            RuleSet ruleSet = this.ruleSetArray[decisionValIndex];
            try {
                fileWriter = new FileWriter(string + ".rls");
            }
            catch (IOException iOException) {
                System.err.println("Error opening file. File: " + string + ".rls");
                continue;
            }
            try {
                fileWriter.write(ruleSet.toString(selectorList, fArray));
                fileWriter.close();
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error writing file. File: " + string + ".rls");
                iOException.printStackTrace();
            }
        }
    }

    public final void prepareClassification() {
        for (int i = 0; i < this.ruleSetArray.length; ++i) {
            this.ruleSetArray[i].createLinks(this.adxParams);
            this.ruleSetArray[i].calcGlobalParams();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float classifyEvent2(FArray array, int eventIndex) {
        int n;
        block9: {
            int i;
            float[] decisionValues = array.getDecValues();
            this.scores = this.calcScores(array, eventIndex, false);
            if (this.adxParams.useSensitivity == 1 || this.adxParams.useSensitivity == 2) {
                for (int i2 = 0; i2 < this.scores.length; ++i2) {
                    int n2 = i2;
                    this.scores[n2] = this.scores[n2] * this.classSensitivity[i2];
                }
            }
            int maxIndex = ArrayUtils.maxIndex(this.scores);
            if (this.adxParams.scoreMethod >= 6 && maxIndex == -1) {
                void var2_4;
                this.scores = this.calcScores(array, (int)var2_4, true);
                maxIndex = ArrayUtils.maxIndex(this.scores);
            }
            if ((float)maxIndex != -1.0f) {
                void var3_7;
                return (float)var3_7[maxIndex];
            }
            if (MathUtils.sum(this.scores) != 0.0) {
                for (i = 0; i < this.scores.length; ++i) {
                    int n3 = i;
                    this.scores[n3] = this.scores[n3] * this.classSensitivity[i];
                }
            } else {
                for (i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = this.classSensitivity[i];
                }
            }
            double[] dArray = this.classSensitivity;
            double d = MathUtils.sum(this.classSensitivity);
            Random random = new Random();
            double d2 = random.nextDouble() * d;
            d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(d2 <= (d += dArray[j]))) continue;
                n = j;
                break block9;
            }
            n = -1;
        }
        int n4 = n;
        return n;
    }

    public final double[] getLastScores() {
        return this.scores;
    }

    private double[] calcScores(FArray array, int eventIndex, boolean useAlternativeScore) {
        double[] scores = new double[array.getDecValues().length];
        for (int i = 0; i < this.ruleSetArray.length; ++i) {
            scores[i] = !useAlternativeScore ? this.ruleSetArray[i].calcScore(this.selectorListArray[i], array, eventIndex) : this.ruleSetArray[i].complexLinks.alternativeScore;
        }
        return scores;
    }

    public final void saveSymbolicSelectors(String fileName) {
        for (int decisionValIndex = 0; decisionValIndex < this.selectorListArray.length; ++decisionValIndex) {
            this.selectorListArray[decisionValIndex].save(fileName + "_" + ((Array)this.trainArray).getDecValuesStr()[decisionValIndex]);
        }
    }

    public final void saveSelectors(String fileName) {
        for (int decisionValIndex = 0; decisionValIndex < this.selectorListArray.length; ++decisionValIndex) {
            this.selectorListArray[decisionValIndex].save(fileName + "_" + ((Array)this.trainArray).getDecValuesStr()[decisionValIndex], this.trainArray);
        }
    }

    private static Coverage calcCoverage(FArray array, RuleSet ruleSet, SelectorList selectorList, float decVal) {
        int covered = 0;
        int posCovered = 0;
        int pos = 0;
        int negCovered = 0;
        int neg = 0;
        int eventsNumber = ((Array)array).rowsNumber();
        int decisionId = array.getDecAttrIdx();
        for (int i = 0; i < eventsNumber; ++i) {
            float dec = array.readValue(decisionId, i);
            if (dec == decVal) {
                ++pos;
            } else {
                ++neg;
            }
            if (!ruleSet.covers(selectorList, array, i)) continue;
            ++covered;
            if (dec == decVal) {
                ++posCovered;
                continue;
            }
            ++negCovered;
        }
        Coverage coverage = new Coverage();
        new Coverage().coverage = (float)covered / (float)eventsNumber;
        coverage.posCoverage = (float)posCovered / (float)pos;
        coverage.negCoverage = (float)negCovered / (float)neg;
        return coverage;
    }

    public final int ruleSets() {
        return this.ruleSetArray.length;
    }

    /*
     * WARNING - void declaration
     */
    public final RuleSet getRuleSet(int index) {
        if (index >= 0 && index < this.ruleSetArray.length) {
            void var1_1;
            return this.ruleSetArray[var1_1];
        }
        return null;
    }

    private void init() {
        for (int i = 0; i < this.ruleSetArray.length; ++i) {
            this.ruleSetArray[i].verbose = this.verbose;
            this.selectorListArray[i].verbose = this.verbose;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        for (int decisionValIndex = 0; decisionValIndex < this.trainArray.getDecValues().length; ++decisionValIndex) {
            tmp.append(this.ruleSetArray[decisionValIndex].toString(this.selectorListArray[decisionValIndex], this.trainArray));
        }
        return var1_1.toString();
    }
}

