/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.statFunctions;

public final class LinearRegression {
    private double beta1;
    private double beta0;
    private double R2;
    private double svar;
    private double svar1;
    private double svar0;
    private double rss;
    private double ssr;
    private double xxbar;
    private double yybar;
    private double sumx2;
    private int n;

    /*
     * WARNING - void declaration
     */
    public final double calc(double[] x, double[] y) {
        void var3_4;
        double sumx = 0.0;
        double sumy = 0.0;
        this.sumx2 = 0.0;
        this.n = x.length;
        for (int i = 0; i < x.length; ++i) {
            sumx += x[i];
            this.sumx2 += x[i] * x[i];
            sumy += y[i];
        }
        double xbar = sumx / (double)this.n;
        double ybar = sumy / (double)this.n;
        this.yybar = 0.0;
        this.xxbar = 0.0;
        double xybar = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.xxbar += (x[i] - xbar) * (x[i] - xbar);
            this.yybar += (y[i] - ybar) * (y[i] - ybar);
            xybar += (x[i] - xbar) * (y[i] - ybar);
        }
        this.beta1 = xybar / this.xxbar;
        this.beta0 = ybar - this.beta1 * xbar;
        int df = this.n - 2;
        this.rss = 0.0;
        this.ssr = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double fit = this.beta1 * x[i] + this.beta0;
            this.rss += (fit - y[i]) * (fit - y[i]);
            this.ssr += (fit - ybar) * (fit - ybar);
        }
        this.R2 = this.ssr / this.yybar;
        this.svar = this.rss / (double)var3_4;
        this.svar1 = this.svar / this.xxbar;
        double d = xbar;
        this.svar0 = this.svar / (double)this.n + d * d * this.svar1;
        return this.beta1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("y   = " + this.beta1 + " * x + " + this.beta0).append("\n");
        tmp.append("R^2                 = " + this.R2).append("\n");
        tmp.append("std error of beta_1 = " + Math.sqrt(this.svar1)).append("\n");
        tmp.append("std error of beta_0 = " + Math.sqrt(this.svar0)).append("\n");
        this.svar0 = this.svar * this.sumx2 / ((double)this.n * this.xxbar);
        tmp.append("std error of beta_0 = " + Math.sqrt(this.svar0)).append("\n");
        tmp.append("SSTO = " + this.yybar).append("\n");
        tmp.append("SSE  = " + this.rss).append("\n");
        tmp.append("SSR  = " + this.ssr).append("\n");
        return var1_1.toString();
    }

    public final double getBeta1() {
        return this.beta1;
    }
}

