/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.evomodel.tree.randomlocalmodel.RandomLocalTreeVariable;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class RelaxedDriftModel
extends AbstractBranchRateModel
implements RandomLocalTreeVariable {
    private TreeModel treeModel;
    private double[] branchRates;
    private TreeParameterModel indicators;
    private TreeParameterModel rates;
    private Parameter driftRates;
    private ArbitraryBranchRates branchChanges;
    boolean recalculationNeeded = true;

    public RelaxedDriftModel(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, ArbitraryBranchRates arbitraryBranchRates) {
        super("relaxedDriftModel");
        int n;
        this.rates = new TreeParameterModel((MutableTreeModel)treeModel, parameter2, true);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, -1.7976931348623157E308, parameter2.getDimension()));
        this.indicators = new TreeParameterModel((MutableTreeModel)treeModel, parameter, true);
        parameter.addBounds(new Parameter.DefaultBounds(1.0, -1.0, parameter.getDimension()));
        for (n = 0; n < parameter.getDimension(); ++n) {
            parameter.setParameterValue(n, 0.0);
        }
        for (n = 0; n < parameter2.getDimension(); ++n) {
            parameter2.setParameterValue(n, 0.0);
        }
        this.addModel(treeModel);
        this.treeModel = treeModel;
        this.addModel(this.indicators);
        this.addModel(this.rates);
        if (parameter3 != null) {
            this.driftRates = parameter3;
            parameter3.setDimension(parameter2.getDimension());
        }
        if (arbitraryBranchRates != null) {
            this.branchChanges = arbitraryBranchRates;
        }
        this.branchRates = new double[treeModel.getNodeCount()];
        this.calculateBranchRates(treeModel);
    }

    @Override
    public final double getVariable(Tree tree, NodeRef nodeRef) {
        return this.rates.getNodeValue(tree, nodeRef);
    }

    @Override
    public final boolean isVariableSelected(Tree tree, NodeRef nodeRef) {
        return this.indicators.getNodeValue(tree, nodeRef) != 0.0;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.recalculationNeeded = true;
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.recalculationNeeded = true;
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.calculateBranchRates(this.treeModel);
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (this.recalculationNeeded) {
            this.calculateBranchRates(this.treeModel);
            this.recalculationNeeded = false;
        }
        return this.branchRates[nodeRef.getNumber()];
    }

    private void calculateBranchRates(TreeModel treeModel) {
        this.branchRates[treeModel.getRoot().getNumber()] = this.getVariable(treeModel, treeModel.getRoot());
        if (this.driftRates != null) {
            this.driftRates.setParameterValue(treeModel.getRoot().getNumber(), this.getVariable(treeModel, treeModel.getRoot()));
        }
        this.cbr(treeModel, treeModel.getRoot(), this.branchRates[treeModel.getRoot().getNumber()]);
    }

    private void cbr(TreeModel treeModel, NodeRef nodeRef, double d) {
        NodeRef nodeRef2 = treeModel.getChild(nodeRef, 0);
        NodeRef nodeRef3 = treeModel.getChild(nodeRef, 1);
        int n = nodeRef2.getNumber();
        int n2 = nodeRef3.getNumber();
        double d2 = this.indicators.getNodeValue(treeModel, nodeRef);
        if (this.indicators.getNodeValue(treeModel, nodeRef) != 0.0) {
            // empty if block
        }
        if (d2 < 0.0) {
            this.branchRates[n] = d + this.getVariable(treeModel, nodeRef2);
            this.branchRates[n2] = d;
            if (this.driftRates != null) {
                this.driftRates.setParameterValue(n, d + this.getVariable(treeModel, nodeRef2));
                this.driftRates.setParameterValue(n2, d);
            }
            if (this.branchChanges != null) {
                this.branchChanges.setBranchRate(treeModel, nodeRef2, 1.0);
                this.branchChanges.setBranchRate(treeModel, nodeRef3, 0.0);
            }
        } else if (d2 > 0.0) {
            this.branchRates[n] = d;
            this.branchRates[n2] = d + this.getVariable(treeModel, nodeRef3);
            if (this.driftRates != null) {
                this.driftRates.setParameterValue(n, d);
                this.driftRates.setParameterValue(n2, d + this.getVariable(treeModel, nodeRef3));
            }
            if (this.branchChanges != null) {
                this.branchChanges.setBranchRate(treeModel, nodeRef2, 0.0);
                this.branchChanges.setBranchRate(treeModel, nodeRef3, 1.0);
            }
        } else {
            this.branchRates[n] = d;
            this.branchRates[n2] = d;
            if (this.driftRates != null) {
                this.driftRates.setParameterValue(n, d);
                this.driftRates.setParameterValue(n2, d);
            }
            if (this.branchChanges != null) {
                this.branchChanges.setBranchRate(treeModel, nodeRef2, 0.0);
                this.branchChanges.setBranchRate(treeModel, nodeRef3, 0.0);
            }
        }
        if (treeModel.getChildCount(nodeRef2) > 0) {
            this.cbr(treeModel, nodeRef2, this.branchRates[n]);
        }
        if (treeModel.getChildCount(nodeRef3) > 0) {
            this.cbr(treeModel, nodeRef3, this.branchRates[n2]);
        }
    }
}

