/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.math.UnivariateFunction;

public class CoalescentSimulator {
    dr.evolution.coalescent.CoalescentSimulator simulator = new dr.evolution.coalescent.CoalescentSimulator();

    public SimpleTree simulateTree(Tree[] treeArray, DemographicModel demographicModel, double d, boolean bl) {
        SimpleNode[] simpleNodeArray = new SimpleNode[treeArray.length];
        for (int i = 0; i < simpleNodeArray.length; ++i) {
            simpleNodeArray[i] = new SimpleNode(treeArray[i], treeArray[i].getRoot());
        }
        SimpleTree simpleTree = simpleNodeArray.length == 1 ? new SimpleTree(simpleNodeArray[0]) : new SimpleTree(this.simulator.simulateCoalescent(simpleNodeArray, demographicModel.getDemographicFunction()));
        if (!Double.isNaN(d) && d > 0.0) {
            if (bl) {
                this.limitNodes(simpleTree, d - 1.0E-12);
                simpleTree.setRootHeight(d);
            } else {
                this.attemptToScaleTree(simpleTree, d);
            }
        }
        return simpleTree;
    }

    public SimpleTree simulateTree(Tree tree, NodeRef nodeRef, DemographicModel demographicModel) {
        SimpleNode[] simpleNodeArray = new SimpleNode[tree.getChildCount(nodeRef)];
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            if (tree.isExternal(nodeRef2)) {
                simpleNodeArray[i] = new SimpleNode(tree, nodeRef2);
                continue;
            }
            SimpleTree simpleTree = this.simulateTree(tree, nodeRef2, demographicModel);
            simpleNodeArray[i] = new SimpleNode(simpleTree, simpleTree.getRoot());
        }
        SimpleTree simpleTree = simpleNodeArray.length == 1 ? new SimpleTree(simpleNodeArray[0]) : new SimpleTree(this.simulator.simulateCoalescent(simpleNodeArray, demographicModel.getDemographicFunction()));
        return simpleTree;
    }

    public SimpleTree simulateTree(TaxonList taxonList, DemographicModel demographicModel) {
        return this.simulator.simulateTree(taxonList, demographicModel.getDemographicFunction());
    }

    public void attemptToScaleTree(MutableTree mutableTree, double d) {
        if (mutableTree.getRoot() == null) {
            return;
        }
        double d2 = d / mutableTree.getNodeHeight(mutableTree.getRoot());
        for (int i = 0; i < mutableTree.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = mutableTree.getInternalNode(i);
            mutableTree.setNodeHeight(nodeRef, mutableTree.getNodeHeight(nodeRef) * d2);
        }
        MutableTree.Utils.correctHeightsForTips(mutableTree);
    }

    public int sizeOfIntersection(TaxonList taxonList, TaxonList taxonList2) {
        int n = 0;
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            if (taxonList2.getTaxonIndex(taxonList.getTaxon(i)) < 0) continue;
            ++n;
        }
        return n;
    }

    public boolean contained(TaxonList taxonList, TaxonList taxonList2) {
        return this.sizeOfIntersection(taxonList, taxonList2) == taxonList.getTaxonCount();
    }

    private void limitNodes(MutableTree mutableTree, double d) {
        for (int i = 0; i < mutableTree.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = mutableTree.getInternalNode(i);
            if (!(mutableTree.getNodeHeight(nodeRef) > d)) continue;
            mutableTree.setNodeHeight(nodeRef, d);
        }
        MutableTree.Utils.correctHeightsForTips(mutableTree);
    }

    public static class TaxaConstraint {
        public final TaxonList taxons;
        public final double lower;
        public final boolean isMonophyletic;
        public double upper;

        public TaxaConstraint(TaxonList taxonList, ParametricDistributionModel parametricDistributionModel, boolean bl) {
            this.taxons = taxonList;
            this.isMonophyletic = bl;
            if (parametricDistributionModel != null) {
                UnivariateFunction univariateFunction = parametricDistributionModel.getProbabilityDensityFunction();
                this.lower = univariateFunction.getLowerBound();
                this.upper = univariateFunction.getUpperBound();
            } else {
                this.lower = 0.0;
                this.upper = Double.POSITIVE_INFINITY;
            }
        }

        public TaxaConstraint(TaxonList taxonList, double d, double d2, boolean bl) {
            this.taxons = taxonList;
            this.isMonophyletic = bl;
            this.upper = d2;
            this.lower = d;
        }

        public boolean realLimits() {
            return this.lower != 0.0 || this.upper != Double.POSITIVE_INFINITY;
        }
    }
}

