/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDoubleMatrix2D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDoubleMatrix2D.txt";
    private static double[][] a_2d;
    private static double[][] b_2d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdouble.impl.BenchmarkDenseDoubleMatrix2D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        BenchmarkMatrixKernel.readSettings2D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        a_1d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        a_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        int n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseDoubleMatrix2D.a_2d[n2][n] = random.nextDouble();
                BenchmarkDenseDoubleMatrix2D.a_1d[n3++] = a_2d[n2][n];
            }
        }
        b_1d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        b_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseDoubleMatrix2D.b_2d[n2][n] = random.nextDouble();
                BenchmarkDenseDoubleMatrix2D.b_1d[n3++] = b_2d[n2][n];
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_2D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_2D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_2d = null;
        b_1d = null;
        b_2d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunctionDoubleProcedure() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.2;
            }
        };
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction, DoubleProcedure)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunctionIntArrayListIntArrayList() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n) {
            for (int i = 0; i < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++i) {
                intArrayList.add(n);
                intArrayList2.add(i);
            }
        }
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix2D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleMatrix2DDoubleDoubleFunctionDoubleDoubleFunction() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(b_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(denseDoubleMatrix2D2, DoubleFunctions.plus, DoubleFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix2D)denseDoubleMatrix2D).aggregate(denseDoubleMatrix2D2, DoubleFunctions.plus, DoubleFunctions.mult);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix2D.aggregate(doubleMatrix2D2, DoubleFunctions.plus, DoubleFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix2D.aggregate(doubleMatrix2D2, DoubleFunctions.plus, DoubleFunctions.mult);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleMatrix2D, DoubleDoubleFunction, DoubleDoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDouble() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        double d = Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(0.0);
                t.reset().start();
                doubleMatrix2D.assign(d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(0.0);
                t.reset().start();
                doubleMatrix2D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArray() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(a_2d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(0.0);
                t.reset().start();
                doubleMatrix2D.assign(a_2d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleFunction() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(DoubleFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(DoubleFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(a_2d);
                t.reset().start();
                doubleMatrix2D.assign(DoubleFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix2D() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewDice();
        denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D2.viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            doubleMatrix2D.assign(doubleMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(0.0);
                t.reset().start();
                doubleMatrix2D.assign(doubleMatrix2D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix2DDoubleDoubleFunction() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(b_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2, DoubleFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2, DoubleFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            doubleMatrix2D.assign(doubleMatrix2D2, DoubleFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(a_2d);
                t.reset().start();
                doubleMatrix2D.assign(doubleMatrix2D2, DoubleFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix2D, DoubleDoubleFuction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix2DDoubleDoubleFunctionIntArrayListIntArrayList() {
        int n;
        int n2;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(b_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                intArrayList.add(n2);
                intArrayList2.add(n);
            }
        }
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2, DoubleFunctions.div, intArrayList, intArrayList2);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(denseDoubleMatrix2D2, DoubleFunctions.div, intArrayList, intArrayList2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            doubleMatrix2D.assign(doubleMatrix2D2, DoubleFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(a_2d);
                t.reset().start();
                doubleMatrix2D.assign(doubleMatrix2D2, DoubleFunctions.div, intArrayList, intArrayList2);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix2D, DoubleDoubleFuction, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleProcedureDouble() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(doubleProcedure, -1.0);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(doubleProcedure, -1.0);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(doubleProcedure, -1.0);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(a_2d);
                t.reset().start();
                doubleMatrix2D.assign(doubleProcedure, -1.0);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleProcedure, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleProcedureDoubleFunction() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(doubleProcedure, DoubleFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(doubleProcedure, DoubleFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(doubleProcedure, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(a_2d);
                t.reset().start();
                doubleMatrix2D.assign(doubleProcedure, DoubleFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleProcedure, DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        int n2;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        float[] fArray = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n2) {
            fArray[n2] = (float)Math.random();
        }
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix2D)denseDoubleMatrix2D).assign(fArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix2D)denseDoubleMatrix2D).assign(fArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.assign(fArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D.assign(0.0);
                t.reset().start();
                doubleMatrix2D.assign(fArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((DoubleMatrix2D)denseDoubleMatrix2D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((DoubleMatrix2D)denseDoubleMatrix2D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewDice();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = doubleMatrix2D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = doubleMatrix2D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDct2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dct2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dct2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dct2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDctColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dctColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dctColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dctColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dctColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dctColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDctRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dctRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dctRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dctRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dctRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dctRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDht2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dht2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dht2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dht2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDhtColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dhtColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dhtColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dhtColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dhtColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dhtColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDhtRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dhtRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dhtRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dhtRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dhtRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dhtRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDst2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dst2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dst2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dst2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dst2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dst2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDstColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dstColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dstColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dstColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dstColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dstColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDstRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.dstRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.dstRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).dstRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).dstRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dstRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.fft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.fft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).fft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).fft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testForEachNonZero() {
        int n;
        IntIntDoubleFunction intIntDoubleFunction = new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                return Math.sqrt(d);
            }
        };
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.forEachNonZero(intIntDoubleFunction);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                denseDoubleMatrix2D.forEachNonZero(intIntDoubleFunction);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).forEachNonZero(intIntDoubleFunction);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).forEachNonZero(intIntDoubleFunction);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "forEachNonZero(IntIntDoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFft2() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFftColumns() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D = denseDoubleMatrix2D.getFftColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = denseDoubleMatrix2D.getFftColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFftColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFftColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFftColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFftRows() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D = denseDoubleMatrix2D.getFftRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = denseDoubleMatrix2D.getFftRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFftRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getFftRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFftRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfft2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfftColumns() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D = denseDoubleMatrix2D.getIfftColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = denseDoubleMatrix2D.getIfftColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getIfftColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getIfftColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfftColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfftRows() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D = denseDoubleMatrix2D.getIfftRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = denseDoubleMatrix2D.getIfftRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getIfftRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D = ((DenseDoubleMatrix2D)doubleMatrix2D).getIfftRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfftRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix2D.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).getNonZeros(intArrayList, intArrayList2, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).getNonZeros(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetPositiveValuesIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix2D.getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getPositiveValues(IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNegativeValuesIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        denseDoubleMatrix2D.assign(DoubleFunctions.mult(-1.0));
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix2D.getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        ((DenseDoubleMatrix2D)doubleMatrix2D).assign(DoubleFunctions.mult(-1.0));
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNegativeValues(IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdct2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idct2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idct2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idct2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdctColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idctColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idctColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idctColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idctColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idctColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdctRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idctRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idctRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idctRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idctRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idctRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdht2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idht2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idht2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idht2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idht2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idht2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdhtColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idhtColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idhtColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idhtColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idhtColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idhtColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdhtRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idhtRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idhtRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idhtRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idhtRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idhtRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdst2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idst2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idst2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idst2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idst2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idst2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdstColumns() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idstColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idstColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idstColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idstColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idstColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdstRows() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.idstRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.idstRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).idstRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).idstRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idstRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix2D.assign(a_2d);
                t.reset().start();
                denseDoubleMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix2D)doubleMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMaxLocation() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = denseDoubleMatrix2D.getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix2D.getMaxLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).getMaxLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "maxLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMinLocation() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = denseDoubleMatrix2D.getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix2D.getMinLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(a_2d).viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).getMinLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "minLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = denseDoubleMatrix2D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = denseDoubleMatrix2D.zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = ((DenseDoubleMatrix2D)doubleMatrix2D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DenseDoubleMatrix2D)doubleMatrix2D).zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[][] dArray = denseDoubleMatrix2D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix2D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[][] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix1D doubleMatrix1D = denseDoubleMatrix2D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = denseDoubleMatrix2D.vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix1D doubleMatrix1D = ((DenseDoubleMatrix2D)doubleMatrix2D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = ((DenseDoubleMatrix2D)doubleMatrix2D).vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDoubleMatrix1DDoubleMatrix1DDoubleDoubleBoolean() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(denseDoubleMatrix2D.columns());
        double d = 3.0;
        double d2 = 5.0;
        int n2 = 0;
        while ((long)n2 < denseDoubleMatrix1D.size()) {
            denseDoubleMatrix1D.set(n2, Math.random());
            ++n2;
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(denseDoubleMatrix2D.rows());
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            denseDoubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2, d, d2, false);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix1D)denseDoubleMatrix1D2).assign(0.0);
                t.reset().start();
                denseDoubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2, d, d2, false);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix2D)doubleMatrix2D).zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2, d, d2, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix1D)denseDoubleMatrix1D2).assign(0.0);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D).zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2, d, d2, false);
                t.stop();
                int n6 = n;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DoubleMatrix1D, DoubleMatrix1D, double, double, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDoubleMatrix2DDoubleMatrix2DDoubleDoubleBooleanBoolean() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(b_2d);
        doubleMatrix2D = doubleMatrix2D.viewDice().copy();
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        double d = 3.0;
        double d2 = 5.0;
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.zMult(doubleMatrix2D, denseDoubleMatrix2D2, d, d2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix2D)denseDoubleMatrix2D2).assign(0.0);
                t.reset().start();
                denseDoubleMatrix2D.zMult(doubleMatrix2D, denseDoubleMatrix2D2, d, d2, false, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.viewDice();
        doubleMatrix2D = new DenseDoubleMatrix2D(b_2d);
        doubleMatrix2D = doubleMatrix2D.viewDice().copy();
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.viewDice();
        denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DoubleMatrix2D doubleMatrix2D4 = denseDoubleMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            ((DenseDoubleMatrix2D)doubleMatrix2D2).zMult(doubleMatrix2D3, doubleMatrix2D4, d, d2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D4.assign(0.0);
                t.reset().start();
                ((DenseDoubleMatrix2D)doubleMatrix2D2).zMult(doubleMatrix2D3, doubleMatrix2D4, d, d2, false, false);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DoubleMatrix2D, DoubleMatrix2D, double, double, boolean, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }

    @Test
    public void testZMultDoubleMatrix2DDoubleMatrix2D() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(b_2d);
        doubleMatrix2D = doubleMatrix2D.viewDice().copy();
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix2D.zMult(doubleMatrix2D, denseDoubleMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix2D)denseDoubleMatrix2D2).assign(0.0);
                t.reset().start();
                denseDoubleMatrix2D.zMult(doubleMatrix2D, denseDoubleMatrix2D2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.viewDice();
        doubleMatrix2D = new DenseDoubleMatrix2D(b_2d);
        doubleMatrix2D = doubleMatrix2D.viewDice().copy();
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.viewDice();
        denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DoubleMatrix2D doubleMatrix2D4 = denseDoubleMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            doubleMatrix2D2.zMult(doubleMatrix2D3, doubleMatrix2D4);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix2D4.assign(0.0);
                t.reset().start();
                doubleMatrix2D2.zMult(doubleMatrix2D3, doubleMatrix2D4);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DoubleMatrix2D, DoubleMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }

    @Test
    public void testZMultDoubleMatrix1DDoubleMatrix1D() {
        int n;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(a_2d);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(denseDoubleMatrix2D.columns());
        int n2 = 0;
        while ((long)n2 < denseDoubleMatrix1D.size()) {
            denseDoubleMatrix1D.set(n2, Math.random());
            ++n2;
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(denseDoubleMatrix2D.rows());
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            denseDoubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix1D)denseDoubleMatrix1D2).assign(0.0);
                t.reset().start();
                denseDoubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix1D)denseDoubleMatrix1D2).assign(0.0);
                t.reset().start();
                doubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D2);
                t.stop();
                int n6 = n;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DoubleMatrix1D, DoubleMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

