/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Function;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Itemset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5StaticUtils;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Mask;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyAttribute;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Rule;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Ruleset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.SimpleRule;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.DatasetException;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.InstanceSet;

public class MyDataset {
    protected String name = "";
    protected Vector attributes;
    protected Vector itemsets;
    protected int classIndex;
    protected InstanceSet IS;
    protected double[] m_ValueBuffer;
    protected int[] m_IndicesBuffer;

    public MyDataset(String name, boolean train) {
        try {
            this.IS = new InstanceSet();
            this.IS.readSet(name, train);
        }
        catch (DatasetException e) {
            System.err.println("Error loading dataset itemsets");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (HeaderFormatException e) {
            System.err.println("Error loading dataset itemsets");
            e.printStackTrace();
            System.exit(-1);
        }
        this.readHeader();
        this.itemsets = new Vector(this.IS.getNumInstances());
        this.getItemsetFull();
    }

    public MyDataset(String name, Vector attInfo, int capacity) {
        this.classIndex = -1;
        this.attributes = attInfo;
        for (int i = 0; i < this.numAttributes(); ++i) {
            this.getAttribute(i).setIndex(i);
        }
        this.itemsets = new Vector(capacity);
    }

    public MyDataset(MyDataset dataset) {
        this(dataset, dataset.numItemsets());
        dataset.copyItemsets(0, this, dataset.numItemsets());
    }

    public MyDataset(MyDataset source, int first, int toCopy) {
        this(source, toCopy);
        if (first < 0 || first + toCopy > source.numItemsets()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        source.copyItemsets(first, this, toCopy);
    }

    public MyDataset(MyDataset dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.classIndex = dataset.classIndex;
        this.name = dataset.getName();
        this.attributes = dataset.attributes;
        this.itemsets = new Vector(capacity);
    }

    private void readHeader() {
        Vector<String> attributeValues;
        MyAttribute att;
        float max;
        float min;
        String attributeName;
        Attribute at;
        int j;
        this.name = Attributes.getRelationName();
        this.attributes = new Vector();
        for (j = 0; j < Attributes.getInputNumAttributes(); ++j) {
            at = Attributes.getInputAttribute(j);
            attributeName = at.getName();
            if (at.getType() == 2) {
                min = (float)at.getMinAttribute();
                max = (float)at.getMinAttribute();
                this.attributes.addElement(new MyAttribute(attributeName, j));
                att = (MyAttribute)this.attributes.elementAt(j);
                att.setRange(min, max);
                att.activate();
                continue;
            }
            if (at.getType() == 1) {
                int min2 = (int)at.getMinAttribute();
                int max2 = (int)at.getMinAttribute();
                this.attributes.addElement(new MyAttribute(attributeName, j));
                att = (MyAttribute)this.attributes.elementAt(j);
                att.setRange(min2, max2);
                att.activate();
                continue;
            }
            attributeValues = new Vector<String>();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new MyAttribute(attributeName, attributeValues, j));
            MyAttribute att2 = (MyAttribute)this.attributes.elementAt(j);
            att2.activate();
        }
        at = Attributes.getOutputAttribute(0);
        attributeName = at.getName();
        j = Attributes.getNumAttributes() - 1;
        if (at.getType() == 2) {
            min = (float)at.getMinAttribute();
            max = (float)at.getMinAttribute();
            this.attributes.addElement(new MyAttribute(attributeName, j));
            att = (MyAttribute)this.attributes.elementAt(j);
            att.setRange(min, max);
            att.activate();
        } else if (at.getType() == 1) {
            int min3 = (int)at.getMinAttribute();
            int max3 = (int)at.getMinAttribute();
            this.attributes.addElement(new MyAttribute(attributeName, j));
            att = (MyAttribute)this.attributes.elementAt(j);
            att.setRange(min3, max3);
            att.activate();
        } else {
            attributeValues = new Vector();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new MyAttribute(attributeName, attributeValues, j));
            MyAttribute att3 = (MyAttribute)this.attributes.elementAt(j);
            att3.activate();
        }
        this.classIndex = Attributes.getNumAttributes() - 1;
    }

    private boolean getItemsetFull() {
        for (int j = 0; j < this.IS.getNumInstances(); ++j) {
            int k;
            int i;
            double[] itemset = new double[Attributes.getNumAttributes()];
            for (i = 0; i < Attributes.getInputNumAttributes(); ++i) {
                if (this.IS.getInstance(j).getInputMissingValues(i)) {
                    itemset[i] = Itemset.getMissingValue();
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    for (k = 0; k < Attributes.getInputAttribute(i).getNumNominalValues(); ++k) {
                        if (!Attributes.getInputAttribute(i).getNominalValue(k).equals(this.IS.getInstance(j).getInputNominalValues(i))) continue;
                        itemset[i] = k;
                    }
                    continue;
                }
                itemset[i] = this.IS.getInstance(j).getInputRealValues(i);
            }
            i = Attributes.getInputNumAttributes();
            if (this.IS.getInstance(j).getOutputMissingValues(0)) {
                itemset[i] = Itemset.getMissingValue();
            } else if (Attributes.getOutputAttribute(0).getType() == 0) {
                for (k = 0; k < Attributes.getOutputAttribute(0).getNumNominalValues(); ++k) {
                    if (!Attributes.getOutputAttribute(0).getNominalValue(k).equals(this.IS.getInstance(j).getOutputNominalValues(0))) continue;
                    itemset[i] = k;
                }
            } else {
                itemset[i] = this.IS.getInstance(j).getOutputRealValues(0);
            }
            this.addItemset(new Itemset(1.0, itemset));
        }
        return true;
    }

    public final void addItemset(Itemset itemset) {
        Itemset newItemset = (Itemset)itemset.copy();
        newItemset.setDataset(this);
        this.itemsets.addElement(newItemset);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final MyAttribute getAttribute(int index) {
        return (MyAttribute)this.attributes.elementAt(index);
    }

    public final MyAttribute getAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!((MyAttribute)this.attributes.elementAt(i)).name().equalsIgnoreCase(name)) continue;
            return (MyAttribute)this.attributes.elementAt(i);
        }
        return null;
    }

    public double[] attributeToDoubleArray(int index) {
        double[] result = new double[this.numItemsets()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.itemset(i).getValue(index);
        }
        return result;
    }

    public final MyAttribute getClassAttribute() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return null;
        }
        return this.getAttribute(this.classIndex);
    }

    public final void setClass(MyAttribute att) {
        this.classIndex = att.index();
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + classIndex);
        }
        this.classIndex = classIndex;
    }

    public final double variance(int attIndex) {
        double sum = 0.0;
        double sumSquared = 0.0;
        double sumOfWeights = 0.0;
        if (this.getAttribute(attIndex).isDiscret()) {
            throw new IllegalArgumentException("Can't compute variance because attribute " + attIndex + " is " + "not numeric!");
        }
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (this.itemset(i).isMissing(attIndex)) continue;
            sum += this.itemset(i).getWeight() * this.itemset(i).getValue(attIndex);
            sumSquared += this.itemset(i).getWeight() * this.itemset(i).getValue(attIndex) * this.itemset(i).getValue(attIndex);
            sumOfWeights += this.itemset(i).getWeight();
        }
        if (M5StaticUtils.smOrEq(sumOfWeights, 1.0)) {
            return 0.0;
        }
        return (sumSquared - sum * sum / sumOfWeights) / (sumOfWeights - 1.0);
    }

    public final double variance(MyAttribute att) {
        return this.variance(att.index());
    }

    public final double classVariance() {
        double sumSquared = 0.0;
        double mean = this.averageClassValue();
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute variance because class is not numeric!");
        }
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (this.itemset(i).isMissing(this.classIndex)) continue;
            double deviation = this.itemset(i).getClassValue() - mean;
            sumSquared += deviation * deviation;
        }
        return sumSquared / (double)this.numItemsets();
    }

    public final double classSTD() {
        return Math.sqrt(this.classVariance());
    }

    public final double classVariance(Rule r) {
        double sumSquared = 0.0;
        double mean = this.averageClassValue(r);
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute rule variance because class is not numeric!");
        }
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        while (covered.next()) {
            if (this.itemset(covered.getIndex()).isMissing(this.classIndex)) continue;
            double deviation = this.itemset(covered.getIndex()).getClassValue() - mean;
            sumSquared += deviation * deviation;
        }
        return sumSquared / (double)covered.getnActive();
    }

    public final double classSTD(Rule r) {
        return Math.sqrt(this.classVariance(r));
    }

    public final double classPredictedVariance(Rule r) {
        double sumSquared = 0.0;
        double mean = this.averagePredictedClassValue(r);
        Function function = r.getFunction();
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute predicted variance because class is not numeric!");
        }
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        while (covered.next()) {
            if (this.itemset(covered.getIndex()).isMissing(this.classIndex)) continue;
            double deviation = function.predict(this.itemset(covered.getIndex())) - mean;
            sumSquared += deviation * deviation;
        }
        return sumSquared / (double)covered.getnActive();
    }

    public final double classPredictedSTD(Rule r) {
        return Math.sqrt(this.classPredictedVariance(r));
    }

    public final double meanOrMode(int attIndex) {
        if (this.getAttribute(attIndex).isDiscret()) {
            double found = 0.0;
            double result = 0.0;
            for (int j = 0; j < this.numItemsets(); ++j) {
                if (this.itemset(j).isMissing(attIndex)) continue;
                found += this.itemset(j).getWeight();
                result += this.itemset(j).getWeight() * this.itemset(j).getValue(attIndex);
            }
            if (M5StaticUtils.eq(found, 0.0)) {
                return 0.0;
            }
            return result / found;
        }
        if (this.getAttribute(attIndex).isDiscret()) {
            int[] counts = new int[this.getAttribute(attIndex).numValues()];
            for (int j = 0; j < this.numItemsets(); ++j) {
                if (this.itemset(j).isMissing(attIndex)) continue;
                int n = (int)this.itemset(j).getValue(attIndex);
                counts[n] = (int)((double)counts[n] + this.itemset(j).getWeight());
            }
            return M5StaticUtils.maxIndex(counts);
        }
        return 0.0;
    }

    public final double meanOrMode(MyAttribute att) {
        return this.meanOrMode(att.index());
    }

    public final int numAttributes() {
        return this.attributes.size();
    }

    public final int numClasses() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return -1;
        }
        if (this.getClassAttribute().isContinuous()) {
            return 1;
        }
        return this.getClassAttribute().numValues();
    }

    public final int numItemsets() {
        return this.itemsets.size();
    }

    public final void compactify() {
        this.itemsets.trimToSize();
    }

    public final void delete() {
        this.itemsets = new Vector();
    }

    public final void delete(int index) {
        this.itemsets.removeElementAt(index);
    }

    public final boolean checkInstance(Itemset itemset) {
        if (itemset.numAttributes() != this.numAttributes()) {
            return false;
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (itemset.isMissing(i) || !this.getAttribute(i).isDiscret()) continue;
            if (!M5StaticUtils.eq(itemset.getValue(i), (int)itemset.getValue(i))) {
                return false;
            }
            if (!M5StaticUtils.sm(itemset.getValue(i), 0.0) && !M5StaticUtils.gr(itemset.getValue(i), this.getAttribute(i).numValues())) continue;
            return false;
        }
        return true;
    }

    public void insertAttributeAt(MyAttribute att, int position) {
        int i;
        if (position < 0 || position > this.attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        att = (MyAttribute)att.copy();
        att.setIndex(position);
        this.attributes.insertElementAt(att, position);
        for (i = position + 1; i < this.attributes.size(); ++i) {
            MyAttribute current = (MyAttribute)this.attributes.elementAt(i);
            current.setIndex(current.index() + 1);
        }
        for (i = 0; i < this.numItemsets(); ++i) {
            this.itemset(i).insertAttributeAt(position);
        }
        if (this.classIndex >= position) {
            ++this.classIndex;
        }
    }

    public void deleteAttributeAt(int position) {
        int i;
        if (position < 0 || position >= this.attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (position == this.classIndex) {
            throw new IllegalArgumentException("Can't delete class attribute");
        }
        if (this.classIndex > position) {
            --this.classIndex;
        }
        this.attributes.removeElementAt(position);
        for (i = position; i < this.attributes.size(); ++i) {
            MyAttribute current = (MyAttribute)this.attributes.elementAt(i);
            current.setIndex(current.index() - 1);
        }
        for (i = 0; i < this.numItemsets(); ++i) {
            this.itemset(i).deleteAttributeAt(position);
        }
    }

    public final void deleteWithMissing(int attIndex) {
        Vector<Itemset> newItemsets = new Vector<Itemset>(this.numItemsets());
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (this.itemset(i).isMissing(attIndex)) continue;
            newItemsets.addElement(this.itemset(i));
        }
        this.itemsets = newItemsets;
    }

    public final void deleteWithMissing(MyAttribute att) {
        this.deleteWithMissing(att.index());
    }

    public final void deleteWithMissingClass() throws Exception {
        if (this.classIndex < 0) {
            throw new Exception("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.classIndex);
    }

    public Enumeration enumerateAttributes() {
        Vector help = new Vector(this.attributes.size() - 1);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i == this.classIndex) continue;
            help.addElement(this.attributes.elementAt(i));
        }
        return help.elements();
    }

    public final Enumeration enumerateItemsets() {
        return this.itemsets.elements();
    }

    public final void stratify(int numFolds) throws Exception {
        if (numFolds <= 0) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.classIndex < 0) {
            throw new Exception("Class index is negative (not set)!");
        }
        if (this.getClassAttribute().isDiscret()) {
            for (int index = 1; index < this.numItemsets(); ++index) {
                Itemset itemset1 = this.itemset(index - 1);
                for (int j = index; j < this.numItemsets(); ++j) {
                    Itemset itemset2 = this.itemset(j);
                    if (itemset1.getClassValue() != itemset2.getClassValue() && (!itemset1.classIsMissing() || !itemset2.classIsMissing())) continue;
                    this.swap(index, j);
                    ++index;
                }
            }
            this.stratStep(numFolds);
        }
    }

    private void stratStep(int numFolds) {
        Vector<Itemset> newVec = new Vector<Itemset>(this.itemsets.capacity());
        int start = 0;
        while (newVec.size() < this.numItemsets()) {
            for (int j = start; j < this.numItemsets(); j += numFolds) {
                newVec.addElement(this.itemset(j));
            }
            ++start;
        }
        this.itemsets = newVec;
    }

    public final Itemset firstInstance() {
        return (Itemset)this.itemsets.firstElement();
    }

    public final Itemset itemset(int index) {
        return (Itemset)this.itemsets.elementAt(index);
    }

    public final Itemset lastItemset() {
        return (Itemset)this.itemsets.lastElement();
    }

    private void copyItemsets(int from, MyDataset dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.addItemset(this.itemset(from + i));
        }
    }

    public final double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numItemsets(); ++i) {
            sum += this.itemset(i).getWeight();
        }
        return sum;
    }

    public final boolean equalHeaders(MyDataset dataset) {
        if (this.classIndex != dataset.classIndex) {
            return false;
        }
        if (this.attributes.size() != dataset.attributes.size()) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.getAttribute(i).equals(dataset.getAttribute(i))) continue;
            return false;
        }
        return true;
    }

    public final void sort(int attIndex) {
        int j = this.numItemsets() - 1;
        int i = 0;
        while (i <= j) {
            if (this.itemset(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.itemset(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    public final void sort(MyAttribute att) {
        this.sort(att.index());
    }

    private void quickSort(int attIndex, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = this.itemset((lo0 + hi0) / 2).getValue(attIndex);
            double midPlus = mid + 1.0E-6;
            double midMinus = mid - 1.0E-6;
            while (lo <= hi) {
                while (this.itemset(lo).getValue(attIndex) < midMinus && lo < hi0) {
                    ++lo;
                }
                while (this.itemset(hi).getValue(attIndex) > midPlus && hi > lo0) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(attIndex, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(attIndex, lo, hi0);
            }
        }
    }

    private void swap(int i, int j) {
        Object help = this.itemsets.elementAt(i);
        this.itemsets.insertElementAt(this.itemsets.elementAt(j), i);
        this.itemsets.removeElementAt(i + 1);
        this.itemsets.insertElementAt(help, j);
        this.itemsets.removeElementAt(j + 1);
    }

    public MyDataset trainCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numItemsets()) {
            throw new IllegalArgumentException("Can't have more folds than itemsets!");
        }
        int numInstForFold = this.numItemsets() / numFolds;
        if (numFold < this.numItemsets() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numItemsets() % numFolds;
        }
        MyDataset train = new MyDataset(this, this.numItemsets() - numInstForFold);
        int first = numFold * (this.numItemsets() / numFolds) + offset;
        this.copyItemsets(0, train, first);
        this.copyItemsets(first + numInstForFold, train, this.numItemsets() - first - numInstForFold);
        return train;
    }

    public MyDataset testCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numItemsets()) {
            throw new IllegalArgumentException("Can't have more folds than itemsets!");
        }
        int numInstForFold = this.numItemsets() / numFolds;
        if (numFold < this.numItemsets() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numItemsets() % numFolds;
        }
        MyDataset test = new MyDataset(this, numInstForFold);
        int first = numFold * (this.numItemsets() / numFolds) + offset;
        this.copyItemsets(first, test, numInstForFold);
        return test;
    }

    public void filter(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                mask.reset();
                continue;
            }
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) != V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V)) continue;
            mask.reset();
        }
    }

    public void filter(Mask mask, SimpleRule sr) {
        int A = sr.getAttribute();
        double V = sr.getValue();
        int operator = sr.getOperator();
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                mask.reset();
                continue;
            }
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) != V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V)) continue;
            mask.reset();
        }
    }

    public void filter(Mask mask, Rule rule) {
        for (int i = 0; i < rule.size(); ++i) {
            this.filter(mask, rule.getSimpleRule(i));
        }
    }

    public void filter(Mask mask, Ruleset rules) {
        Mask previous = new Mask(this.itemsets.size(), false);
        for (int i = 0; i < rules.size(); ++i) {
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            previous = previous.or(current);
        }
        previous.copyTo(mask);
    }

    public void filter(Mask mask, Ruleset rules, int ignore) {
        Mask previous = new Mask(this.itemsets.size(), false);
        for (int i = 0; i < rules.size(); ++i) {
            if (i == ignore) continue;
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            previous = previous.or(current);
        }
        previous.copyTo(mask);
    }

    public void filterByClass(Mask mask, String class_name) {
        double class_id = this.getAttribute(this.classIndex).valueIndex(class_name);
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).getClassValue() == class_id) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) continue;
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, SimpleRule sr) {
        mask.resetIndex();
        int A = sr.getAttribute();
        double V = sr.getValue();
        int operator = sr.getOperator();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) continue;
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, Rule rule) {
        mask.resetIndex();
        while (mask.next()) {
            boolean seguir = true;
            for (int i = 0; i < rule.size() && seguir; ++i) {
                int A = rule.getSimpleRule(i).getAttribute();
                double V = rule.getSimpleRule(i).getValue();
                int operator = rule.getSimpleRule(i).getOperator();
                if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                    seguir = false;
                    continue;
                }
                if (operator == Rule.EQUAL) {
                    boolean bl = seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V;
                }
                if (operator == Rule.GREATER) {
                    boolean bl = seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V;
                }
                if (operator != Rule.LOWER) continue;
                seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V;
            }
            if (!seguir) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, Ruleset rules) {
        for (int i = 0; i < rules.size(); ++i) {
            this.substract(mask, rules.getRule(i));
        }
    }

    public void substract(Mask mask, Ruleset rules, int ignore) {
        for (int i = 0; i < rules.size(); ++i) {
            if (i == ignore) continue;
            this.substract(mask, rules.getRule(i));
        }
    }

    public final double ruleDeviation(Rule r) {
        double sumSquared = 0.0;
        Function function = r.getFunction();
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute rule deviation because class is not numeric!");
        }
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        covered.resetIndex();
        while (covered.next()) {
            int i = covered.getIndex();
            if (this.itemset(i).isMissing(this.classIndex)) continue;
            double deviation = this.itemset(i).getClassValue() - function.predict(this.itemset(i));
            sumSquared += deviation * deviation;
        }
        return Math.sqrt(sumSquared / (double)covered.getnActive());
    }

    public final double ruleMeanAbsoluteError(Rule r) {
        double sumAbs = 0.0;
        Function function = r.getFunction();
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute MAE because class is not numeric!");
        }
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        covered.resetIndex();
        while (covered.next()) {
            int i = covered.getIndex();
            if (this.itemset(i).isMissing(this.classIndex)) continue;
            double deviation = this.itemset(i).getClassValue() - function.predict(this.itemset(i));
            sumAbs += Math.abs(deviation);
        }
        return sumAbs / (2.0 * (double)covered.getnActive());
    }

    public final double ruleCorrelation(Rule r) {
        double sum = 0.0;
        Function function = r.getFunction();
        double mean = this.averageClassValue(r);
        double predicted_mean = this.averagePredictedClassValue(r);
        double std = this.classSTD(r);
        double predicted_std = this.classPredictedSTD(r);
        if (this.getClassAttribute().isDiscret()) {
            throw new IllegalArgumentException("Can't compute correlation because attribute is not numeric!");
        }
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        covered.resetIndex();
        while (covered.next()) {
            int i = covered.getIndex();
            if (this.itemset(i).isMissing(this.classIndex)) continue;
            double Yi = this.itemset(i).getClassValue() - mean;
            double yi = function.predict(this.itemset(i)) - predicted_mean;
            sum += Yi * yi;
        }
        if (std != 0.0 && predicted_std != 0.0) {
            return sum / (std * predicted_std);
        }
        return 0.0;
    }

    public String[] classify(Mask actives, Ruleset[] rulesets, int length) {
        int i;
        String[] classification = new String[this.itemsets.size()];
        for (i = 0; i < classification.length; ++i) {
            if (!actives.isActive(i)) continue;
            classification[i] = rulesets[length - 1].getType();
        }
        for (i = 0; i < length - 1; ++i) {
            Mask filtered = actives.copy();
            this.filter(filtered, rulesets[i]);
            filtered.resetIndex();
            while (filtered.next()) {
                int ind = filtered.getIndex();
                classification[ind] = rulesets[i].getType();
            }
            this.substract(actives, rulesets[i]);
        }
        return classification;
    }

    public boolean isMissing(int exemple, int attribute) {
        return ((Itemset)this.itemsets.elementAt(exemple)).isMissing(attribute);
    }

    public boolean isMissing(Mask mask, int attribute) {
        return ((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(attribute);
    }

    public int size() {
        return this.itemsets.size();
    }

    public String[] classify(Ruleset[] rulesets, int length) {
        return this.classify(new Mask(this.itemsets.size()), rulesets, length);
    }

    public double[] classify(Mask actives, Vector rules) {
        int i;
        double[] classification = new double[this.itemsets.size()];
        Function default_function = ((Rule)rules.lastElement()).getFunction();
        for (i = 0; i < classification.length; ++i) {
            if (!actives.isActive(i)) continue;
            classification[i] = default_function.predict(this.itemset(i));
        }
        for (i = 0; i < rules.size() - 1; ++i) {
            Mask filtered = actives.copy();
            this.filter(filtered, (Rule)rules.elementAt(i));
            filtered.resetIndex();
            Function function = ((Rule)rules.elementAt(i)).getFunction();
            while (filtered.next()) {
                int ind = filtered.getIndex();
                classification[ind] = function.predict(this.itemset(ind));
            }
            this.substract(actives, (Rule)rules.elementAt(i));
        }
        return classification;
    }

    public double[] classify(Vector rules) {
        return this.classify(new Mask(this.size()), rules);
    }

    public double[] getExample(int pos) {
        return ((Itemset)this.itemsets.elementAt((int)pos)).values;
    }

    public double[] getExample(Mask mask) {
        return ((Itemset)this.itemsets.elementAt((int)mask.getIndex())).values;
    }

    public int[] getClassFequency() {
        int i;
        int[] frequency = new int[this.numClasses()];
        for (i = 0; i < frequency.length; ++i) {
            frequency[i] = 0;
        }
        for (i = 0; i < this.size(); ++i) {
            double class_value = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            int n = (int)class_value;
            frequency[n] = frequency[n] + 1;
        }
        return frequency;
    }

    public int[] getClassFequency(Mask filter) {
        int[] frequency = new int[this.numClasses()];
        for (int i = 0; i < frequency.length; ++i) {
            frequency[i] = 0;
        }
        filter.resetIndex();
        while (filter.next()) {
            double class_value = ((Itemset)this.itemsets.elementAt(filter.getIndex())).getValue(this.getClassIndex());
            int n = (int)class_value;
            frequency[n] = frequency[n] + 1;
        }
        return frequency;
    }

    public MyDataset[] split(Rule r) {
        MyDataset[] split = new MyDataset[2];
        Mask rule_filter = new Mask(this.numItemsets());
        this.filter(rule_filter, r);
        split[0] = new MyDataset(this, rule_filter.getnActive());
        split[1] = new MyDataset(this, this.numItemsets() - split[0].numItemsets());
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (rule_filter.isActive(i)) {
                split[0].addItemset(this.itemset(i));
                continue;
            }
            split[1].addItemset(this.itemset(i));
        }
        return split;
    }

    public double averageClassValue() {
        double sum = 0.0;
        for (int i = 0; i < this.numItemsets(); ++i) {
            sum += this.itemset(i).getClassValue();
        }
        return sum / (double)this.numItemsets();
    }

    public double averageClassValue(Rule r) {
        double sum = 0.0;
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        covered.resetIndex();
        while (covered.next()) {
            sum += this.itemset(covered.getIndex()).getClassValue();
        }
        return sum / (double)covered.getnActive();
    }

    public double averagePredictedClassValue(Rule r) {
        double sum = 0.0;
        Function function = r.getFunction();
        Mask covered = new Mask(this.size());
        this.filter(covered, r);
        covered.resetIndex();
        while (covered.next()) {
            sum += function.predict(this.itemset(covered.getIndex()));
        }
        return sum / (double)covered.getnActive();
    }

    public double averageValue(int att) {
        double sum = 0.0;
        for (int i = 0; i < this.numItemsets(); ++i) {
            sum += ((Itemset)this.itemsets.elementAt(i)).getValue(att);
        }
        return sum / (double)this.numItemsets();
    }

    public MyDataset discretToBinary() {
        int[][] indices = this.sortByAverageClassValues();
        MyDataset output = this.convertAttributes(indices);
        this.convertItemsets(output, indices);
        return output;
    }

    public int[][] sortByAverageClassValues() {
        int[][] indices = new int[this.numAttributes()][];
        double[][] avgClassValues = new double[this.numAttributes()][0];
        for (int j = 0; j < this.numAttributes(); ++j) {
            MyAttribute att = this.getAttribute(j);
            if (!att.isDiscret()) continue;
            avgClassValues[j] = new double[att.numValues()];
            double[] counts = new double[att.numValues()];
            for (int i = 0; i < this.numItemsets(); ++i) {
                Itemset itemset = this.itemset(i);
                if (itemset.classIsMissing() || itemset.isMissing(j)) continue;
                int n = (int)itemset.getValue(j);
                counts[n] = counts[n] + itemset.getWeight();
                double[] dArray = avgClassValues[j];
                int n2 = (int)itemset.getValue(j);
                dArray[n2] = dArray[n2] + itemset.getWeight() * itemset.getClassValue();
            }
            double sum = M5StaticUtils.sum(avgClassValues[j]);
            double totalCounts = M5StaticUtils.sum(counts);
            if (M5StaticUtils.gr(totalCounts, 0.0)) {
                for (int k = 0; k < att.numValues(); ++k) {
                    if (M5StaticUtils.gr(counts[k], 0.0)) {
                        double[] dArray = avgClassValues[j];
                        int n = k;
                        dArray[n] = dArray[n] / counts[k];
                        continue;
                    }
                    avgClassValues[j][k] = sum / totalCounts;
                }
            }
            indices[j] = M5StaticUtils.sort(avgClassValues[j]);
        }
        return indices;
    }

    private MyDataset convertAttributes(int[][] indices) {
        int newClassIndex = this.getClassIndex();
        Vector<Object> newAtts = new Vector<Object>();
        for (int j = 0; j < this.numAttributes(); ++j) {
            MyAttribute att = this.getAttribute(j);
            if (!att.isDiscret() || j == this.getClassIndex()) {
                newAtts.addElement(att.copy());
                continue;
            }
            if (j < this.getClassIndex()) {
                newClassIndex += att.numValues() - 2;
            }
            for (int k = 1; k < att.numValues(); ++k) {
                StringBuffer attributeName = new StringBuffer(att.name() + "=");
                for (int l = k; l < att.numValues(); ++l) {
                    if (l > k) {
                        attributeName.append(',');
                    }
                    attributeName.append(att.value(indices[j][l]));
                }
                MyAttribute newatt = new MyAttribute(attributeName.toString());
                newatt.enumerate();
                newAtts.addElement(newatt);
            }
        }
        MyDataset outputFormat = new MyDataset(this.getName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        return outputFormat;
    }

    private void convertItemsets(MyDataset output, int[][] indices) {
        for (int i = 0; i < this.numItemsets(); ++i) {
            Itemset itemset = this.itemset(i);
            double[] vals = new double[output.numAttributes()];
            int attSoFar = 0;
            for (int j = 0; j < this.numAttributes(); ++j) {
                int k;
                MyAttribute att = this.getAttribute(j);
                if (!att.isDiscret() || j == this.getClassIndex()) {
                    vals[attSoFar] = itemset.getValue(j);
                    ++attSoFar;
                    continue;
                }
                if (itemset.isMissing(j)) {
                    for (k = 0; k < att.numValues() - 1; ++k) {
                        vals[attSoFar + k] = itemset.getValue(j);
                    }
                } else {
                    k = 0;
                    while ((int)itemset.getValue(j) != indices[j][k]) {
                        vals[attSoFar + k] = 1.0;
                        ++k;
                    }
                    while (k < att.numValues() - 1) {
                        vals[attSoFar + k] = 0.0;
                        ++k;
                    }
                }
                attSoFar += att.numValues() - 1;
            }
            Itemset inst = null;
            inst = new Itemset(itemset.getWeight(), vals);
            inst.setDataset(this);
            output.addItemset(inst);
        }
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public String toString() {
        String salida = "";
        for (int i = 0; i < this.itemsets.size(); ++i) {
            double V = ((Itemset)this.itemsets.elementAt(i)).getValue(0);
            salida = ((MyAttribute)this.attributes.elementAt(0)).isDiscret() ? salida + i + ".- (" + Attributes.getAttribute(0).getNominalValue((int)V) : salida + i + ".- (" + V;
            for (int j = 1; j < this.numAttributes(); ++j) {
                if (j == this.getClassIndex()) continue;
                V = ((Itemset)this.itemsets.elementAt(i)).getValue(j);
                salida = ((MyAttribute)this.attributes.elementAt(j)).isDiscret() ? salida + "," + Attributes.getAttribute(j).getNominalValue((int)V) : salida + "," + V;
            }
            V = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            salida = ((MyAttribute)this.attributes.elementAt(this.getClassIndex())).isDiscret() ? salida + ")-> " + Attributes.getAttribute(this.getClassIndex()).getNominalValue((int)V) + "\n" : salida + ")-> " + V + "\n";
        }
        return salida;
    }

    public String toString(Mask mask) {
        String salida = "";
        mask.resetIndex();
        while (mask.next()) {
            int i = mask.getIndex();
            double V = ((Itemset)this.itemsets.elementAt(i)).getValue(0);
            salida = ((MyAttribute)this.attributes.elementAt(0)).isDiscret() ? salida + i + ".- (" + Attributes.getAttribute(0).getNominalValue((int)V) : salida + i + ".- (" + V;
            for (int j = 1; j < this.numAttributes(); ++j) {
                if (j == this.getClassIndex()) continue;
                V = ((Itemset)this.itemsets.elementAt(i)).getValue(j);
                salida = ((MyAttribute)this.attributes.elementAt(j)).isDiscret() ? salida + "," + Attributes.getAttribute(j).getNominalValue((int)V) : salida + "," + V;
            }
            V = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            if (((MyAttribute)this.attributes.elementAt(this.getClassIndex())).isDiscret()) {
                salida = salida + ")-> " + Attributes.getAttribute(this.getClassIndex()).getNominalValue((int)V) + "\n";
                continue;
            }
            salida = salida + ")-> " + V;
        }
        return salida;
    }
}

