/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.DatasetException;
import keel.Dataset.ErrorInfo;
import keel.Dataset.FormatErrorKeeper;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.Instance;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceParser;

public class InstanceSet {
    private Instance[] instanceSet;
    private String header;
    private String attHeader;
    static FormatErrorKeeper errorLogger = new FormatErrorKeeper();
    private InstanceAttributes attributes;
    private boolean storeAttributesAsNonStatic;
    private boolean outputInfered;

    public InstanceSet() {
        this.storeAttributesAsNonStatic = false;
        this.attributes = null;
    }

    public InstanceSet(boolean nonStaticAttributes) {
        this.storeAttributesAsNonStatic = nonStaticAttributes;
        this.attributes = null;
    }

    public InstanceSet(InstanceSet is) {
        this.instanceSet = Arrays.copyOf(is.instanceSet, is.instanceSet.length);
        this.header = new String(is.header);
        this.attHeader = new String(is.attHeader);
        this.attributes = new InstanceAttributes(is.attributes);
        this.storeAttributesAsNonStatic = is.storeAttributesAsNonStatic;
    }

    public void setAttributesAsNonStatic() {
        this.attributes = new InstanceAttributes();
        this.attributes.copyStaticAttributes();
        this.storeAttributesAsNonStatic = true;
    }

    public InstanceAttributes getAttributeDefinitions() {
        return this.attributes;
    }

    public void readSet(String fileName, boolean isTrain) throws DatasetException, HeaderFormatException {
        String line;
        System.out.println("Opening the file: " + fileName + ".");
        errorLogger = new FormatErrorKeeper();
        InstanceParser parser = new InstanceParser(fileName, isTrain);
        this.parseHeader(parser, isTrain);
        System.out.println(" The number of output attributes is: " + Attributes.getOutputNumAttributes());
        if (isTrain && Attributes.getOutputNumAttributes() == 1) {
            Attributes.initStatistics();
        }
        System.out.println("\n\n  > Reading the data ");
        Vector<Instance> tempSet = new Vector<Instance>(1000, 100000);
        while ((line = parser.getLine()) != null) {
            tempSet.addElement(new Instance(line, isTrain, tempSet.size()));
        }
        int sizeInstance = tempSet.size();
        System.out.println("    > Number of instances read: " + tempSet.size());
        this.instanceSet = new Instance[sizeInstance];
        for (int i = 0; i < sizeInstance; ++i) {
            this.instanceSet[i] = (Instance)tempSet.elementAt(i);
        }
        if (errorLogger.getNumErrors() > 0) {
            System.out.println("There has been " + errorLogger.getAllErrors().size() + " errors in the Dataset format.");
            for (int k = 0; k < errorLogger.getNumErrors(); ++k) {
                errorLogger.getError(k).print();
            }
            throw new DatasetException("There has been " + errorLogger.getAllErrors().size() + " errors in the Dataset format", errorLogger.getAllErrors());
        }
        System.out.println("\n  > Finishing the statistics: (isTrain)" + isTrain + ", (# out attributes)" + Attributes.getOutputNumAttributes());
        if (isTrain && Attributes.getOutputNumAttributes() == 1) {
            Attributes.finishStatistics();
        }
        parser.close();
        System.out.println("  >> File LOADED CORRECTLY!!");
    }

    public void parseHeader(InstanceParser parser, boolean isTrain) {
        String line;
        Vector inputAttrNames = new Vector();
        Vector outputAttrNames = new Vector();
        boolean inputsDef = false;
        boolean outputsDef = false;
        this.header = "";
        int attCount = 0;
        int lineCount = 0;
        this.attHeader = null;
        while (!(line = parser.getLine().trim()).equalsIgnoreCase("@data")) {
            String aux;
            line = line.trim();
            ++lineCount;
            if (line.toLowerCase().indexOf("@relation") != -1 && isTrain) {
                Attributes.setRelationName(line.replaceAll("@relation", ""));
            }
            if (line.toLowerCase().indexOf("@attribute") != -1) {
                if (isTrain) {
                    this.insertAttribute(line);
                }
                ++attCount;
            }
            if (line.toLowerCase().indexOf("@inputs") != -1) {
                this.attHeader = this.header;
                inputsDef = true;
                aux = line.substring(8);
                if (isTrain) {
                    this.insertInputOutput(aux, lineCount, inputAttrNames, "inputs", isTrain);
                }
            }
            if (line.toLowerCase().indexOf("@outputs") != -1) {
                if (this.attHeader == null) {
                    this.attHeader = this.header;
                }
                outputsDef = true;
                aux = line.substring(8);
                if (isTrain) {
                    this.insertInputOutput(aux, lineCount, outputAttrNames, "outputs", isTrain);
                }
                System.out.println(" >> Size of the output is: " + outputAttrNames.size());
            }
            this.header = this.header + line + "\n";
        }
        if (this.attHeader == null) {
            this.attHeader = this.header;
        }
        this.processInputsAndOutputs(isTrain, inputsDef, outputsDef, outputAttrNames, inputAttrNames);
    }

    void insertAttribute(String line) {
        line.replace("{", " {");
        StringTokenizer st = new StringTokenizer(line, " [{\t");
        st.nextToken();
        Attribute at = new Attribute();
        at.setName(st.nextToken().trim());
        if (!st.hasMoreTokens()) {
            at.setType(0);
        } else if (line.indexOf("{") != -1) {
            at.setType(0);
            at.setFixedBounds(true);
            int indexL = line.indexOf("{");
            int indexR = line.indexOf("}");
            StringTokenizer st2 = new StringTokenizer(line.substring(indexL + 1, indexR), ",");
            while (st2.hasMoreTokens()) {
                at.addNominalValue(st2.nextToken().trim());
            }
        } else {
            String type = st.nextToken().trim();
            if (type.equalsIgnoreCase("integer")) {
                at.setType(1);
            }
            if (type.equalsIgnoreCase("real")) {
                at.setType(2);
            }
            int indexL = line.indexOf("[");
            int indexR = line.indexOf("]");
            if (indexL != -1 && indexR != -1) {
                StringTokenizer st2 = new StringTokenizer(line.substring(indexL + 1, indexR), ",");
                double min = Double.parseDouble(st2.nextToken().trim());
                double max = Double.parseDouble(st2.nextToken().trim());
                at.setBounds(min, max);
            }
        }
        Attributes.addAttribute(at);
    }

    void insertInputOutput(String line, int lineCount, Vector collection, String type, boolean isTrain) {
        System.out.println(" >> processing: " + line);
        StringTokenizer st = new StringTokenizer(line, ",");
        while (st.hasMoreTokens()) {
            String attName = st.nextToken().trim();
            if (Attributes.getAttribute(attName) == null) {
                ErrorInfo er = new ErrorInfo(10, 0, lineCount, 0, 0, isTrain, "The attribute " + attName + " defined in @" + type + " in test, it has not been defined in @inputs in its train dataset. It will be ignored");
                errorLogger.setError(er);
                continue;
            }
            System.out.println("   > " + type + " attribute considered: " + attName + ".");
            collection.add(attName);
        }
    }

    void processInputsAndOutputs(boolean isTrain, boolean inputsDef, boolean outputsDef, Vector outputAttrNames, Vector inputAttrNames) {
        System.out.println(" >> Processing inputs and outputs");
        this.outputInfered = false;
        if (isTrain) {
            if (!inputsDef && !outputsDef) {
                outputAttrNames.add(Attributes.getAttribute(Attributes.getNumAttributes() - 1).getName());
                inputAttrNames = Attributes.getAttributesExcept(outputAttrNames);
                this.outputInfered = true;
            } else if (!inputsDef && outputsDef) {
                inputAttrNames = Attributes.getAttributesExcept(outputAttrNames);
            } else if (inputsDef && !outputsDef) {
                outputAttrNames = Attributes.getAttributesExcept(inputAttrNames);
                this.outputInfered = true;
            }
            Attributes.setOutputInputAttributes(inputAttrNames, outputAttrNames);
        }
    }

    public boolean isOutputInfered() {
        return this.outputInfered;
    }

    public int getNumInstances() {
        if (this.instanceSet != null) {
            return this.instanceSet.length;
        }
        return 0;
    }

    public Instance getInstance(int whichInstance) {
        if (whichInstance < 0 || whichInstance >= this.instanceSet.length) {
            return null;
        }
        return this.instanceSet[whichInstance];
    }

    public Instance[] getInstances() {
        return this.instanceSet;
    }

    public double getInputNumericValue(int whichInst, int whichAttr) throws ArrayIndexOutOfBoundsException {
        if (whichInst < 0 || whichInst >= this.instanceSet.length) {
            throw new ArrayIndexOutOfBoundsException("You are trying to access to " + whichInst + " instance and there are only " + this.instanceSet.length + ".");
        }
        return this.instanceSet[whichInst].getInputRealValues(whichAttr);
    }

    public double getOutputNumericValue(int whichInst, int whichAttr) throws ArrayIndexOutOfBoundsException {
        if (whichInst < 0 || whichInst >= this.instanceSet.length) {
            throw new ArrayIndexOutOfBoundsException("You are trying to access to " + whichInst + " instance and there are only " + this.instanceSet.length + ".");
        }
        return this.instanceSet[whichInst].getOutputRealValues(whichAttr);
    }

    public String getInputNominalValue(int whichInst, int whichAttr) throws ArrayIndexOutOfBoundsException {
        if (whichInst < 0 || whichInst >= this.instanceSet.length) {
            throw new ArrayIndexOutOfBoundsException("You are trying to access to " + whichInst + " instance and there are only " + this.instanceSet.length + ".");
        }
        return this.instanceSet[whichInst].getInputNominalValues(whichAttr);
    }

    public String getOutputNominalValue(int whichInst, int whichAttr) throws ArrayIndexOutOfBoundsException {
        if (whichInst < 0 || whichInst >= this.instanceSet.length) {
            throw new ArrayIndexOutOfBoundsException("You are trying to access to " + whichInst + " instance and there are only " + this.instanceSet.length + ".");
        }
        return this.instanceSet[whichInst].getOutputNominalValues(whichAttr);
    }

    public void removeInstance(int instNum) {
        if (instNum < 0 || instNum >= this.instanceSet.length) {
            return;
        }
        Instance[] aux = new Instance[this.instanceSet.length - 1];
        int add = 0;
        for (int i = 0; i < this.instanceSet.length; ++i) {
            if (instNum == i) {
                add = 1;
                continue;
            }
            aux[i - add] = this.instanceSet[i];
        }
        this.instanceSet = aux;
        aux = null;
    }

    public boolean removeAttribute(InstanceSet tSet, boolean inputAtt, int whichAtt) {
        int i;
        Attribute attToDel = null;
        attToDel = inputAtt ? (this.storeAttributesAsNonStatic && this.attributes != null ? this.attributes.getInputAttribute(whichAtt) : Attributes.getInputAttribute(whichAtt)) : (this.storeAttributesAsNonStatic && this.attributes != null ? this.attributes.getOutputAttribute(whichAtt) : Attributes.getOutputAttribute(whichAtt));
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            System.out.println("Removing the attribute");
            if (!this.attributes.removeAttribute(inputAtt, whichAtt) || tSet != null && !tSet.attributes.removeAttribute(inputAtt, whichAtt)) {
                return false;
            }
        } else if (!Attributes.removeAttribute(inputAtt, whichAtt)) {
            return false;
        }
        for (i = 0; i < this.instanceSet.length; ++i) {
            if (this.storeAttributesAsNonStatic && this.attributes != null) {
                this.instanceSet[i].removeAttribute(this.attributes, attToDel, inputAtt, whichAtt);
                continue;
            }
            this.instanceSet[i].removeAttribute(attToDel, inputAtt, whichAtt);
        }
        if (tSet != null) {
            for (i = 0; i < tSet.instanceSet.length; ++i) {
                if (this.storeAttributesAsNonStatic && this.attributes != null) {
                    tSet.instanceSet[i].removeAttribute(this.attributes, attToDel, inputAtt, whichAtt);
                    continue;
                }
                tSet.instanceSet[i].removeAttribute(attToDel, inputAtt, whichAtt);
            }
        }
        return true;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String copia) {
        this.header = new String(copia);
    }

    public String getAttHeader() {
        return this.attHeader;
    }

    public void setAttHeader(String copia) {
        this.attHeader = new String(copia);
    }

    public String getNewHeader() {
        String line = "";
        Attribute[] attrs = null;
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            line = "@relation " + this.attributes.getRelationName() + "\n";
            attrs = this.attributes.getInputAttributes();
        } else {
            line = "@relation " + Attributes.getRelationName() + "\n";
            attrs = Attributes.getInputAttributes();
        }
        for (int i = 0; i < attrs.length; ++i) {
            line = line + attrs[i].toString() + "\n";
        }
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            attrs = this.attributes.getOutputAttributes();
            line = line + attrs[0].toString() + "\n";
            line = line + this.attributes.getInputHeader() + "\n";
            line = line + this.attributes.getOutputHeader() + "\n";
        } else {
            attrs = Attributes.getOutputAttributes();
            line = line + attrs[0].toString() + "\n";
            line = line + Attributes.getInputHeader() + "\n";
            line = line + Attributes.getOutputHeader() + "\n";
        }
        return line;
    }

    public String getOriginalHeaderWithoutInOut() {
        String line = "";
        Attribute[] attrs = null;
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            line = "@relation " + this.attributes.getRelationName() + "\n";
            attrs = this.attributes.getAttributes();
        } else {
            line = "@relation " + Attributes.getRelationName() + "\n";
            attrs = Attributes.getAttributes();
        }
        for (int i = 0; i < attrs.length; ++i) {
            line = line + attrs[i].toString() + "\n";
        }
        return line;
    }

    public void print(PrintWriter out) {
        for (int i = 0; i < this.instanceSet.length; ++i) {
            out.println("> Instance " + i + ":");
            if (this.storeAttributesAsNonStatic && this.attributes != null) {
                this.instanceSet[i].print(this.attributes, out);
                continue;
            }
            this.instanceSet[i].print(out);
        }
    }

    public void printAsOriginal(PrintWriter out, int printInOut) {
        out.println(this.header);
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            if (printInOut == 1 || printInOut == 3) {
                out.println(this.attributes.getInputHeader());
            }
            if (printInOut == 2 || printInOut == 3) {
                out.println(this.attributes.getOutputHeader());
            }
        } else {
            if (printInOut == 1 || printInOut == 3) {
                out.println(Attributes.getInputHeader());
            }
            if (printInOut == 2 || printInOut == 3) {
                out.println(Attributes.getOutputHeader());
            }
        }
        out.print("@data");
        for (int i = 0; i < this.instanceSet.length; ++i) {
            out.println();
            if (this.storeAttributesAsNonStatic && this.attributes != null) {
                this.instanceSet[i].printAsOriginal(this.attributes, out);
                continue;
            }
            this.instanceSet[i].printAsOriginal(out);
        }
    }

    public void print() {
        System.out.println("------------- ATTRIBUTES --------------");
        if (this.storeAttributesAsNonStatic && this.attributes != null) {
            this.attributes.print();
        } else {
            Attributes.print();
        }
        System.out.println("-------------- INSTANCES --------------");
        for (int i = 0; i < this.instanceSet.length; ++i) {
            System.out.print("\n> Instance " + i + ":");
            if (this.storeAttributesAsNonStatic && this.attributes != null) {
                this.instanceSet[i].print(this.attributes);
                continue;
            }
            this.instanceSet[i].print();
        }
    }

    public void clearInstances() {
        this.instanceSet = null;
    }

    public void addInstance(Instance inst) {
        Instance[] nVector;
        int i = 0;
        if (this.instanceSet != null) {
            nVector = new Instance[this.instanceSet.length + 1];
            for (i = 0; i < this.instanceSet.length; ++i) {
                nVector[i] = this.instanceSet[i];
            }
        } else {
            nVector = new Instance[1];
        }
        nVector[i] = inst;
        this.instanceSet = nVector;
    }

    public void clearNonStaticAttributes() {
        this.attributes = null;
    }

    public void addAttribute(Attribute at) {
        if (this.attributes == null) {
            this.attributes = new InstanceAttributes();
        }
        this.attributes.addAttribute(at);
    }
}

