/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.ICPL;

import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class ICPLGenerator
extends PrototypeGenerator {
    private int nAlg;
    private String method;
    private int k;
    private int Q;
    protected int numberOfPrototypes;
    protected int numberOfClass;

    public ICPLGenerator(PrototypeSet _trainingDataSet, int nalg, String Method, int k, int Q) {
        super(_trainingDataSet);
        this.algorithmName = "ICPL";
        this.nAlg = nalg;
        this.method = Method;
        this.k = k;
        this.Q = Q;
    }

    public ICPLGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "ICPL";
        this.nAlg = parameters.getNextAsInt();
        this.method = parameters.getNextAsString();
        this.k = parameters.getNextAsInt();
        this.Q = parameters.getNextAsInt();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Isaac dice: nalg= " + this.nAlg + " method = " + this.method);
        System.out.println("Number of class= " + this.numberOfClass);
    }

    protected PrototypeSet icpl1_or_3(int num) {
        PrototypeSet C2;
        PrototypeSet C1;
        if (num == 1) {
            System.out.println("Algorithm ICPL 1");
            C1 = this.TPA();
            C2 = this.filtering();
        } else {
            System.out.println("Algorithm ICPL 3");
            C2 = this.TPA();
            C1 = this.filtering();
        }
        PrototypeSet S = C1.clone();
        for (Prototype p : C2) {
            PrototypeSet tmp = S.addPrototype2(p);
            double Good = 0.0;
            double Bad = 0.0;
            PrototypeSet neig = this.trainingDataSet.isTheNearPrototype(p);
            for (Prototype q : neig) {
                if (q.getOutput(0) == p.getOutput(0)) {
                    Good += 1.0;
                    continue;
                }
                Bad += 1.0;
            }
            if (!(Good > Bad)) continue;
            S.add(p);
        }
        return S;
    }

    protected PrototypeSet icpl2_or_4(int num) {
        PrototypeSet tmp;
        PrototypeSet C2;
        PrototypeSet C1;
        PrototypeSet S = new PrototypeSet();
        if (num == 2) {
            C1 = this.TPA();
            C2 = this.filtering();
        } else {
            C2 = this.TPA();
            C1 = this.filtering();
        }
        S = new PrototypeSet(C1);
        System.out.println("C1 size =" + C1.size() + " C2size =" + C2.size());
        Prototype p2 = (Prototype)C1.get(1);
        double Good = 0.0;
        double Bad = 0.0;
        for (Prototype p : C2) {
            tmp = S.addPrototype2(p);
            Good = 0.0;
            Bad = 0.0;
            PrototypeSet neig = this.trainingDataSet.isTheNearPrototype(p);
            for (Prototype q : neig) {
                if (q.getOutput(0) == p.getOutput(0)) {
                    Good += 1.0;
                    continue;
                }
                Bad += 1.0;
            }
            if (!(Good > Bad)) continue;
            S.add(p);
        }
        for (Prototype p : C1) {
            tmp = new PrototypeSet(S.without(p));
            double With = KNN.classficationAccuracy(S, this.trainingDataSet);
            double Without = KNN.classficationAccuracy(tmp, this.trainingDataSet);
            if (!(Without >= With)) continue;
            S = new PrototypeSet(tmp);
        }
        return S;
    }

    protected double typicality(int index) {
        double result = 0.0;
        double avgDifClass = 0.0;
        Prototype initial = (Prototype)this.trainingDataSet.get(index);
        PrototypeSet sameClass = this.trainingDataSet.getFromClass(initial.getOutput(0)).without(initial);
        PrototypeSet differentClass = this.trainingDataSet.getAllDifferentFromClass(initial.getOutput(0));
        for (Prototype p : sameClass) {
            result += 1.0 - Distance.d(initial, p);
        }
        result /= (double)sameClass.size();
        for (Prototype p : differentClass) {
            avgDifClass += 1.0 - Distance.d(initial, p);
        }
        return result / (avgDifClass /= (double)differentClass.size());
    }

    protected boolean[] identifyBorder(PrototypeSet[] pClass) {
        int i;
        boolean[] borders = new boolean[this.trainingDataSet.size()];
        double[] typ = new double[this.trainingDataSet.size()];
        Arrays.fill(borders, false);
        for (i = 0; i < this.trainingDataSet.size(); ++i) {
            typ[i] = this.typicality(i);
        }
        double[] Tmean = new double[this.numberOfClass];
        double[] Tsd = new double[this.numberOfClass];
        for (i = 0; i < this.numberOfClass; ++i) {
            int m;
            pClass[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
            Arrays.fill(Tmean, 0.0);
            Arrays.fill(Tsd, 0.0);
            for (m = 0; m < pClass[i].size(); ++m) {
                int n = i;
                Tmean[n] = Tmean[n] + typ[((Prototype)pClass[i].get(m)).getIndex()];
            }
            int n = i;
            Tmean[n] = Tmean[n] / (double)pClass[i].size();
            for (m = 0; m < pClass[i].size(); ++m) {
                double aux = typ[((Prototype)pClass[i].get(m)).getIndex()] - Tmean[i];
                aux *= aux;
                int n2 = i;
                Tsd[n2] = Tsd[n2] + aux;
            }
            int n3 = i;
            Tsd[n3] = Tsd[n3] / (double)pClass[i].size();
            System.out.println("Tmean = " + Tmean[i] + " Tsd = " + Tsd[i]);
            for (int k = 0; k < pClass[i].size(); ++k) {
                for (int j = 0; j < pClass[i].size() - 1; ++j) {
                    if (!(typ[((Prototype)pClass[i].get(j)).getIndex()] < typ[((Prototype)pClass[i].get(j + 1)).getIndex()])) continue;
                    Prototype aux = (Prototype)pClass[i].get(j);
                    pClass[i].set(j, pClass[i].get(j + 1));
                    pClass[i].set(j + 1, aux);
                }
            }
        }
        for (i = 0; i < this.numberOfClass; ++i) {
            for (int j = 0; j < pClass[i].size(); ++j) {
                borders[((Prototype)pClass[i].get((int)j)).getIndex()] = typ[((Prototype)pClass[i].get(j)).getIndex()] < Tmean[i] - Tsd[i];
            }
        }
        return borders;
    }

    protected PrototypeSet TPA() {
        PrototypeSet S = new PrototypeSet();
        PrototypeSet[] pClass = new PrototypeSet[this.numberOfClass];
        boolean[] borders = this.identifyBorder(pClass);
        PrototypeSet process = new PrototypeSet();
        PrototypeSet merge = new PrototypeSet();
        for (int i = 0; i < this.numberOfClass; ++i) {
            for (int k = 0; k < pClass[i].size(); ++k) {
                Prototype instance = (Prototype)pClass[i].get(k);
                if (borders[instance.getIndex()] || process.contains(instance)) continue;
                process.add(instance);
                Prototype P = this.Merge(S, borders, instance, merge);
                if (this.trainingDataSet.contains(P)) continue;
                S.add(P);
            }
        }
        System.out.println("S size = " + S.size());
        System.out.println("Abstracction Accuracy % " + ICPLGenerator.accuracy(S, this.trainingDataSet));
        System.out.println("data retention rate " + (double)S.size() * 1.0 / (double)this.trainingDataSet.size());
        return S;
    }

    protected Prototype Merge(PrototypeSet S, boolean[] borders, Prototype I, PrototypeSet merge) {
        Prototype P = new Prototype();
        PrototypeSet tData = new PrototypeSet(this.trainingDataSet);
        P = I;
        Prototype N = tData.nearestTo(I);
        double Clase = I.getOutput(0);
        while (N.getOutput(0) != Clase || !borders[N.getIndex()]) {
            if (N.getOutput(0) != Clase && (N = (tData = tData.without(N)).nearestTo(I)).getOutput(0) != Clase) {
                return P;
            }
            if (borders[N.getIndex()]) {
                return P;
            }
            if (!merge.contains(N)) {
                P = P.avg(N);
                merge.add(N);
                tData = tData.without(N);
                N = tData.nearestTo(I);
                continue;
            }
            if (S.size() > 0) {
                Prototype M = S.nearestTo(N);
                P = P.avg(M);
                S.remove(M);
            }
            return P;
        }
        return P;
    }

    protected PrototypeSet filtering() {
        PrototypeSet result = new PrototypeSet();
        if (this.method.equals("ENN")) {
            result = this.ENN(this.trainingDataSet);
        } else if (this.method.equals("ACC")) {
            result = this.ACC(this.trainingDataSet);
        } else if (this.method.equals("RT2")) {
            result = this.RT2(this.trainingDataSet);
        }
        System.out.println("Filtering Accuracy % " + ICPLGenerator.accuracy(result, this.trainingDataSet));
        System.out.println("Filtering Reduction % " + (100 - result.size() * 100 / this.trainingDataSet.size()));
        System.out.println("FILTERING retention rate " + (double)result.size() * 1.0 / (double)this.trainingDataSet.size());
        return result;
    }

    protected PrototypeSet ENN(PrototypeSet T) {
        PrototypeSet Sew = new PrototypeSet(T);
        int majority = this.k / 2 + 1;
        int[] toClean = new int[T.size()];
        Arrays.fill(toClean, 0);
        int pos = 0;
        for (Prototype p : T) {
            double class_p = p.getOutput(0);
            PrototypeSet neighbors = KNN.knn(p, this.trainingDataSet, this.k);
            int counter = 0;
            for (Prototype q1 : neighbors) {
                double class_q1 = q1.getOutput(0);
                if (class_q1 != class_p) continue;
                ++counter;
            }
            if (counter < majority) {
                toClean[pos] = 1;
            }
            ++pos;
        }
        PrototypeSet aux = new PrototypeSet();
        for (int i = 0; i < toClean.length; ++i) {
            if (toClean[i] != 0) continue;
            aux.add(T.get(i));
        }
        Sew = aux;
        return Sew;
    }

    protected PrototypeSet ACC(PrototypeSet T) {
        PrototypeSet result = new PrototypeSet();
        int[] accuracy = new int[T.size()];
        Arrays.fill(accuracy, 0);
        int pos = 0;
        for (Prototype p : T) {
            Prototype near = T.nearestTo(p);
            if (p.getOutput(0) == near.getOutput(0)) {
                int n = near.getIndex();
                accuracy[n] = accuracy[n] + 1;
            }
            ++pos;
        }
        for (int i = 0; i < T.size(); ++i) {
            if (accuracy[i] <= this.Q) continue;
            result.add(T.get(i));
        }
        return result;
    }

    protected PrototypeSet associatesPrototype(PrototypeSet one, Prototype other) {
        PrototypeSet result = new PrototypeSet();
        for (Prototype p : one) {
            PrototypeSet nearest = KNN.getNearestNeighbors(p, one, this.k);
            if (!nearest.contains(other)) continue;
            result.add(p);
        }
        return result;
    }

    protected PrototypeSet RT2(PrototypeSet T) {
        PrototypeSet result = new PrototypeSet();
        result = this.ENN(T);
        for (int i = 0; i < result.size(); ++i) {
            ((Prototype)result.get(i)).setIndex(i);
        }
        double[] DistunlikeNeighbor = new double[result.size()];
        int pos = 0;
        for (Prototype p : result) {
            Prototype nearestUnlike = KNN.getNearestWithDifferentClassAs(p, result);
            DistunlikeNeighbor[pos] = Distance.d(p, nearestUnlike);
            ++pos;
        }
        for (int k = 0; k < result.size(); ++k) {
            for (int j = 0; j < result.size() - 1; ++j) {
                if (!(DistunlikeNeighbor[((Prototype)result.get(j)).getIndex()] < DistunlikeNeighbor[((Prototype)result.get(j + 1)).getIndex()])) continue;
                Prototype aux = (Prototype)result.get(j);
                result.set(j, result.get(j + 1));
                result.set(j + 1, aux);
            }
        }
        PrototypeSet[] associates = new PrototypeSet[result.size()];
        pos = 0;
        for (Prototype p : result) {
            associates[pos] = this.associatesPrototype(result, p);
            ++pos;
        }
        int majorityK = this.k / 2 + 1;
        int[] toClean = new int[result.size()];
        Arrays.fill(toClean, 0);
        for (int i = 0; i < result.size(); ++i) {
            Prototype p = (Prototype)result.get(i);
            int majority = associates[i].size() / 2 + 1;
            int asociatesFail = 0;
            PrototypeSet withoutP = result.without(p);
            double class_p = p.getOutput(0);
            for (int j = 0; j < associates[i].size(); ++j) {
                PrototypeSet newNeighbors = KNN.getNearestNeighbors((Prototype)associates[i].get(j), withoutP, this.k);
                int counter = 0;
                for (Prototype q1 : newNeighbors) {
                    double class_q1 = q1.getOutput(0);
                    if (class_q1 != class_p) continue;
                    ++counter;
                }
                if (counter >= majorityK) continue;
                ++asociatesFail;
            }
            if (asociatesFail < majority) continue;
            toClean[i] = 1;
        }
        PrototypeSet clean = new PrototypeSet();
        for (int i = 0; i < result.size(); ++i) {
            if (toClean[i] != 0) continue;
            clean.add(result.get(i));
        }
        return clean;
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of class " + this.numberOfClass);
        for (int i = 0; i < this.trainingDataSet.size(); ++i) {
            ((Prototype)this.trainingDataSet.get(i)).setIndex(i);
        }
        PrototypeSet outputDataSet = new PrototypeSet();
        outputDataSet = this.nAlg == 1 || this.nAlg == 3 ? this.icpl1_or_3(this.nAlg) : this.icpl2_or_4(this.nAlg);
        System.out.println("Accuracy % " + ICPLGenerator.accuracy(outputDataSet, this.trainingDataSet));
        System.out.println("Reduction % " + (100 - outputDataSet.size() * 100 / this.trainingDataSet.size()));
        return outputDataSet;
    }

    public static void main(String[] args) {
        Parameters.setUse("ICPL", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        ICPLGenerator.setSeed(seed);
        ICPLGenerator generator = new ICPLGenerator(training, 1, "ENN", 4, 40);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

