/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public abstract class IStateIntVector {
    public static final int MIN_CAPACITY = 8;
    protected int[] elementData;
    protected IStateInt size;
    protected final IEnvironment environment;

    public IStateIntVector(IEnvironment env, int initialSize, int initialValue) {
        int initialCapacity = 8;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = env.makeInt(initialSize);
    }

    public IStateIntVector(IEnvironment env, int[] entries) {
        int initialCapacity = 8;
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        System.arraycopy(entries, 0, this.elementData, 0, initialSize);
        this.size = env.makeInt(initialSize);
    }

    protected boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    public abstract void add(int var1);

    public int quickGet(int index) {
        assert (this.rangeCheck(index));
        return this.elementData[index];
    }

    public abstract int set(int var1, int var2);

    public abstract int quickSet(int var1, int var2);
}

