/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;

public class SparseCCMObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseObjectMatrix1D[] elements;

    public SparseCCMObjectMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseObjectMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseObjectMatrix1D(n);
        }
    }

    public SparseObjectMatrix1D[] elements() {
        return this.elements;
    }

    public Object getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, Object object) {
        this.elements[n2].setQuick(n, object);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseObjectMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseCCMObjectMatrix2D(n, n2);
    }
}

