/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class RegularUnderDifferencingTest
extends AbstractModelController {
    private static final double RTVAL = 1.6;
    private static final double IM = 0.01;
    private static final double MOD = 0.9;

    @Override
    public ProcessingResult process(ModellingContext context) {
        SarimaModel cur = context.estimation.getArima();
        SarimaSpecification spec = cur.getSpecification();
        if (spec.getD() == 2 || spec.getP() == 0 || !context.description.isEstimatedMean()) {
            return ProcessingResult.Unchanged;
        }
        if (this.checkResiduals(context)) {
            return ProcessingResult.Unchanged;
        }
        if (!this.hasQuasiUnitRoots(cur)) {
            return ProcessingResult.Unchanged;
        }
        spec.setD(spec.getD() + 1);
        spec.setP(spec.getP() - 1);
        ModellingContext ncontext = new ModellingContext();
        ncontext.description = context.description.clone();
        ncontext.description.setSpecification(spec);
        ncontext.description.setMean(false);
        if (!this.estimate(ncontext, false)) {
            return ProcessingResult.Failed;
        }
        this.transferInformation(ncontext, context);
        return ProcessingResult.Changed;
    }

    private boolean checkResiduals(ModellingContext context) {
        double rstd;
        double rtval;
        DataBlock res = new DataBlock(context.estimation.getLikelihood().getResiduals());
        double rm = res.sum();
        double rv = res.ssq();
        int n = res.getLength();
        return Math.abs(rtval = (rm /= (double)n) / (rstd = Math.sqrt((rv = rv / (double)n - rm * rm) / (double)n))) <= 1.6;
    }

    private boolean hasQuasiUnitRoots(SarimaModel m) {
        Complex[] roots = m.getRegularAR().mirror().roots();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i].getRe() > 0.0) || !(Math.abs(roots[i].getIm()) <= 0.01) || !(roots[i].abs() >= 0.9)) continue;
            return true;
        }
        return false;
    }
}

