/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import java.io.Closeable;
import java.io.IOException;
import jd2.workspace.file.Index;
import jd2.workspace.io.IoUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

interface Indexer
extends Closeable {
    public void checkId(Index.Key var1) throws IOException;

    public @NonNull Index loadIndex() throws IOException;

    public void storeIndex(@NonNull Index var1) throws IOException;

    default public @NonNull Indexer memoize() {
        final Indexer delegate = this;
        return new Indexer(){
            private Index latest;
            private boolean storeRequired;

            @Override
            public void checkId(Index.Key id) throws IOException {
                delegate.checkId(id);
            }

            @Override
            public Index loadIndex() throws IOException {
                if (this.latest == null) {
                    this.latest = delegate.loadIndex();
                    this.storeRequired = false;
                }
                return this.latest;
            }

            @Override
            public void storeIndex(Index index) throws IOException {
                this.latest = index;
                this.storeRequired = true;
            }

            @Override
            public void close() throws IOException {
                IoUtil.closeAll(this::flushIndex, delegate::close);
            }

            private void flushIndex() throws IOException {
                if (this.latest != null && this.storeRequired) {
                    delegate.storeIndex(this.latest);
                }
            }
        };
    }
}

