/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.SuppressForbidden;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Containers {
    public static final int DEFAULT_EXPECTED_ELEMENTS = 4;
    private static String testsSeedProperty;
    private static final String NOT_AVAILABLE;

    private Containers() {
    }

    @SuppressForbidden
    public static long randomSeed64() {
        if (testsSeedProperty == null) {
            try {
                testsSeedProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("tests.seed", NOT_AVAILABLE);
                    }
                });
            }
            catch (SecurityException e) {
                testsSeedProperty = NOT_AVAILABLE;
                Logger.getLogger(Containers.class.getName()).log(Level.INFO, "Failed to read 'tests.seed' property for initial random seed.", e);
            }
        }
        long initialSeed = testsSeedProperty != NOT_AVAILABLE ? (long)testsSeedProperty.hashCode() : System.nanoTime() ^ (long)System.identityHashCode(new Object());
        return BitMixer.mix64(initialSeed);
    }

    static void test$reset() {
        testsSeedProperty = null;
    }

    static {
        NOT_AVAILABLE = new String();
    }
}

