# potools 0.2.3 (in development)

## New features

 * To encourage a more modular workflow, `translate_package()` has been split into individual exported functions. Thanks @hadley for the suggestion & design review, in addition to the effort filing PRs to achieve this.
    + `po_extract()` extracts messages from package source code to create template `.pot` files (@hadley, [#243](https://github.com/MichaelChirico/potools/pull/243)).
    + `po_create()` creates skeletal `.po` files for a given language from the `.pot` template (@hadley, [#235](https://github.com/MichaelChirico/potools/pull/235))
    + `po_compile()` converts `.po` translation files into binary `.mo` files used for installation (@hadley, [#234](https://github.com/MichaelChirico/potools/pull/234)).
    + `po_update()` incorporates and merges source message changes to existing `.po` files (@hadley, [#235](https://github.com/MichaelChirico/potools/pull/235))
 * Two new vignettes, ["Translation for package developers"](https://michaelchirico.github.io/potools/articles/developers.html) and ["Translation for package translators"](https://michaelchirico.github.io/potools/articles/translators.html) explain in some detail the process of translation from two perspectives -- that of the package developer and that of the message translator.
 * `check_potools_sys_reqs()` (mostly intended for internal use, but exported for testing) gains a `which` argument to fine-tune which system requirements to check, [#275](https://github.com/MichaelChirico/potools/issues/275) and [#288](https://github.com/MichaelChirico/potools/issues/288). Thanks @hadley for the suggestion and @LDalby for early dev testing which emphasized the need for this.
 * New `po_explain_plurals()` helps de-mystify how to supply plurals for different languages. For example, `po_explain_plurals("pl", 3)` explains that "For Polish (Polski), plural index 2 applies when n = 0, 5-21, 25-31, 35-41, ...", [#278](https://github.com/MichaelChirico/potools/issues/278). Thanks @hadley for the suggestion to independently export this functionality which was already used as part of `translate_package()`.

## Bug fixes

 * `translate_package()` works in batch mode, [#224](https://github.com/MichaelChirico/potools/issues/224). Thanks @HenrikBengtsson for the report.
 * `check_cracked_messages()` recognizes named arguments (e.g. `call.` to `stop()` or `appendLF` to `message()`) and keeps them in the original call, [#227](https://github.com/MichaelChirico/potools/issues/227). Thanks @hadley for the report.
 * A test for non-GNU versions of `gettext` has been improved, [#221](https://github.com/MichaelChirico/potools/issues/221). Please report any issues here -- I don't have any good way of testing non-GNU tools.
 * .po files generated by {potools} will default to using `charset=UTF-8`, not `charset=ASCII`, to prevent encoding issues (@michaelchirico, [#299](https://github.com/MichaelChirico/potools/issues/299)). Thanks @maelle for the report!

## Notes

 * {potools} now has a site built by [`pkgdown`](https://github.com/r-lib/pkgdown) and hosted on GitHub pages: https://michaelchirico.github.io/potools/. Thanks @hadley for the initial implementation.
 * {potools} has a new hex logo featuring a [potoo](https://en.wikipedia.org/wiki/Potoo)! Thanks to @hadley for coordinating and @allisonhorst for the drawing!
 * The test suite now relies on the 3rd edition of `testthat`, meaning a version requirement in the Suggested dependency.
 * The default value of `verbose` has been changed to `TRUE` in `translate_package()` and `get_message_data()`. Verbosity has also been increased to help detect the source of issues, [#288](https://github.com/MichaelChirico/potools/issues/288). Thanks for @LDalby for reporting an unhelpful error.
 * The package now contains Japanese translations of `potools` itself to serve as an example. See [po/R-ja.po](po/R-ja.po). [#241](https://github.com/MichaelChirico/potools/issues/241); thanks @HenrikBengtsson for the suggestion.

## New languages/locales supported out of the box:

 * Swedish (svenska)

# potools 0.2.2 (July 2021)

 * Skip tests on machines where `gettext` is unavailable, #187; also alter the `msgfmt` command executed to create .mo files to skip options unavailable on Solaris, #218
 * Faster parsing of src messages (e.g. `get_message_data()` for the `base` package reduced from 14 to 7 seconds), #119
 * [New feature] New argument `max_translations` for `translate_package()` to limit the number of translations done, #188
 * When adding metadata for a new language, added tolerance for whitespace differences in specifying `plurals`, #183
 * [New feature] `get_message_data()` skips over messages on lines with comments `# notranslate`, and regions of lines between matched pairs of comments `# notranslate start` and `# notranslate end`, #10. Most useful for small fragmentary strings that are untranslateable/not worth translating, and for strings that are technically untranslateable (e.g., because they contain `\r`).
 * [New function] `write_po_file()` to convert a message database to a `.po` or `.pot` file manually (previously this was handled internally by `translate_package()`), #203. Also a constructor for the associated `po_metadata` class, `po_metadata()`. See `?po_metadata`.
 * [Bugfix] `get_message_data()` does a better job on files with unmatched parentheses inside preprocessor macros (`#define`s) in C/C++ files, #199

# potools 0.2.0 (June 2021)

 * Landed on CRAN!
