/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;

public class AllValuesDiscretizer
extends AbstractDiscretizationMethod {
    private DataView population;
    private NumericAttribute attribute;
    private static final String NAME = "AllValuesDiscretizer";

    public AllValuesDiscretizer(DataView population, NumericAttribute na) {
        this.population = population;
        this.attribute = na;
    }

    @Override
    public List<Double> getCutpoints() {
        ArrayList<Double> cutpoints = new ArrayList<Double>();
        List<DataRecord> sortedDataRecords = DiscretizationUtils.getSortedDataRecords(this.population, this.attribute, false, false);
        double value = Double.NaN;
        double lastValue = Double.NaN;
        for (DataRecord dr : sortedDataRecords) {
            lastValue = value;
            value = dr.getValue(this.attribute);
            if (Double.isNaN(lastValue) || lastValue == value) continue;
            cutpoints.add((lastValue + value) / 2.0);
        }
        return cutpoints;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public NumericAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public DataView getPopulation() {
        return this.population;
    }

    @Override
    public void setAttribute(NumericAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public void setPopulation(DataView population) {
        this.population = population;
    }

    @Override
    public void setSegmentsCount(int segmentsCount) {
    }

    @Override
    public List<Double> getSortedSample() {
        return null;
    }
}

