% Generated by roxygen2: do not edit by hand
\name{crossprod}
\alias{crossprod}
\alias{tcrossprod}
\title{Cross-Product and Transposed Cross-Product of Matrices}
\arguments{
  \item{x}{a numeric or complex vector or matrix}
  \item{y}{optional, a numeric or complex vector or matrix compatible with x for cross-product
}
}

\details{
Compute the cross-product of a matrix with itself
\code{
A <- matrix(1:4, nrow = 2)
crossprod(A)  # t(A) \%*\% A    = A'A = positive (semi-)definite
tcrossprod(A) #    A \%*\% t(A) = AA' = positive (semi-)definite
}

Compute the cross-product of two matrices or matrix/vector
\code{
B <- matrix(5:8, nrow = 2)
crossprod(A, B)  # = t(A) \%*\% B = A'B
}

Compute the "transposed cross-product" of two matrices
\code{
tcrossprod(A, B)  # A \%*\% t(B) = AB'
}}

