/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class SteppingStoneSamplingAnalysis {
    public static final String STEPPING_STONE_SAMPLING_ANALYSIS = "steppingStoneSamplingAnalysis";
    public static final String RESULT_FILE_NAME = "resultsFileName";
    public static final String LIKELIHOOD_COLUMN = "likelihoodColumn";
    public static final String THETA_COLUMN = "thetaColumn";
    public static final String FORMAT = "%5.5g";
    private final String logLikelihoodName;
    private final List<Double> logLikelihoodSample;
    private final List<Double> thetaSample;
    private boolean logBayesFactorCalculated = false;
    private double logBayesFactor;
    private List<Double> maxLogLikelihood;
    private List<Double> mlContribution;
    private List<Double> orderedTheta;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately)"), new StringAttributeRule("resultsFileName", "The name of the output file to which the stepping-stone sampling estimate will be written", true), new ElementRule("thetaColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")}), new ElementRule("likelihoodColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")})};

        @Override
        public String getParserName() {
            return SteppingStoneSamplingAnalysis.STEPPING_STONE_SAMPLING_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            String string2 = null;
            if (xMLObject.hasAttribute(SteppingStoneSamplingAnalysis.RESULT_FILE_NAME)) {
                string2 = xMLObject.getStringAttribute(SteppingStoneSamplingAnalysis.RESULT_FILE_NAME);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            System.out.println(n + " file(s) found with marginal likelihood samples");
            try {
                Object object;
                Object object2;
                String string3 = "";
                List<Double> list = null;
                List<Double> list2 = null;
                for (int i = 0; i < n; ++i) {
                    object2 = new File(stringTokenizer.nextToken());
                    object = ((File)object2).getName();
                    String string4 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string4 = string4 == null ? System.getProperty("user.dir") : Paths.get(System.getProperty("user.dir"), string4).toString();
                    }
                    String string5 = System.getProperty("file.name.prefix");
                    String string6 = System.getProperty("file.separator");
                    if (string5 != null) {
                        if (string5.trim().length() == 0 || string5.contains(string6)) {
                            throw new XMLParseException("The specified file name prefix is illegal.");
                        }
                        object2 = new File(string4, string5 + (String)object);
                    } else {
                        object2 = new File(string4, (String)object);
                    }
                    string = ((File)object2).getAbsolutePath();
                    XMLObject xMLObject2 = xMLObject.getChild(SteppingStoneSamplingAnalysis.LIKELIHOOD_COLUMN);
                    string3 = xMLObject2.getStringAttribute("name");
                    xMLObject2 = xMLObject.getChild(SteppingStoneSamplingAnalysis.THETA_COLUMN);
                    String string7 = xMLObject2.getStringAttribute("name");
                    LogFileTraces logFileTraces = new LogFileTraces(string, (File)object2);
                    logFileTraces.loadTraces();
                    int n2 = 0;
                    logFileTraces.setBurnIn(n2);
                    int n3 = -1;
                    int n4 = -1;
                    for (int j = 0; j < logFileTraces.getTraceCount(); ++j) {
                        String string8 = logFileTraces.getTraceName(j);
                        if (string8.trim().equals(string3)) {
                            n3 = j;
                        }
                        if (!string8.trim().equals(string7)) continue;
                        n4 = j;
                    }
                    if (n3 == -1) {
                        throw new XMLParseException("Column '" + string3 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (n4 == -1) {
                        throw new XMLParseException("Column '" + string7 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (list == null && list2 == null) {
                        list = logFileTraces.getValues(n3);
                        list2 = logFileTraces.getValues(n4);
                        continue;
                    }
                    list.addAll(logFileTraces.getValues(n3));
                    list2.addAll(logFileTraces.getValues(n4));
                }
                SteppingStoneSamplingAnalysis steppingStoneSamplingAnalysis = new SteppingStoneSamplingAnalysis(string3, list, list2);
                System.out.println(steppingStoneSamplingAnalysis.toString());
                if (string2 != null) {
                    object2 = new FileWriter(string2, true);
                    object = new BufferedWriter((Writer)object2);
                    ((Writer)object).write(steppingStoneSamplingAnalysis.toString());
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                return steppingStoneSamplingAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis.";
        }

        @Override
        public Class getReturnType() {
            return SteppingStoneSamplingAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public SteppingStoneSamplingAnalysis(String string, List<Double> list, List<Double> list2) {
        this.logLikelihoodSample = list;
        this.logLikelihoodName = string;
        this.thetaSample = list2;
    }

    public double getLogBayesFactor() {
        if (!this.logBayesFactorCalculated) {
            this.calculateBF();
        }
        return this.logBayesFactor;
    }

    private void calculateBF() {
        int n;
        double d2;
        HashMap hashMap = new HashMap();
        this.orderedTheta = new ArrayList<Double>();
        for (int i = 0; i < this.logLikelihoodSample.size(); ++i) {
            if (!hashMap.containsKey(this.thetaSample.get(i))) {
                hashMap.put(this.thetaSample.get(i), new ArrayList());
                this.orderedTheta.add(this.thetaSample.get(i));
            }
            ((List)hashMap.get(this.thetaSample.get(i))).add(this.logLikelihoodSample.get(i));
        }
        Collections.sort(this.orderedTheta);
        this.maxLogLikelihood = new ArrayList<Double>();
        for (double d2 : this.orderedTheta) {
            List list = (List)hashMap.get(d2);
            this.maxLogLikelihood.add((Double)Collections.max(list));
        }
        this.mlContribution = new ArrayList<Double>();
        this.logBayesFactor = 0.0;
        for (n = 1; n < this.orderedTheta.size(); ++n) {
            d2 = (this.orderedTheta.get(n) - this.orderedTheta.get(n - 1)) * this.maxLogLikelihood.get(n - 1);
            this.logBayesFactor += d2;
            this.mlContribution.add(d2);
        }
        for (n = 1; n < this.orderedTheta.size(); ++n) {
            d2 = 0.0;
            for (int i = 0; i < ((List)hashMap.get(this.orderedTheta.get(n - 1))).size(); ++i) {
                d2 += Math.exp((this.orderedTheta.get(n) - this.orderedTheta.get(n - 1)) * ((Double)((List)hashMap.get(this.orderedTheta.get(n - 1))).get(i) - this.maxLogLikelihood.get(n - 1)));
            }
            this.logBayesFactor += Math.log(d2 /= (double)((List)hashMap.get(this.orderedTheta.get(n - 1))).size());
            this.mlContribution.set(n - 1, this.mlContribution.get(n - 1) + Math.log(d2));
        }
        this.logBayesFactorCalculated = true;
    }

    public String toString() {
        double d = this.getLogBayesFactor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PathParameter\tMaxPathLikelihood\tMLContribution\n");
        for (int i = 0; i < this.orderedTheta.size(); ++i) {
            stringBuffer.append(String.format(FORMAT, this.orderedTheta.get(i)));
            stringBuffer.append("\t");
            stringBuffer.append(String.format(FORMAT, this.maxLogLikelihood.get(i)));
            stringBuffer.append("\t");
            if (i != this.orderedTheta.size() - 1) {
                stringBuffer.append(String.format(FORMAT, this.mlContribution.get(i)));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nlog marginal likelihood (using stepping stone sampling) from " + this.logLikelihoodName + " = " + d + "\n");
        return stringBuffer.toString();
    }
}

