/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.MultivariateDistribution;
import dr.xml.Reportable;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.SymmTridiagMatrix;

public class GmrfDistributionLikelihood
extends AbstractModelLikelihood
implements MultivariateDistribution,
Reportable {
    private Parameter precisionParameter;
    private Parameter lambdaParameter;
    private Parameter gridParameter;
    private int fieldLength;
    private Parameter data;
    private SymmTridiagMatrix weightMatrix;
    private static final double LOG_TWO_TIMES_PI = 1.837877;

    public GmrfDistributionLikelihood(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(string);
        this.precisionParameter = parameter;
        this.lambdaParameter = parameter2;
        this.gridParameter = parameter3;
        this.fieldLength = parameter4.getDimension();
        this.data = parameter4;
        this.setupGMRFWeights();
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
    }

    @Override
    public double logPdf(double[] dArray) {
        DenseVector denseVector = new DenseVector(dArray.length);
        DenseVector denseVector2 = new DenseVector(dArray);
        SymmTridiagMatrix symmTridiagMatrix = this.getScaledWeightMatrix(this.precisionParameter.getParameterValue(0), this.lambdaParameter.getParameterValue(0));
        symmTridiagMatrix.mult(denseVector2, denseVector);
        double d = 0.0;
        d += 0.5 * (double)(this.fieldLength - 1) * Math.log(this.precisionParameter.getParameterValue(0)) - 0.5 * denseVector2.dot(denseVector);
        d = this.lambdaParameter.getParameterValue(0) == 1.0 ? (d -= (double)(this.fieldLength - 1) / 2.0 * 1.837877) : (d -= (double)this.fieldLength / 2.0 * 1.837877);
        return d;
    }

    private void setupGMRFWeights() {
        int n;
        double[] dArray = new double[this.fieldLength - 1];
        double[] dArray2 = new double[this.fieldLength];
        for (n = 0; n < this.fieldLength - 1; ++n) {
            dArray[n] = -1.0;
        }
        for (n = 1; n < this.fieldLength - 1; ++n) {
            dArray2[n] = -(dArray[n] + dArray[n - 1]);
        }
        dArray2[0] = -dArray[0];
        dArray2[this.fieldLength - 1] = -dArray[this.fieldLength - 2];
        this.weightMatrix = new SymmTridiagMatrix(dArray2, dArray);
    }

    private SymmTridiagMatrix getScaledWeightMatrix(double d, double d2) {
        if (d2 == 1.0) {
            return this.getScaledWeightMatrix(d);
        }
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(i, i)));
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d * d2);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1)));
        return symmTridiagMatrix;
    }

    private SymmTridiagMatrix getScaledWeightMatrix(double d) {
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, symmTridiagMatrix.get(i, i) * d);
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1) * d);
        return symmTridiagMatrix;
    }

    private DenseVector getMeanAdjustedGamma(double[] dArray) {
        DenseVector denseVector = new DenseVector(dArray);
        return denseVector;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return null;
    }

    @Override
    public double getLogLikelihood() {
        return this.logPdf(this.data.getParameterValues());
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public String getReport() {
        return "gmrfDistributionLikelihood(" + this.getLogLikelihood() + ")";
    }
}

