stopifnot(requireNamespace("Certara.DarwinReporter", quietly = TRUE))

if (!dir.exists("pirana_reports")) {
  dir.create ("pirana_reports")
}

darwin_search_dirs <- list.files(include.dirs = TRUE,
                                 full.names = TRUE,
                                 pattern = "darwin_search")

last_dir <- darwin_search_dirs[length(darwin_search_dirs)]

dd <- Certara.DarwinReporter::darwin_data(project_dir = file.path(last_dir))

dd <- Certara.DarwinReporter::import_key_models(dd,
                                                dir  = file.path(dd$working_dir, "key_models"))

dd <- Certara.DarwinReporter::darwinReportUI(dd)
