/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.util.VertexPair;

public class FloydWarshallShortestPaths<V, E> {
    private Graph<V, E> graph;
    private List<V> vertices;
    private int nShortestPaths = 0;
    private double diameter = 0.0;
    private double[][] d = null;
    private int[][] backtrace = null;
    private Map<VertexPair<V>, GraphPath<V, E>> paths = null;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        this.graph = graph;
        this.vertices = new ArrayList<V>(graph.vertexSet());
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public int getShortestPathsCount() {
        this.lazyCalculatePaths();
        return this.nShortestPaths;
    }

    private void lazyCalculateMatrix() {
        int n;
        if (this.d != null) {
            return;
        }
        int n2 = this.vertices.size();
        this.backtrace = new int[n2][n2];
        for (n = 0; n < n2; ++n) {
            Arrays.fill(this.backtrace[n], -1);
        }
        this.d = new double[n2][n2];
        for (n = 0; n < n2; ++n) {
            Arrays.fill(this.d[n], Double.POSITIVE_INFINITY);
        }
        for (n = 0; n < n2; ++n) {
            this.d[n][n] = 0.0;
        }
        Set<E> set = this.graph.edgeSet();
        for (E e : set) {
            V v = this.graph.getEdgeSource(e);
            V v2 = this.graph.getEdgeTarget(e);
            int n3 = this.vertices.indexOf(v);
            int n4 = this.vertices.indexOf(v2);
            this.d[n3][n4] = this.graph.getEdgeWeight(e);
            if (this.graph instanceof DirectedGraph) continue;
            this.d[n4][n3] = this.graph.getEdgeWeight(e);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double d = this.d[j][i] + this.d[i][k];
                    if (!(d < this.d[j][k])) continue;
                    this.d[j][k] = d;
                    this.backtrace[j][k] = i;
                    this.diameter = this.diameter > this.d[j][k] ? this.diameter : this.d[j][k];
                }
            }
        }
    }

    public double shortestDistance(V v, V v2) {
        this.lazyCalculateMatrix();
        return this.d[this.vertices.indexOf(v)][this.vertices.indexOf(v2)];
    }

    public double getDiameter() {
        this.lazyCalculateMatrix();
        return this.diameter;
    }

    private void shortestPathRecur(List<E> list, int n, int n2) {
        int n3 = this.backtrace[n][n2];
        if (n3 == -1) {
            E e = this.graph.getEdge(this.vertices.get(n), this.vertices.get(n2));
            if (e != null) {
                list.add(e);
            }
        } else {
            this.shortestPathRecur(list, n, n3);
            this.shortestPathRecur(list, n3, n2);
        }
    }

    public GraphPath<V, E> getShortestPath(V v, V v2) {
        this.lazyCalculatePaths();
        return this.getShortestPathImpl(v, v2);
    }

    private GraphPath<V, E> getShortestPathImpl(V v, V v2) {
        int n = this.vertices.indexOf(v);
        int n2 = this.vertices.indexOf(v2);
        ArrayList arrayList = new ArrayList();
        this.shortestPathRecur(arrayList, n, n2);
        if (arrayList.size() < 1) {
            return null;
        }
        GraphPathImpl<V, E> graphPathImpl = new GraphPathImpl<V, E>(this.graph, v, v2, arrayList, arrayList.size());
        return graphPathImpl;
    }

    private void lazyCalculatePaths() {
        if (this.paths != null) {
            return;
        }
        this.lazyCalculateMatrix();
        HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>> hashMap = new HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>>();
        int n = this.vertices.size();
        this.nShortestPaths = 0;
        for (int i = 0; i < n; ++i) {
            V v = this.vertices.get(i);
            for (int j = 0; j < n; ++j) {
                V v2;
                GraphPath<V, E> graphPath;
                if (i == j || (graphPath = this.getShortestPathImpl(v, v2 = this.vertices.get(j))) == null) continue;
                hashMap.put(new VertexPair<V>(v, v2), graphPath);
                ++this.nShortestPaths;
            }
        }
        this.paths = hashMap;
    }

    public List<GraphPath<V, E>> getShortestPaths(V v) {
        this.lazyCalculatePaths();
        ArrayList<GraphPath<V, GraphPath<V, E>>> arrayList = new ArrayList<GraphPath<V, GraphPath<V, E>>>();
        for (VertexPair<V> vertexPair : this.paths.keySet()) {
            if (!vertexPair.getFirst().equals(v)) continue;
            arrayList.add(this.paths.get(vertexPair));
        }
        return arrayList;
    }
}

