/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamError;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;

class TDSTokenHandler {
    final String logContext;
    private StreamError databaseError;

    final StreamError getDatabaseError() {
        return this.databaseError;
    }

    TDSTokenHandler(String string) {
        this.logContext = string;
    }

    boolean onSSPI(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onLoginAck(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onEnvChange(TDSReader tDSReader) throws SQLServerException {
        tDSReader.getConnection().processEnvChange(tDSReader);
        return true;
    }

    boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
        new StreamRetStatus().setFromTDS(tDSReader);
        return true;
    }

    boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onDone(TDSReader tDSReader) throws SQLServerException {
        StreamDone streamDone = new StreamDone();
        streamDone.setFromTDS(tDSReader);
        return true;
    }

    boolean onError(TDSReader tDSReader) throws SQLServerException {
        if (null == this.databaseError) {
            this.databaseError = new StreamError();
            this.databaseError.setFromTDS(tDSReader);
        } else {
            new StreamError().setFromTDS(tDSReader);
        }
        return true;
    }

    boolean onInfo(TDSReader tDSReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tDSReader);
        return true;
    }

    boolean onOrder(TDSReader tDSReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tDSReader);
        return true;
    }

    boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onRow(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onNBCRow(TDSReader tDSReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tDSReader, this.logContext);
        return false;
    }

    boolean onColInfo(TDSReader tDSReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tDSReader);
        return true;
    }

    boolean onTabName(TDSReader tDSReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tDSReader);
        return true;
    }

    void onEOF(TDSReader tDSReader) throws SQLServerException {
        if (null != this.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(tDSReader.getConnection(), null, this.getDatabaseError().getMessage(), this.getDatabaseError(), false);
        }
    }
}

