/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list;

import cern.colt.matrix.DoubleMatrix2D;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.stat.list.ListOfStatProbes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfTallies<E extends Tally>
extends ListOfStatProbes<E> {
    public ListOfTallies() {
    }

    public ListOfTallies(String string) {
        super(string);
    }

    public static ListOfTallies<Tally> createWithTally(int n) {
        ListOfTallies<Tally> listOfTallies = new ListOfTallies<Tally>();
        for (int i = 0; i < n; ++i) {
            listOfTallies.add(new Tally());
        }
        return listOfTallies;
    }

    public static ListOfTallies<TallyStore> createWithTallyStore(int n) {
        ListOfTallies<TallyStore> listOfTallies = new ListOfTallies<TallyStore>();
        for (int i = 0; i < n; ++i) {
            listOfTallies.add(new TallyStore());
        }
        return listOfTallies;
    }

    public void add(double[] dArray) {
        int n = this.size();
        if (dArray.length != n) {
            throw new IllegalArgumentException("Incompatible array length: given " + dArray.length + ", required " + n);
        }
        if (this.collect) {
            for (int i = 0; i < n; ++i) {
                double d = dArray[i];
                Tally tally = (Tally)this.get(i);
                if (Double.isNaN(d) || tally == null) continue;
                tally.add(d);
            }
        }
        this.notifyListeners(dArray);
    }

    public int numberObs() {
        if (this.size() == 0) {
            return 0;
        }
        Tally tally = (Tally)this.get(0);
        return tally == null ? 0 : tally.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int n = this.size();
        int n2 = this.numberObs();
        for (int i = 1; i < n; ++i) {
            Tally tally = (Tally)this.get(i);
            if (tally.numberObs() == n2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void average(double[] dArray) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            double d;
            Tally tally = (Tally)this.get(i);
            dArray[i] = d = tally == null || tally.numberObs() == 0 ? Double.NaN : tally.average();
        }
    }

    public void variance(double[] dArray) {
        if (this.size() != dArray.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        for (int i = 0; i < dArray.length; ++i) {
            Tally tally = (Tally)this.get(i);
            dArray[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.variance();
        }
    }

    public void standardDeviation(double[] dArray) {
        if (this.size() != dArray.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        for (int i = 0; i < dArray.length; ++i) {
            Tally tally = (Tally)this.get(i);
            dArray[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.standardDeviation();
        }
    }

    public double covariance(int n, int n2) {
        if (n == n2) {
            return ((Tally)this.get(n)).variance();
        }
        TallyStore tallyStore = (TallyStore)this.get(n);
        TallyStore tallyStore2 = (TallyStore)this.get(n2);
        return tallyStore.covariance(tallyStore2);
    }

    public double correlation(int n, int n2) {
        if (n == n2) {
            return 1.0;
        }
        double d = this.covariance(n, n2);
        Tally tally = (Tally)this.get(n);
        Tally tally2 = (Tally)this.get(n2);
        if (tally == null || tally2 == null) {
            return Double.NaN;
        }
        return d / Math.sqrt(tally.variance() * tally2.variance());
    }

    public void covariance(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = this.size();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (n = 0; n < n2; ++n) {
            doubleMatrix2D.setQuick(n, n, ((Tally)this.get(n)).variance());
        }
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                double d = this.covariance(n, i);
                doubleMatrix2D.setQuick(n, i, d);
                doubleMatrix2D.setQuick(i, n, d);
            }
        }
    }

    public void correlation(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = this.size();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in correlation matrix");
        }
        if (doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Invalid number of columns in correlation matrix");
        }
        for (n = 0; n < n2; ++n) {
            doubleMatrix2D.setQuick(n, n, 1.0);
        }
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                double d = this.correlation(n, i);
                doubleMatrix2D.setQuick(n, i, d);
                doubleMatrix2D.setQuick(i, n, d);
            }
        }
    }

    @Override
    public ListOfTallies<E> clone() {
        return (ListOfTallies)super.clone();
    }
}

