/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.matrix.MatrixOfObservationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixOfStatProbes<E extends StatProbe>
implements Cloneable,
Iterable<E> {
    private List<MatrixOfObservationListener> listeners = new ArrayList<MatrixOfObservationListener>();
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected String name;
    private E[] probes;
    private int numRows;
    private int numColumns;
    private int modCount = 0;

    public MatrixOfStatProbes(int n, int n2) {
        this.createProbes(n, n2);
    }

    public MatrixOfStatProbes(String string, int n, int n2) {
        this.name = string;
        this.createProbes(n, n2);
    }

    private void createProbes(int n, int n2) {
        if (n < 0) {
            throw new NegativeArraySizeException("The number of rows must not be negative");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException("The number of columns must not be negative");
        }
        this.numRows = n;
        this.numColumns = n2;
        int n3 = n * n2;
        this.probes = new StatProbe[n3];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int rows() {
        return this.numRows;
    }

    public int columns() {
        return this.numColumns;
    }

    public void setRows(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The given number of rows is negative");
        }
        if (this.rows() == n) {
            return;
        }
        StatProbe[] statProbeArray = new StatProbe[n * this.columns()];
        int n2 = Math.min(this.rows(), n);
        System.arraycopy(this.probes, 0, statProbeArray, 0, n2 * this.columns());
        this.probes = statProbeArray;
        this.numRows = n;
        ++this.modCount;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The given number of columns is negative");
        }
        if (this.columns() == n) {
            return;
        }
        StatProbe[] statProbeArray = new StatProbe[this.rows() * n];
        int n2 = Math.min(this.columns(), n);
        for (int i = 0; i < this.rows(); ++i) {
            System.arraycopy(this.probes, this.columns() * i, statProbeArray, n * i, n2);
        }
        this.probes = statProbeArray;
        this.numColumns = n;
        ++this.modCount;
    }

    public E get(int n, int n2) {
        if (n < 0 || n >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + n);
        }
        if (n2 < 0 || n2 >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + n2);
        }
        return this.probes[this.numColumns * n + n2];
    }

    public void set(int n, int n2, E e) {
        if (n < 0 || n >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + n);
        }
        if (n2 < 0 || n2 >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + n2);
        }
        this.probes[this.numColumns * n + n2] = e;
        ++this.modCount;
    }

    public void init() {
        int n = this.rows();
        int n2 = this.columns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ((StatProbe)this.get(i, j)).init();
            }
        }
    }

    public void sum(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                E e = this.get(i, j);
                doubleMatrix2D.setQuick(i, j, e == null ? Double.NaN : ((StatProbe)e).sum());
            }
        }
    }

    public void average(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                E e = this.get(i, j);
                doubleMatrix2D.setQuick(i, j, e == null ? Double.NaN : ((StatProbe)e).average());
            }
        }
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean bl) {
        this.collect = bl;
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean bl) {
        this.broadcast = bl;
    }

    public void addMatrixOfObservationListener(MatrixOfObservationListener matrixOfObservationListener) {
        if (matrixOfObservationListener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(matrixOfObservationListener)) {
            this.listeners.add(matrixOfObservationListener);
        }
    }

    public void removeMatrixOfObservationListener(MatrixOfObservationListener matrixOfObservationListener) {
        this.listeners.remove(matrixOfObservationListener);
    }

    public void clearMatrixOfObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(DoubleMatrix2D doubleMatrix2D) {
        if (!this.broadcast) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            this.listeners.get(i).newMatrixOfObservations(this, doubleMatrix2D);
        }
    }

    public List<E> viewRow(int n) {
        return new MyList(this, ListType.ROW, n);
    }

    public List<E> viewColumn(int n) {
        return new MyList(this, ListType.COLUMN, n);
    }

    public String rowReport(int n) {
        return StatProbe.report(this.getName(), this.viewRow(n));
    }

    public String columnReport(int n) {
        return StatProbe.report(this.getName(), this.viewColumn(n));
    }

    public MatrixOfStatProbes<E> clone() {
        MatrixOfStatProbes matrixOfStatProbes;
        try {
            matrixOfStatProbes = (MatrixOfStatProbes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        if (this.probes != null) {
            matrixOfStatProbes.probes = (StatProbe[])this.probes.clone();
        }
        return matrixOfStatProbes;
    }

    @Override
    public Iterator<E> iterator() {
        return new MyIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyList<E extends StatProbe>
    extends AbstractList<E>
    implements RandomAccess {
        private MatrixOfStatProbes<E> matrix;
        private ListType type;
        private int index;

        public MyList(MatrixOfStatProbes<E> matrixOfStatProbes, ListType listType, int n) {
            this.matrix = matrixOfStatProbes;
            this.type = listType;
            this.index = n;
        }

        @Override
        public E get(int n) {
            if (this.type == ListType.ROW) {
                return this.matrix.get(this.index, n);
            }
            return this.matrix.get(n, this.index);
        }

        @Override
        public int size() {
            if (this.type == ListType.ROW) {
                return ((MatrixOfStatProbes)this.matrix).numColumns;
            }
            return ((MatrixOfStatProbes)this.matrix).numRows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<E> {
        private int index = 0;
        private int expectedModCount = MatrixOfStatProbes.access$000(MatrixOfStatProbes.this);

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            if (MatrixOfStatProbes.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < MatrixOfStatProbes.this.probes.length - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return MatrixOfStatProbes.this.probes[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can not remove an element in a matrix");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListType {
        ROW,
        COLUMN;

    }
}

