/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO.core;

import java.io.Serializable;
import java.util.Enumeration;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.core.UnassignedClassException;
import keel.Algorithms.SVM.SMO.core.UnassignedDatasetException;
import keel.Algorithms.SVM.SMO.core.Utils;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;

public class Instance
implements Serializable {
    static final long serialVersionUID = 1482635194499365122L;
    protected static final double MISSING_VALUE = Double.NaN;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;

    public Instance(Instance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
    }

    public Instance(double weight, double[] attValues) {
        this.m_AttValues = attValues;
        this.m_Weight = weight;
        this.m_Dataset = null;
    }

    public Instance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Double.NaN;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public Attribute attribute(int index) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return Attributes.getAttribute(index);
    }

    public Attribute attributeSparse(int indexOfIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(indexOfIndex);
    }

    public Attribute classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Object copy() {
        Instance result = new Instance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    public Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.m_Dataset);
    }

    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == this.classIndex() || !this.isMissing(i)) continue;
            return true;
        }
        return false;
    }

    public int index(int position) {
        return position;
    }

    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return Double.isNaN(this.m_AttValues[attIndex]);
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Double.isNaN(this.m_AttValues[indexOfIndex]);
    }

    public boolean isMissing(Attribute att) {
        int index = -1;
        for (int i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (att != Attributes.getAttribute(index)) continue;
            index = i;
        }
        return this.isMissing(index);
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public Instance mergeInstance(Instance inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.value(j);
            ++j;
            ++m;
        }
        return new Instance(1.0, newVals);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public int numAttributes() {
        return this.m_AttValues.length;
    }

    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public int numValues() {
        return this.m_AttValues.length;
    }

    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.m_AttValues[i] = array[i];
        }
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setClassValue(String value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Double.NaN);
    }

    public final void setMissing(Attribute att) {
        int index = -1;
        for (int i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (att != Attributes.getAttribute(index)) continue;
            index = i;
        }
        this.setMissing(index);
    }

    public void setValue(int attIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[attIndex] = value;
    }

    public void setValueSparse(int indexOfIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[indexOfIndex] = value;
    }

    public final void setValue(int attIndex, String value) {
        Attribute a = Attributes.getAttribute(attIndex);
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        if (a.getType() != 0) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = -1;
        for (int i = 0; i < a.getNumNominalValues(); ++i) {
            if (a.getNominalValue(i).compareTo(value) != 0) continue;
            valIndex = i;
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(Attribute att, double value) {
        int index = -1;
        for (int i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (att != Attributes.getAttribute(index)) continue;
            index = i;
        }
        this.setValue(index, value);
    }

    public final void setValue(Attribute att, String value) {
        int i;
        int index = -1;
        for (i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (att != Attributes.getAttribute(index)) continue;
            index = i;
        }
        int valIndex = -1;
        for (i = 0; i < att.getNumNominalValues(); ++i) {
            if (att.getNominalValue(i).compareTo(value) != 0) continue;
            valIndex = i;
        }
        this.setValue(index, (double)valIndex);
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final String stringValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(attIndex));
    }

    public final String stringValue(Attribute att) {
        int i;
        int index = -1;
        if (this.m_Dataset != null) {
            for (i = 0; i < this.m_Dataset.numAttributes() && index == -1; ++i) {
                Attribute a = this.m_Dataset.attribute(i);
                if (att != a) continue;
                index = i;
            }
        } else {
            for (i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
                if (att != Attributes.getAttribute(index)) continue;
                index = i;
            }
        }
        int attIndex = index;
        switch (att.getType()) {
            case 0: {
                return att.getNominalValue((int)this.value(attIndex));
            }
        }
        throw new IllegalArgumentException("Attribute isn't nominal, string or date!");
    }

    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, this.m_AttValues.length);
        return newValues;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i));
        }
        return text.toString();
    }

    public final String toString(int attIndex) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(Utils.doubleToString(this.m_AttValues[attIndex], 6));
        } else {
            switch (this.m_Dataset.attribute(attIndex).getType()) {
                case 0: {
                    text.append(Utils.quote(this.stringValue(attIndex)));
                    break;
                }
                case 1: 
                case 2: {
                    text.append(Utils.doubleToString(this.value(attIndex), 6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return text.toString();
    }

    public double value(int attIndex) {
        return this.m_AttValues[attIndex];
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    public double value(Attribute att) {
        int index = -1;
        for (int i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (att != Attributes.getAttribute(index)) continue;
            index = i;
        }
        return this.value(index);
    }

    public final double weight() {
        return this.m_Weight;
    }

    void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        if (position < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, position + 1, newValues, position, this.m_AttValues.length - (position + 1));
        }
        this.m_AttValues = newValues;
    }

    void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.m_AttValues, position, newValues, position + 1, this.m_AttValues.length - position);
        this.m_AttValues = newValues;
    }

    protected Instance() {
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }
}

