/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45_Binarization;

import java.io.IOException;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int REAL = 2;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 0;
    protected double[][] X = null;
    private double[][] X_normalized = null;
    private boolean[][] missing = null;
    private int[] outputInteger = null;
    private double[] outputReal = null;
    private String[] output = null;
    private double[] emax;
    private double[] emin;
    private int nData;
    private int nVars;
    private int nInputs;
    private int nClasses;
    private int[] list_of_classes;
    private InstanceSet IS;
    private Attribute[] inputs_att;
    private Attribute output_att;
    private double[] stdev;
    private double[] average;
    private double[][] stdevPerClass;
    private double[][] averagePerClass;
    private int[] instancesCl;
    private int[] types;
    private String[] classes;
    private String[] variables;
    private String[][] nominals;
    private String[][] nominales_head;

    public myDataset() {
        this.IS = new InstanceSet();
    }

    public myDataset(myDataset copy, int class_1, int class_2) {
        int j;
        int i;
        this.nVars = copy.getnVars();
        this.nInputs = copy.getnInputs();
        this.nClasses = 2;
        this.classes = (String[])copy.classes.clone();
        this.variables = (String[])copy.variables.clone();
        this.types = (int[])copy.types.clone();
        this.nominals = new String[this.nInputs][];
        for (int i2 = 0; i2 < this.nominals.length; ++i2) {
            this.nominals[i2] = (String[])copy.nominals[i2].clone();
        }
        double[][] X_aux = new double[copy.size()][copy.getnInputs()];
        int[] outputInteger_aux = new int[copy.size()];
        String[] output_aux = new String[copy.size()];
        this.nData = 0;
        this.emax = new double[copy.getnInputs()];
        this.emin = new double[copy.getnInputs()];
        for (i = 0; i < this.emax.length; ++i) {
            this.emax[i] = Double.MIN_VALUE;
            this.emin[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < copy.size(); ++i) {
            if (copy.getOutputAsInteger(i) != class_1 && copy.getOutputAsInteger(i) != class_2) continue;
            double[] auxiliar = (double[])copy.getExample(i).clone();
            for (j = 0; j < this.emax.length; ++j) {
                X_aux[this.nData][j] = auxiliar[j];
                if (this.emax[j] < auxiliar[j]) {
                    this.emax[j] = auxiliar[j];
                }
                if (!(this.emin[j] > auxiliar[j])) continue;
                this.emin[j] = auxiliar[j];
            }
            outputInteger_aux[this.nData] = copy.getOutputAsInteger(i);
            output_aux[this.nData] = copy.getOutputAsString(i);
            ++this.nData;
        }
        this.nominales_head = new String[this.nominals.length][];
        for (i = 0; i < this.nominals.length; ++i) {
            if (this.types[i] == 0) {
                int j2;
                boolean[] auxi = new boolean[this.nominals[i].length];
                for (j = 0; j < auxi.length; ++j) {
                    auxi[j] = false;
                }
                for (j = 0; j < this.nData; ++j) {
                    auxi[(int)X_aux[j][i]] = true;
                }
                int contador = 0;
                for (j2 = 0; j2 < auxi.length; ++j2) {
                    if (!auxi[j2]) continue;
                    ++contador;
                }
                this.nominales_head[i] = new String[contador];
                contador = 0;
                for (j2 = 0; j2 < auxi.length; ++j2) {
                    if (!auxi[j2]) continue;
                    this.nominales_head[i][contador++] = this.nominals[i][j2];
                }
                continue;
            }
            this.nominales_head[i] = new String[1];
            this.nominales_head[i][0] = "?";
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = new int[2];
        this.list_of_classes[0] = class_1;
        this.list_of_classes[1] = class_2;
        copy.computeInstancesPerClass();
        this.instancesCl = new int[copy.getnClasses()];
        for (i = 0; i < this.instancesCl.length; ++i) {
            this.instancesCl[i] = copy.numberInstances(i);
        }
    }

    public myDataset(myDataset copia, int positiva) {
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = 2;
        this.classes = (String[])copia.classes.clone();
        this.variables = (String[])copia.variables.clone();
        this.types = (int[])copia.types.clone();
        this.nominals = new String[this.nInputs][];
        for (int i = 0; i < this.nominals.length; ++i) {
            this.nominals[i] = (String[])copia.nominals[i].clone();
        }
        this.nominales_head = (String[][])this.nominals.clone();
        this.emax = (double[])copia.getemax().clone();
        this.emin = (double[])copia.getemin().clone();
        this.nData = copia.size();
        this.X = new double[this.nData][this.nInputs];
        this.X = (double[][])copia.getX().clone();
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        int positivos = 0;
        for (int i = 0; i < this.nData; ++i) {
            this.outputInteger[i] = 1;
            this.output[i] = "negative";
            if (copia.getOutputAsInteger(i) != positiva) continue;
            ++positivos;
            this.outputInteger[i] = 0;
            this.output[i] = "positive";
        }
        this.list_of_classes = new int[2];
        this.list_of_classes[0] = 0;
        this.list_of_classes[1] = 1;
        this.instancesCl = new int[2];
        this.instancesCl[0] = positivos;
        this.instancesCl[1] = this.nData - positivos;
        if (this.instancesCl[1] < 0) {
            this.instancesCl[1] = positivos - this.nData;
        }
        this.classes[0] = "positive";
        this.classes[1] = "negative";
    }

    public myDataset(myDataset copy, int class_1, int class_2, int[] ties) {
        int i;
        this.nVars = copy.getnVars();
        this.nInputs = copy.getnInputs();
        this.nClasses = copy.getnClasses();
        double[][] X_aux = new double[copy.size()][copy.getnInputs()];
        int[] outputInteger_aux = new int[copy.size()];
        String[] output_aux = new String[copy.size()];
        this.nData = 0;
        for (i = 0; i < copy.size(); ++i) {
            if (copy.getOutputAsInteger(i) != class_1 && copy.getOutputAsInteger(i) != class_2 || ties[i] != 1) continue;
            X_aux[this.nData] = (double[])copy.getExample(i).clone();
            outputInteger_aux[this.nData] = copy.getOutputAsInteger(i);
            output_aux[this.nData] = copy.getOutputAsString(i);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = new int[2];
        this.list_of_classes[0] = class_1;
        this.list_of_classes[1] = class_2;
        copy.computeInstancesPerClass();
        this.instancesCl = new int[copy.getnClasses()];
        for (i = 0; i < this.instancesCl.length; ++i) {
            this.instancesCl[i] = copy.numberInstances(i);
        }
    }

    public double[][] getX() {
        return this.X;
    }

    public double[] getExample(int pos) {
        return this.X[pos];
    }

    public int[] getOutputAsInteger() {
        int[] output = new int[this.outputInteger.length];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public double[] getOutputAsReal() {
        double[] output = new double[this.outputReal.length];
        for (int i = 0; i < this.outputReal.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public String[] getOutputAsString() {
        String[] output = new String[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            output[i] = this.output[i];
        }
        return output;
    }

    public String getOutputAsString(int pos) {
        return this.output[pos];
    }

    public int getOutputAsInteger(int pos) {
        return this.outputInteger[pos];
    }

    public double getOutputAsReal(int pos) {
        return this.outputReal[pos];
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnData() {
        return this.nData;
    }

    public int getnVars() {
        return this.nVars;
    }

    public int getnInputs() {
        return this.nInputs;
    }

    public int getnClasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        int i;
        try {
            this.IS = new InstanceSet();
            this.IS.readSet(datasetFile, train);
            this.IS.setAttributesAsNonStatic();
            this.inputs_att = this.IS.getAttributeDefinitions().getInputAttributes();
            this.output_att = this.IS.getAttributeDefinitions().getOutputAttribute(0);
            this.nData = this.IS.getNumInstances();
            this.nInputs = this.IS.getAttributeDefinitions().getInputNumAttributes();
            this.nVars = this.nInputs + this.IS.getAttributeDefinitions().getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (int i2 = 0; i2 < this.nInputs; ++i2) {
                this.emax[i2] = Attributes.getAttribute(i2).getMaxAttribute();
                this.emin[i2] = Attributes.getAttribute(i2).getMinAttribute();
            }
            this.nClasses = 0;
            int aux = 0;
            int datos = 0;
            int datosMal = 0;
            for (int i3 = 0; i3 < this.nData; ++i3) {
                Instance inst = this.IS.getInstance(i3);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[datos][j] = this.IS.getInputNumericValue(i3, j);
                    this.missing[i3][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i3][j]) continue;
                    j = this.nInputs;
                    ++datosMal;
                }
                if (noOutputs) {
                    this.outputInteger[datos] = 0;
                    this.output[datos] = "";
                } else {
                    this.outputInteger[datos] = (int)this.IS.getOutputNumericValue(i3, 0);
                    this.output[datos] = this.IS.getOutputNominalValue(i3, 0);
                }
                if (this.outputInteger[datos] > this.nClasses) {
                    this.nClasses = this.outputInteger[datos];
                }
                ++datos;
                if (datosMal <= aux) continue;
                --datos;
                aux = datosMal;
            }
            this.nData -= datosMal;
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.list_of_classes = new int[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            this.list_of_classes[i] = i;
        }
        this.computeStatistics();
        this.computeInstancesPerClass();
        this.variables = new String[this.nVars];
        this.classes = new String[this.nClasses];
        this.types = new int[this.nInputs];
        this.nominals = new String[this.nInputs][];
        this.nominales_head = new String[this.nInputs][];
        for (i = 0; i < this.nInputs; ++i) {
            this.variables[i] = this.inputs_att[i].getName();
            this.types[i] = this.inputs_att[i].getType();
            if (this.inputs_att[i].getNumNominalValues() > 0) {
                this.nominals[i] = new String[this.inputs_att[i].getNumNominalValues()];
                this.nominales_head[i] = new String[this.inputs_att[i].getNumNominalValues()];
                for (int j = 0; j < this.nominals[i].length; ++j) {
                    this.nominals[i][j] = this.inputs_att[i].getNominalValue(j);
                    this.nominales_head[i][j] = this.inputs_att[i].getNominalValue(j);
                }
                continue;
            }
            this.nominals[i] = new String[1];
            this.nominals[i][0] = "?";
            this.nominales_head[i] = new String[1];
            this.nominales_head[i][0] = "?";
        }
        this.variables[this.nInputs] = this.output_att.getName();
        for (i = 0; i < this.nClasses; ++i) {
            this.classes[i] = this.output_att.getNominalValue(i);
        }
    }

    public void normalize() {
        int atts = this.getnInputs();
        double[] maxs = new double[atts];
        for (int j = 0; j < atts; ++j) {
            maxs[j] = Attributes.getAttribute(j).getType() == 0 ? 1.0 / (double)(Attributes.getAttribute(j).getNumNominalValues() - 1 - 0) : 1.0 / (this.emax[j] - this.emin[j]);
        }
        for (int i = 0; i < this.getnData(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X[i][j] = Attributes.getAttribute(j).getType() == 0 ? (this.X[i][j] - 0.0) * maxs[j] : (this.X[i][j] - this.emin[j]) * maxs[j];
            }
        }
    }

    public void normalize_statistics() {
        int atts = this.getnInputs();
        double[] maxs = new double[atts];
        this.X_normalized = new double[this.nData][this.nInputs];
        for (int j = 0; j < atts; ++j) {
            maxs[j] = Attributes.getAttribute(j).getType() == 0 ? 1.0 / (double)(Attributes.getAttribute(j).getNumNominalValues() - 1 - 0) : 1.0 / (this.emax[j] - this.emin[j]);
        }
        for (int i = 0; i < this.getnData(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X_normalized[i][j] = Attributes.getAttribute(j).getType() == 0 ? (this.X[i][j] - 0.0) * maxs[j] : (this.X[i][j] - this.emin[j]) * maxs[j];
            }
        }
    }

    public void computeStatisticsPerClass() {
        int c;
        int i;
        this.normalize_statistics();
        this.stdevPerClass = new double[this.nClasses][this.getnInputs()];
        this.averagePerClass = new double[this.nClasses][this.getnInputs()];
        for (i = 0; i < this.getnInputs(); ++i) {
            int j;
            for (j = 0; j < this.getnClasses(); ++j) {
                this.averagePerClass[j][i] = 0.0;
            }
            for (j = 0; j < this.getnData(); ++j) {
                c = this.outputInteger[j];
                if (this.isMissing(j, i)) continue;
                double[] dArray = this.averagePerClass[c];
                int n = i;
                dArray[n] = dArray[n] + this.X_normalized[j][i];
            }
            for (j = 0; j < this.getnClasses(); ++j) {
                double[] dArray = this.averagePerClass[j];
                int n = i;
                dArray[n] = dArray[n] / (double)this.numberOfExamples(j);
                if (!Double.isNaN(this.averagePerClass[j][i])) continue;
                this.averagePerClass[j][i] = this.average(i);
            }
        }
        for (i = 0; i < this.getnInputs(); ++i) {
            int j;
            double[] sum = new double[this.nClasses];
            for (j = 0; j < this.getnClasses(); ++j) {
                sum[j] = 0.0;
            }
            for (j = 0; j < this.getnData(); ++j) {
                c = this.outputInteger[j];
                if (this.isMissing(j, i)) continue;
                int n = c;
                sum[n] = sum[n] + (this.X_normalized[j][i] - this.averagePerClass[c][i]) * (this.X_normalized[j][i] - this.averagePerClass[c][i]);
            }
            for (j = 0; j < this.getnClasses(); ++j) {
                int n = j;
                sum[n] = sum[n] / (double)this.numberOfExamples(j);
                this.stdevPerClass[j][i] = Math.sqrt(sum[j]);
            }
        }
    }

    public double[][] getAveragePerClass() {
        return this.averagePerClass;
    }

    public double[][] getStdPerClass() {
        return this.stdevPerClass;
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnData();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nData; ++i) {
            int j;
            for (j = 1; j < this.nInputs && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nInputs) continue;
            ++tam;
        }
        return tam;
    }

    public int size() {
        return this.nData;
    }

    private void computeStatistics() {
        this.stdev = new double[this.getnVars()];
        this.average = new double[this.getnVars()];
        int i = 0;
        while (i < this.getnInputs()) {
            this.average[i] = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                int n = i;
                this.average[n] = this.average[n] + this.X[j][i];
            }
            int n = i++;
            this.average[n] = this.average[n] / (double)this.getnData();
        }
        this.average[this.average.length - 1] = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            int n = this.average.length - 1;
            this.average[n] = this.average[n] + this.outputReal[j];
        }
        int n = this.average.length - 1;
        this.average[n] = this.average[n] / (double)this.outputReal.length;
        for (i = 0; i < this.getnInputs(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                sum += (this.X[j][i] - this.average[i]) * (this.X[j][i] - this.average[i]);
            }
            this.stdev[i] = Math.sqrt(sum /= (double)this.getnData());
        }
        double sum = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            sum += (this.outputReal[j] - this.average[this.average.length - 1]) * (this.outputReal[j] - this.average[this.average.length - 1]);
        }
        this.stdev[this.stdev.length - 1] = Math.sqrt(sum /= (double)this.outputReal.length);
    }

    public double stdDev(int position) {
        return this.stdev[position];
    }

    public double average(int position) {
        return this.average[position];
    }

    public void computeInstancesPerClass() {
        this.instancesCl = new int[this.nClasses];
        for (int i = 0; i < this.getnData(); ++i) {
            int n = this.outputInteger[i];
            this.instancesCl[n] = this.instancesCl[n] + 1;
        }
    }

    public int numberInstances(int clas) {
        return this.instancesCl[clas];
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String getOutputValue(int intValue) {
        return this.classes[intValue];
    }

    public int getTipo(int variable) {
        return this.types[variable];
    }

    public double[][] getRanges() {
        double[][] rangos = new double[this.getnVars()][2];
        for (int i = 0; i < this.getnInputs(); ++i) {
            rangos[i][0] = this.emin[i];
            rangos[i][1] = this.emax[i];
        }
        rangos[this.getnVars() - 1][0] = 0.0;
        rangos[this.getnVars() - 1][1] = this.nClasses - 1;
        return rangos;
    }

    public String varName(int pos) {
        return Attributes.getInputAttribute(pos).getName();
    }

    public String className(int clase) {
        return this.classes[clase];
    }

    public void discretize(int intervalos) {
        for (int i = 0; i < this.nInputs; ++i) {
            if (this.getTipo(i) != 2) continue;
            double corte = (this.emax[i] - this.emin[i]) / (double)intervalos;
            for (int j = 0; j < this.size(); ++j) {
                double acum = this.emin[i] + corte;
                boolean salir = false;
                for (int k = 0; k < intervalos && !salir; ++k) {
                    if (this.X[j][i] < acum) {
                        this.X[j][i] = k;
                        salir = true;
                    }
                    acum += corte;
                }
            }
        }
    }

    public String[] names() {
        String[] nombres = new String[this.nInputs];
        for (int i = 0; i < this.nInputs; ++i) {
            nombres[i] = Attributes.getInputAttribute(i).getName();
        }
        return nombres;
    }

    public static double realValue(int atributo, String valorNominal) {
        Vector nominales = Attributes.getInputAttribute(atributo).getNominalValuesList();
        int aux = nominales.indexOf(valorNominal);
        return 1.0 * (double)aux;
    }

    public int numericClass(String valorNominal) {
        Vector nominales = Attributes.getOutputAttribute(0).getNominalValuesList();
        int aux = nominales.indexOf(valorNominal);
        return aux;
    }

    public static String nominalValue(int atributo, double valorReal) {
        Vector nominales = Attributes.getInputAttribute(atributo).getNominalValuesList();
        return (String)nominales.get((int)valorReal);
    }

    public int totalNominals(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String mostFrequentClass() {
        int claseMayoritaria = 0;
        for (int i = 1; i < this.nClasses; ++i) {
            if (this.instancesCl[claseMayoritaria] >= this.instancesCl[i]) continue;
            claseMayoritaria = i;
        }
        return this.getOutputValue(claseMayoritaria);
    }

    public int n_minoritaria() {
        if (this.numberInstances(this.list_of_classes[0]) > this.numberInstances(this.list_of_classes[1])) {
            return this.numberInstances(this.list_of_classes[1]);
        }
        return this.numberInstances(this.list_of_classes[0]);
    }

    public double ir() {
        if (this.numberInstances(this.list_of_classes[0]) > this.numberInstances(this.list_of_classes[1])) {
            return (double)this.numberInstances(this.list_of_classes[0]) / (double)this.numberInstances(this.list_of_classes[1]);
        }
        return (double)this.numberInstances(this.list_of_classes[1]) / (double)this.numberInstances(this.list_of_classes[0]);
    }

    public int numberOfExamples(int clase) {
        int ejemplos = 0;
        for (int i = 0; i < this.outputInteger.length; ++i) {
            if (clase != this.outputInteger[i]) continue;
            ++ejemplos;
        }
        return ejemplos;
    }

    public boolean empty() {
        return this.numberInstances(this.list_of_classes[0]) == 0 || this.numberInstances(this.list_of_classes[1]) == 0;
    }

    public String doHeader() {
        int i;
        String cadena = new String("");
        cadena = cadena + "@relation unknown\n";
        for (i = 0; i < this.nInputs; ++i) {
            int j;
            cadena = cadena + "@attribute " + this.variables[i];
            if (this.types[i] == 1) {
                cadena = cadena + " integer [" + (int)this.emin[i] + "," + (int)this.emax[i] + "]\n";
                continue;
            }
            if (this.types[i] == 2) {
                cadena = cadena + " real [" + this.emin[i] + "," + this.emax[i] + "]\n";
                continue;
            }
            cadena = cadena + " {";
            for (j = 0; j < this.nominales_head[i].length - 1; ++j) {
                cadena = cadena + this.nominales_head[i][j] + ",";
            }
            cadena = cadena + this.nominales_head[i][j] + "}\n";
        }
        cadena = cadena + "@attribute " + this.variables[this.nInputs];
        cadena = cadena + " {";
        for (i = 0; i < this.nClasses - 1; ++i) {
            cadena = cadena + this.classes[this.list_of_classes[i]] + ", ";
        }
        cadena = cadena + this.classes[this.list_of_classes[i]] + "}\n";
        cadena = cadena + "@data\n";
        return cadena;
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public String printDataSet(boolean ova) {
        String cadena = new String("");
        cadena = cadena + this.doHeader();
        if (ova) {
            Attributes.clearAll();
        }
        for (int i = 0; i < this.size(); ++i) {
            double[] ejemplo = this.getExample(i);
            for (int j = 0; j < this.getnInputs(); ++j) {
                if (this.getTipo(j) == 0) {
                    cadena = cadena + this.nominals[j][(int)ejemplo[j]] + ", ";
                    continue;
                }
                cadena = this.getTipo(j) == 1 ? cadena + (int)ejemplo[j] + ", " : cadena + ejemplo[j] + ", ";
            }
            cadena = cadena + this.getOutputAsString(i) + "\n";
        }
        return cadena;
    }
}

