/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.fitness;

import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.fitness.CompositeFitness;
import net.sourceforge.jclec.fitness.ISimpleFitness;
import net.sourceforge.jclec.fitness.IValueFitness;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CompositeValueFitness
extends CompositeFitness
implements IValueFitness {
    private static final long serialVersionUID = 3258690996551104821L;
    protected double value;

    public CompositeValueFitness() {
    }

    public CompositeValueFitness(ISimpleFitness[] components) {
        super(components);
    }

    public CompositeValueFitness(ISimpleFitness[] components, double value) {
        super(components);
        this.setValue(value);
    }

    @Override
    public final double getValue() {
        return this.value;
    }

    @Override
    public final void setValue(double value) {
        this.value = value;
    }

    @Override
    public IFitness copy() {
        int cl = this.components.length;
        ISimpleFitness[] comps = new ISimpleFitness[cl];
        int i = 0;
        while (i < cl) {
            comps[i] = (ISimpleFitness)this.components[i].copy();
            ++i;
        }
        double val = this.value;
        return new CompositeValueFitness(comps, val);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.appendSuper(super.hashCode());
        hcb.append(this.value);
        return hcb.toHashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (oth instanceof CompositeValueFitness) {
            CompositeValueFitness coth = (CompositeValueFitness)oth;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(coth));
            eb.append(this.value, coth.value);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.appendSuper(super.toString());
        tsb.append("value", this.value);
        return tsb.toString();
    }
}

