/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax;

import java.util.Comparator;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ClassificationProblemEvaluator;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ISoftmaxClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.errorfunctions.IErrorFunction;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IFitness;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.fitness.SimpleValueFitness;
import net.sf.jclec.fitness.ValueFitnessComparator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class SoftmaxClassificationProblemEvaluator
extends ClassificationProblemEvaluator
implements IConfigure {
    private static final long serialVersionUID = 5628503640645851126L;
    IErrorFunction<double[][]> defaultErrorFunction;
    protected Comparator<IFitness> comparator = new ValueFitnessComparator(false);

    public IErrorFunction<double[][]> getErrorFunction() {
        return this.defaultErrorFunction;
    }

    public void setErrorFunction(IErrorFunction<double[][]> errorFunction) {
        this.defaultErrorFunction = errorFunction;
    }

    @Override
    public Comparator<IFitness> getComparator() {
        return this.comparator;
    }

    @Override
    public void evaluate(AbstractIndividual<? extends ISoftmaxClassifier> ind) {
        DoubleTransposedDataSet dataset = this.dataNormalized ? this.scaledTrainData : this.unscaledTrainData;
        double[][] obtained = ind.getGenotype().rawOutputs(dataset.getAllInputs());
        double error = this.defaultErrorFunction.calculateError(obtained, dataset.getAllOutputs());
        ind.setFitness(new SimpleValueFitness(1.0 / (1.0 + error)));
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        try {
            String errorFunctionClassname = settings.getString("error-function");
            Class<?> errorFunctionClass = Class.forName(errorFunctionClassname);
            IErrorFunction errorFunction = (IErrorFunction)errorFunctionClass.newInstance();
            this.setErrorFunction(errorFunction);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal error function classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of error function", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of error function", e);
        }
    }
}

