/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.jclec.IEvaluator;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.IToolTest;
import net.sourceforge.jclec.Population;
import net.sourceforge.jclec.binarray.BinArrayIndividual;
import net.sourceforge.jclec.binarray.BinArrayIndividualSpecies;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.fitness.ValueFitnessComparator;
import net.sourceforge.jclec.util.random.DummyRandGenFactory;

public abstract class ISelectorTest<S extends ISelector>
extends IToolTest<S> {
    protected List<IIndividual> source;
    protected List<IIndividual> expected;

    public ISelectorTest(Class<S> toolClass, String testName) {
        super(toolClass, testName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createSource();
        this.createExpected();
    }

    public void testSelect() {
        List<IIndividual> result = ((ISelector)this.tool).select(this.source, 1);
        ISelectorTest.assertEquals((int)this.expected.size(), (int)result.size());
        int es = this.expected.size();
        int i = 0;
        while (i < es) {
            ISelectorTest.assertEquals((Object)this.expected.get(i), (Object)result.get(i));
            ++i;
        }
    }

    @Override
    protected ISystem createContext() {
        Population pop = new Population();
        DummyRandGenFactory randGenFactory = new DummyRandGenFactory();
        randGenFactory.setDummySequence(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        pop.setRandGenFactory(randGenFactory);
        pop.setSpecies(new BinArrayIndividualSpecies(new byte[]{1, -1, -1, -1}));
        pop.setEvaluator(new IEvaluator(){
            private static final long serialVersionUID = -3469432539611803519L;
            final ValueFitnessComparator comparator = new ValueFitnessComparator();

            @Override
            public void evaluate(List<IIndividual> inds) {
            }

            @Override
            public int getNumberOfEvaluations() {
                return 0;
            }

            @Override
            public Comparator<IFitness> getComparator() {
                return this.comparator;
            }
        });
        return pop;
    }

    protected void createSource() {
        this.source = new ArrayList<IIndividual>();
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[3] = 1;
        this.source.add(new BinArrayIndividual(byArray, (IFitness)new SimpleValueFitness(0.25)));
        byte[] byArray2 = new byte[4];
        byArray2[0] = 1;
        byArray2[1] = 1;
        byArray2[3] = 1;
        this.source.add(new BinArrayIndividual(byArray2, (IFitness)new SimpleValueFitness(0.52)));
        byte[] byArray3 = new byte[4];
        byArray3[0] = 1;
        byArray3[2] = 1;
        byArray3[3] = 1;
        this.source.add(new BinArrayIndividual(byArray3, (IFitness)new SimpleValueFitness(0.15)));
        this.source.add(new BinArrayIndividual(new byte[]{1, 1, 1, 1}, (IFitness)new SimpleValueFitness(0.35)));
        byte[] byArray4 = new byte[4];
        byArray4[3] = 1;
        this.source.add(new BinArrayIndividual(byArray4, (IFitness)new SimpleValueFitness(0.95)));
        byte[] byArray5 = new byte[4];
        byArray5[1] = 1;
        byArray5[3] = 1;
        this.source.add(new BinArrayIndividual(byArray5, (IFitness)new SimpleValueFitness(0.75)));
        byte[] byArray6 = new byte[4];
        byArray6[0] = 1;
        byArray6[3] = 1;
        this.source.add(new BinArrayIndividual(byArray6, (IFitness)new SimpleValueFitness(0.65)));
        byte[] byArray7 = new byte[4];
        byArray7[0] = 1;
        this.source.add(new BinArrayIndividual(byArray7, (IFitness)new SimpleValueFitness(0.05)));
        this.source.add(new BinArrayIndividual(new byte[]{1, 1, 1, 1}, (IFitness)new SimpleValueFitness(0.25)));
        this.source.add(new BinArrayIndividual(new byte[4], (IFitness)new SimpleValueFitness(0.45)));
    }

    protected abstract void createExpected();
}

