/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import keel.Algorithms.SVM.SMO.core.FastVector;
import keel.Algorithms.SVM.SMO.core.Instance;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.core.SelectedTag;
import keel.Algorithms.SVM.SMO.core.Tag;
import keel.Algorithms.SVM.SMO.core.TechnicalInformation;
import keel.Algorithms.SVM.SMO.core.TechnicalInformationHandler;
import keel.Algorithms.SVM.SMO.core.Utils;
import keel.Algorithms.SVM.SMO.core.WeightedInstancesHandler;
import keel.Algorithms.SVM.SMO.supportVector.Kernel;
import keel.Algorithms.SVM.SMO.supportVector.NormalizedPolyKernel;
import keel.Algorithms.SVM.SMO.supportVector.PolyKernel;
import keel.Algorithms.SVM.SMO.supportVector.Puk;
import keel.Algorithms.SVM.SMO.supportVector.RBFKernel;
import keel.Algorithms.SVM.SMO.supportVector.SMOset;
import keel.Algorithms.SVM.SMO.supportVector.StringKernel;
import keel.Algorithms.Statistical_Classifiers.Logistic.Logistic;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceSet;
import org.core.Files;
import org.core.Randomize;

public class SMO
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6585883636378691736L;
    public double[][] probabilities = null;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected BinarySMO[][] m_classifiers = null;
    protected double m_C = 1.0;
    protected double m_eps = 1.0E-12;
    protected double m_tol = 0.001;
    protected int m_filterType = 0;
    protected int m_classIndex = -1;
    protected Attribute m_classAttribute;
    protected boolean m_KernelIsLinear = false;
    protected boolean m_checksTurnedOff;
    protected static double m_Del = 4.94E-321;
    protected boolean m_fitLogisticModels = false;
    protected int m_numFolds = -1;
    protected int m_randomSeed = 1;
    protected Kernel m_kernel = new PolyKernel();
    protected int m_NumClasses;
    protected int m_seed;
    protected boolean m_nominalToBinary = true;
    protected String input_train_name = new String();
    protected String input_validation_name;
    protected String input_test_name = new String();
    protected String output_train_name = new String();
    protected String output_test_name = new String();
    protected String method_output = new String();
    protected double[] mean = null;
    protected double[] std_dev = null;

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification (1-vs-1 and if logistic models are built pairwise coupling according to Hastie and Tibshirani, 1998).\n\nTo obtain proper probability estimates, use the option that fits logistic regression models to the outputs of the support vector machine. In the multi-class case the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Platt");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Machines using Sequential Minimal Optimization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Kernel Methods - Support Vector Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "B. Schoelkopf and C. Burges and A. Smola");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        result.setValue(TechnicalInformation.Field.URL, "http://research.microsoft.com/~jplatt/smo.html");
        result.setValue(TechnicalInformation.Field.PDF, "http://research.microsoft.com/~jplatt/smo-book.pdf");
        result.setValue(TechnicalInformation.Field.PS, "http://research.microsoft.com/~jplatt/smo-book.ps.gz");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S.S. Keerthi and S.K. Shevade and C. Bhattacharyya and K.R.K. Murthy");
        additional.setValue(TechnicalInformation.Field.YEAR, "2001");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improvements to Platt's SMO Algorithm for SVM Classifier Design");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Computation");
        additional.setValue(TechnicalInformation.Field.VOLUME, "13");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "637-649");
        additional.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/smo_mod_nc.ps.gz");
        additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Trevor Hastie and Robert Tibshirani");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "Classification by Pairwise Coupling");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Neural Information Processing Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "10");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Michael I. Jordan and Michael J. Kearns and Sara A. Solla");
        additional.setValue(TechnicalInformation.Field.PS, "http://www-stat.stanford.edu/~hastie/Papers/2class.ps");
        return result;
    }

    public SMO(String fileParam) {
        this.config_read(fileParam);
        Randomize.setSeed(this.m_seed);
    }

    public SMO() {
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public void buildClassifier(Instances insts) throws Exception {
        int i;
        this.m_classIndex = insts.classIndex();
        this.m_classAttribute = insts.classAttribute();
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        this.m_NumClasses = insts.numClasses();
        Instances[] subsets = new Instances[insts.numClasses()];
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i] = new Instances(insts, insts.numInstances());
        }
        for (int j = 0; j < insts.numInstances(); ++j) {
            Instance inst = insts.instance(j);
            subsets[(int)inst.classValue()].add(inst);
        }
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i].compactify();
        }
        this.m_classifiers = new BinarySMO[insts.numClasses()][insts.numClasses()];
        for (i = 0; i < insts.numClasses(); ++i) {
            for (int j = i + 1; j < insts.numClasses(); ++j) {
                int k;
                this.m_classifiers[i][j] = new BinarySMO();
                this.m_classifiers[i][j].setKernel(Kernel.makeCopy(this.getKernel()));
                Instances data = new Instances(insts, insts.numInstances());
                for (k = 0; k < subsets[i].numInstances(); ++k) {
                    data.add(subsets[i].instance(k));
                }
                for (k = 0; k < subsets[j].numInstances(); ++k) {
                    data.add(subsets[j].instance(k));
                }
                data.compactify();
                data.randomize();
                this.m_classifiers[i][j].buildClassifier(data, i, j, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    public double[] distributionForInstance(Instance inst) throws Exception {
        if (!this.m_fitLogisticModels) {
            double[] result = new double[inst.numClasses()];
            for (int i = 0; i < inst.numClasses(); ++i) {
                for (int j = i + 1; j < inst.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double output = this.m_classifiers[i][j].SVMOutput(-1, inst);
                    if (output > 0.0) {
                        int n = j;
                        result[n] = result[n] + 1.0;
                        continue;
                    }
                    int n = i;
                    result[n] = result[n] + 1.0;
                }
            }
            Utils.normalize(result);
            return result;
        }
        if (inst.numClasses() == 2) {
            double[] newInst = new double[]{this.m_classifiers[0][1].SVMOutput(-1, inst), Instance.missingValue()};
            return this.m_classifiers[0][1].m_logistic.distributionForInstance(newInst);
        }
        double[][] r = new double[inst.numClasses()][inst.numClasses()];
        double[][] n = new double[inst.numClasses()][inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            for (int j = i + 1; j < inst.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] newInst = new double[]{this.m_classifiers[i][j].SVMOutput(-1, inst), Instance.missingValue()};
                r[i][j] = this.m_classifiers[i][j].m_logistic.distributionForInstance(newInst)[0];
                n[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return this.pairwiseCoupling(n, r);
    }

    public double[] pairwiseCoupling(double[][] n, double[][] r) {
        boolean changed;
        double[] p = new double[r.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = 1.0 / (double)p.length;
        }
        double[][] u = new double[r.length][r.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = i + 1; j < r.length; ++j) {
                u[i][j] = 0.5;
            }
        }
        double[] firstSum = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                int n2 = i;
                firstSum[n2] = firstSum[n2] + n[i][j] * r[i][j];
                int n3 = j;
                firstSum[n3] = firstSum[n3] + n[i][j] * (1.0 - r[i][j]);
            }
        }
        do {
            int i;
            changed = false;
            double[] secondSum = new double[p.length];
            for (i = 0; i < p.length; ++i) {
                for (int j = i + 1; j < p.length; ++j) {
                    int n4 = i;
                    secondSum[n4] = secondSum[n4] + n[i][j] * u[i][j];
                    int n5 = j;
                    secondSum[n5] = secondSum[n5] + n[i][j] * (1.0 - u[i][j]);
                }
            }
            for (i = 0; i < p.length; ++i) {
                if (firstSum[i] == 0.0 || secondSum[i] == 0.0) {
                    if (p[i] > 0.0) {
                        changed = true;
                    }
                    p[i] = 0.0;
                    continue;
                }
                double factor = firstSum[i] / secondSum[i];
                double pOld = p[i];
                int n6 = i;
                p[n6] = p[n6] * factor;
                if (!(Math.abs(pOld - p[i]) > 0.001)) continue;
                changed = true;
            }
            Utils.normalize(p);
            for (i = 0; i < r.length; ++i) {
                for (int j = i + 1; j < r.length; ++j) {
                    u[i][j] = p[i] / (p[i] + p[j]);
                }
            }
        } while (changed);
        return p;
    }

    public int[] obtainVotes(Instance inst) throws Exception {
        int[] votes = new int[inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            for (int j = i + 1; j < inst.numClasses(); ++j) {
                double output = this.m_classifiers[i][j].SVMOutput(-1, inst);
                if (output > 0.0) {
                    int n = j;
                    votes[n] = votes[n] + 1;
                    continue;
                }
                int n = i;
                votes[n] = votes[n] + 1;
            }
        }
        return votes;
    }

    public double[][][] sparseWeights() {
        int numValues = this.m_classAttribute.getNumNominalValues();
        double[][][] sparseWeights = new double[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseWeights[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return sparseWeights;
    }

    public int[][][] sparseIndices() {
        int numValues = this.m_classAttribute.getNumNominalValues();
        int[][][] sparseIndices = new int[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseIndices[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return sparseIndices;
    }

    public double[][] bias() {
        int numValues = this.m_classAttribute.getNumNominalValues();
        double[][] bias = new double[numValues][numValues];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                bias[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return bias;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.getNumNominalValues();
    }

    public String[] classAttributeNames() {
        int numValues = this.m_classAttribute.getNumNominalValues();
        String[] classAttributeNames = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            classAttributeNames[i] = this.m_classAttribute.getNominalValue(i);
        }
        return classAttributeNames;
    }

    public String[][][] attributeNames() {
        int numValues = this.m_classAttribute.getNumNominalValues();
        String[][][] attributeNames = new String[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                int numAttributes = this.m_classifiers[i][j].m_data.numAttributes();
                String[] attrNames = new String[numAttributes];
                for (int k = 0; k < numAttributes; ++k) {
                    attrNames[k] = this.m_classifiers[i][j].m_data.attribute(k).getName();
                }
                attributeNames[i][j] = attrNames;
            }
        }
        return attributeNames;
    }

    public void setChecksTurnedOff(boolean value) {
        if (value) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double v) {
        this.m_C = v;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double v) {
        this.m_tol = v;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double v) {
        this.m_eps = v;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String buildLogisticModelsTipText() {
        return "Whether to fit logistic models to the outputs (for proper probability estimates).";
    }

    public boolean getBuildLogisticModels() {
        return this.m_fitLogisticModels;
    }

    public void setBuildLogisticModels(boolean newbuildLogisticModels) {
        this.m_fitLogisticModels = newbuildLogisticModels;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for logistic models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int newnumFolds) {
        this.m_numFolds = newnumFolds;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int newrandomSeed) {
        this.m_randomSeed = newrandomSeed;
    }

    public void runModel() {
        int j;
        int claseObt;
        double[] dist;
        Instance instWeka;
        keel.Dataset.Instance inst;
        int i;
        String[] instanciasOUT;
        String[] instanciasIN;
        int tipo;
        Attribute a;
        Instances isWeka;
        InstanceSet IS = new InstanceSet();
        InstanceSet ISval = new InstanceSet();
        try {
            IS.readSet(this.input_train_name, true);
            if (this.m_filterType == 1) {
                this.computeStats(IS);
            }
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            this.buildClassifier(isWeka);
            ISval.readSet(this.input_validation_name, false);
            isWeka = this.InstancesKEEL2Weka(ISval, this.m_filterType, this.m_nominalToBinary);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[ISval.getNumInstances()];
            instanciasOUT = new String[ISval.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = ISval.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            SMO.writeOutput(this.output_train_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error building the SMO model!");
            ex.printStackTrace();
        }
        try {
            IS.readSet(this.input_test_name, false);
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[IS.getNumInstances()];
            instanciasOUT = new String[IS.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = IS.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            SMO.writeOutput(this.output_test_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error performing test by the SMO model!");
            ex.printStackTrace();
        }
        this.printSVs();
    }

    public void runModel(InstanceSet train, InstanceSet test) {
        int j;
        int claseObt;
        double[] dist;
        Instance instWeka;
        keel.Dataset.Instance inst;
        int i;
        String[] instanciasOUT;
        String[] instanciasIN;
        int tipo;
        Attribute a;
        Instances isWeka;
        InstanceSet IS = new InstanceSet();
        InstanceSet ISval = new InstanceSet();
        try {
            IS = train;
            if (this.m_filterType == 1) {
                this.computeStats(IS);
            }
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            this.buildClassifier(isWeka);
            ISval = new InstanceSet(train);
            isWeka = this.InstancesKEEL2Weka(ISval, this.m_filterType, this.m_nominalToBinary);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[ISval.getNumInstances()];
            instanciasOUT = new String[ISval.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = ISval.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            SMO.writeOutput(this.output_train_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error building the SMO model!");
            ex.printStackTrace();
        }
        try {
            IS = new InstanceSet(test);
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            this.probabilities = new double[test.getInstances().length][this.m_NumClasses];
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[IS.getNumInstances()];
            instanciasOUT = new String[IS.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = IS.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                this.probabilities[i] = dist;
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            SMO.writeOutput(this.output_test_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error performing test by the SMO model!");
            ex.printStackTrace();
        }
        this.printSVs();
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            boolean normalize;
            boolean useLowerOrder;
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_validation_name = new String(out[1].substring(0, out[1].length() - 1));
            this.input_test_name = new String(out[2].substring(0, out[2].length() - 1));
            if (this.input_validation_name.charAt(this.input_validation_name.length() - 1) == '\"') {
                this.input_validation_name = this.input_validation_name.substring(0, this.input_validation_name.length() - 1);
            }
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            this.method_output = new String(out[2].substring(0, out[2].length() - 1));
            this.method_output = this.method_output.trim();
            if (this.method_output.charAt(this.method_output.length() - 1) == '\"') {
                this.method_output = this.method_output.substring(0, this.method_output.length() - 1);
            }
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("seed = ");
            this.m_seed = new Integer(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("C = ");
            this.m_C = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("toleranceParameter = ");
            this.m_tol = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("epsilon = ");
            this.m_eps = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("RBFKernel_gamma = ");
            double gamma = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("-Normalized-PolyKernel_exponent = ");
            double exponent = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("-Normalized-PolyKernel_useLowerOrder = ");
            boolean bl = useLowerOrder = new String(out[1]).compareTo("True") == 0;
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("PukKernel_omega = ");
            double omega = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("PukKernel_sigma = ");
            double sigma = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("StringKernel_lambda = ");
            double lambda = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("StringKernel_subsequenceLength = ");
            int subsequenceLength = new Integer(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("StringKernel_maxSubsequenceLength = ");
            int maxSubsequenceLength = new Integer(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("StringKernel_normalize = ");
            boolean bl2 = normalize = new String(out[1]).compareTo("True") == 0;
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("StringKernel_pruning = ");
            String pruning = new String(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("KERNELtype = ");
            String kernelType = new String(out[1]);
            if (kernelType.compareTo("RBFKernel") == 0) {
                this.m_kernel = new RBFKernel();
                ((RBFKernel)this.m_kernel).setGamma(gamma);
            } else if (kernelType.compareTo("PolyKernel") == 0) {
                this.m_kernel = new PolyKernel();
                ((PolyKernel)this.m_kernel).setExponent(exponent);
                ((PolyKernel)this.m_kernel).setUseLowerOrder(useLowerOrder);
            } else if (kernelType.compareTo("NormalizedPolyKernel") == 0) {
                this.m_kernel = new NormalizedPolyKernel();
                ((NormalizedPolyKernel)this.m_kernel).setExponent(exponent);
                ((NormalizedPolyKernel)this.m_kernel).setUseLowerOrder(useLowerOrder);
            } else if (kernelType.compareTo("Puk") == 0) {
                this.m_kernel = new Puk();
                ((Puk)this.m_kernel).setOmega(omega);
                ((Puk)this.m_kernel).setSigma(sigma);
            } else if (kernelType.compareTo("StringKernel") == 0) {
                this.m_kernel = new StringKernel();
                ((StringKernel)this.m_kernel).setLambda(lambda);
                ((StringKernel)this.m_kernel).setSubsequenceLength(subsequenceLength);
                ((StringKernel)this.m_kernel).setMaxSubsequenceLength(maxSubsequenceLength);
                ((StringKernel)this.m_kernel).setUseNormalization(normalize);
                if (pruning.compareTo("Lambda") == 0) {
                    ((StringKernel)this.m_kernel).setPruningMethod(new SelectedTag(1, StringKernel.TAGS_PRUNING));
                } else {
                    ((StringKernel)this.m_kernel).setPruningMethod(new SelectedTag(0, StringKernel.TAGS_PRUNING));
                }
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("FitLogisticModels = ");
            boolean bl3 = this.m_fitLogisticModels = new String(out[1]).compareTo("True") == 0;
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("ConvertNominalAttributesToBinary = ");
            boolean bl4 = this.m_nominalToBinary = new String(out[1]).compareTo("True") == 0;
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("PreprocessType = ");
            String preprocess = new String(out[1]);
            this.m_filterType = preprocess.compareTo("Normalize") == 0 ? 0 : (preprocess.compareTo("Standardize") == 0 ? 1 : 2);
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void writeOutput(String fileName, String[] instancesIN, String[] instancesOUT, Attribute[] inputs, Attribute output, int nInputs, String relation) {
        int j;
        int i;
        String cadena = "";
        cadena = cadena + "@relation " + relation + "\n";
        for (i = 0; i < nInputs; ++i) {
            cadena = cadena + "@attribute " + inputs[i].getName() + " ";
            if (inputs[i].getType() == 0) {
                cadena = cadena + "{";
                for (j = 0; j < inputs[i].getNominalValuesList().size(); ++j) {
                    cadena = cadena + (String)inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= inputs[i].getNominalValuesList().size() - 1) continue;
                    cadena = cadena + ", ";
                }
                cadena = cadena + "}\n";
                continue;
            }
            if (inputs[i].getType() == 1) {
                cadena = cadena + "integer";
                cadena = cadena + " [" + String.valueOf((int)inputs[i].getMinAttribute()) + ", " + String.valueOf((int)inputs[i].getMaxAttribute()) + "]\n";
                continue;
            }
            cadena = cadena + "real";
            cadena = cadena + " [" + String.valueOf(inputs[i].getMinAttribute()) + ", " + String.valueOf(inputs[i].getMaxAttribute()) + "]\n";
        }
        cadena = cadena + "@attribute " + output.getName() + " ";
        if (output.getType() == 0) {
            cadena = cadena + "{";
            for (j = 0; j < output.getNominalValuesList().size(); ++j) {
                cadena = cadena + (String)output.getNominalValuesList().elementAt(j);
                if (j >= output.getNominalValuesList().size() - 1) continue;
                cadena = cadena + ", ";
            }
            cadena = cadena + "}\n";
        } else {
            cadena = cadena + "integer [" + String.valueOf((int)output.getMinAttribute()) + ", " + String.valueOf((int)output.getMaxAttribute()) + "]\n";
        }
        cadena = cadena + "@data\n";
        Files.writeFile(fileName, cadena);
        cadena = "";
        for (i = 0; i < instancesIN.length; ++i) {
            cadena = cadena + instancesIN[i] + " " + instancesOUT[i];
            cadena = cadena + "\n";
        }
        Files.addToFile(fileName, cadena);
    }

    protected void printSVs() {
        int total_svs = 0;
        Files.writeFile(this.method_output, "");
        if (this.m_KernelIsLinear) {
            Files.addToFile(this.method_output, "Linear Kernel selected. No support vector extracted.\n");
        } else {
            for (int i = 0; i < this.m_classifiers.length; ++i) {
                for (int j = i + 1; j < this.m_classifiers[i].length; ++j) {
                    SMOset svset;
                    BinarySMO bsmo = this.m_classifiers[i][j];
                    if (bsmo == null || (svset = bsmo.getSupportVectors()) == null) continue;
                    Attribute a = Attributes.getOutputAttributes()[0];
                    Files.addToFile(this.method_output, "support vectors class " + a.getNominalValue(i) + " vs. " + a.getNominalValue(j) + "\n");
                    Files.addToFile(this.method_output, svset.elmentsToString());
                    total_svs += svset.numElements();
                }
            }
            Files.addToFile(this.method_output, "Total support vectors: " + total_svs + "\n");
        }
    }

    protected Instances InstancesKEEL2Weka(InstanceSet is, int preprocessType, boolean nominal2binary) {
        int j;
        int newNumAttributes;
        Instances data;
        Attribute a;
        int i;
        FastVector atts;
        int out = Attributes.getInputNumAttributes();
        if (!nominal2binary) {
            atts = new FastVector(Attributes.getNumAttributes());
            for (i = 0; i < Attributes.getNumAttributes(); ++i) {
                a = Attributes.getAttribute(i);
                atts.addElement(a);
                if (a.getDirectionAttribute() != 2) continue;
                out = i;
            }
            data = new Instances(Attributes.getRelationName(), atts, is.getNumInstances());
            data.setClassIndex(out);
            newNumAttributes = Attributes.getNumAttributes();
        } else {
            newNumAttributes = 0;
            atts = new FastVector(Attributes.getNumAttributes());
            for (i = 0; i < Attributes.getNumAttributes(); ++i) {
                a = Attributes.getAttribute(i);
                if (a.getType() == 0 && a.getDirectionAttribute() != 2) {
                    Attribute newAt;
                    if (a.getNumNominalValues() > 2) {
                        newNumAttributes += a.getNumNominalValues();
                        for (j = 0; j < a.getNumNominalValues(); ++j) {
                            newAt = new Attribute();
                            newAt.setType(1);
                            newAt.setDirectionAttribute(a.getDirectionAttribute());
                            newAt.setName(a.getName() + "=" + a.getNominalValue(j));
                            newAt.enlargeBounds(0.0);
                            newAt.enlargeBounds(1.0);
                            atts.addElement(newAt);
                        }
                    } else {
                        ++newNumAttributes;
                        newAt = new Attribute();
                        newAt.setType(1);
                        newAt.setDirectionAttribute(a.getDirectionAttribute());
                        newAt.setName(a.getName());
                        newAt.enlargeBounds(0.0);
                        newAt.enlargeBounds(1.0);
                        atts.addElement(newAt);
                    }
                }
                if (a.getType() != 0) {
                    ++newNumAttributes;
                    atts.addElement(a);
                }
                if (a.getDirectionAttribute() != 2) continue;
                atts.addElement(a);
                out = newNumAttributes++;
            }
            data = new Instances(Attributes.getRelationName(), atts, is.getNumInstances());
            data.setClassIndex(out);
        }
        for (i = 0; i < is.getNumInstances(); ++i) {
            keel.Dataset.Instance instK = is.getInstance(i);
            out = 0;
            int in = 0;
            int enlargedValueVectorPos = 0;
            double[] values = new double[newNumAttributes];
            for (j = 0; j < Attributes.getNumAttributes(); ++j) {
                a = Attributes.getAttribute(j);
                if (a.getDirectionAttribute() == 1) {
                    if (a.getType() != 0) {
                        values[enlargedValueVectorPos] = preprocessType == 0 ? this.normalize(instK.getAllInputValues()[in], a) : (preprocessType == 1 ? this.standardize(instK.getAllInputValues()[in], j) : instK.getAllInputValues()[in]);
                        ++enlargedValueVectorPos;
                    } else if (nominal2binary) {
                        if (a.getNumNominalValues() > 2) {
                            for (int k = 0; k < a.getNumNominalValues(); ++k) {
                                if (instK.getInputMissingValues(in) || a.getNominalValue(k).compareTo(instK.getInputNominalValues(in)) != 0) continue;
                                values[enlargedValueVectorPos + k] = 1.0;
                            }
                            enlargedValueVectorPos += a.getNumNominalValues();
                        } else {
                            values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                            ++enlargedValueVectorPos;
                        }
                    } else {
                        values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                        ++enlargedValueVectorPos;
                    }
                    ++in;
                    continue;
                }
                values[enlargedValueVectorPos] = instK.getOutputNominalValuesInt(out);
                ++out;
                ++enlargedValueVectorPos;
            }
            Instance instW = new Instance(1.0, values);
            data.add(instW);
        }
        return data;
    }

    protected double normalize(double value, Attribute a) {
        double norm = (value - a.getMinAttribute()) / (a.getMaxAttribute() - a.getMinAttribute());
        return norm;
    }

    protected double standardize(double value, int j) {
        double norm = this.std_dev[j] > 0.0 ? (value - this.mean[j]) / this.std_dev[j] : value - this.mean[j];
        return norm;
    }

    protected void computeStats(InstanceSet IS) {
        int in = 0;
        int out = 0;
        int ndatos = IS.getNumInstances();
        int nvariables = Attributes.getNumAttributes();
        double[] sum = new double[nvariables];
        double[] square_sum = new double[nvariables];
        int[] numAtt = new int[nvariables];
        this.mean = new double[nvariables];
        this.std_dev = new double[nvariables];
        for (int i = 0; i < ndatos; ++i) {
            keel.Dataset.Instance inst = IS.getInstance(i);
            in = 0;
            out = 0;
            for (int j = 0; j < nvariables; ++j) {
                Attribute a = Attributes.getAttribute(j);
                int direccion = a.getDirectionAttribute();
                int tipo = a.getType();
                if (direccion == 1) {
                    if (tipo != 0 && !inst.getInputMissingValues(in)) {
                        int n = j;
                        sum[n] = sum[n] + inst.getInputRealValues(in);
                        int n2 = j;
                        square_sum[n2] = square_sum[n2] + inst.getInputRealValues(in) * inst.getInputRealValues(in);
                        int n3 = j;
                        numAtt[n3] = numAtt[n3] + 1;
                    }
                    ++in;
                    continue;
                }
                if (direccion != 2) continue;
                if (tipo != 0 && !inst.getOutputMissingValues(out)) {
                    int n = j;
                    sum[n] = sum[n] + inst.getOutputRealValues(out);
                    int n4 = j;
                    square_sum[n4] = square_sum[n4] + inst.getOutputRealValues(out);
                    int n5 = j;
                    numAtt[n5] = numAtt[n5] + 1;
                }
                ++out;
            }
        }
        for (int j = 0; j < nvariables; ++j) {
            if (numAtt[j] == 0) continue;
            this.mean[j] = sum[j] / (double)numAtt[j];
            this.std_dev[j] = square_sum[j] / (double)numAtt[j] - this.mean[j] * this.mean[j];
            this.std_dev[j] = Math.sqrt(this.std_dev[j]);
        }
    }

    public class BinarySMO
    implements Serializable {
        static final long serialVersionUID = -8246163625699362456L;
        protected double[] m_alpha;
        protected double m_b;
        protected double m_bLow;
        protected double m_bUp;
        protected int m_iLow;
        protected int m_iUp;
        protected Instances m_data;
        protected double[] m_weights;
        protected double[] m_sparseWeights;
        protected int[] m_sparseIndices;
        protected Kernel m_kernel;
        protected double[] m_class;
        protected double[] m_errors;
        protected SMOset m_I0;
        protected SMOset m_I1;
        protected SMOset m_I2;
        protected SMOset m_I3;
        protected SMOset m_I4;
        protected SMOset m_supportVectors;
        protected Logistic m_logistic = null;
        protected double m_sumOfWeights = 0.0;

        protected void fitLogistic(Instances insts, int cl1, int cl2, int numFolds, Random random) throws Exception {
            FastVector atts = new FastVector(2);
            Attribute at = new Attribute();
            at.setName("pred");
            at.setDirectionAttribute(1);
            at.setType(2);
            atts.addElement(at);
            at = new Attribute();
            at.setName("class");
            at.setDirectionAttribute(2);
            at.setType(0);
            at.addNominalValue((String)Attributes.getOutputAttribute(0).getNominalValuesList().get(cl1));
            at.addNominalValue((String)Attributes.getOutputAttribute(0).getNominalValuesList().get(cl2));
            atts.addElement(at);
            Instances data = new Instances("data", atts, insts.numInstances());
            data.setClassIndex(1);
            for (int j = 0; j < insts.numInstances(); ++j) {
                Instance inst = insts.instance(j);
                double[] vals = new double[2];
                vals[0] = this.SVMOutput(-1, inst);
                if (inst.classValue() == (double)cl2) {
                    vals[1] = 1.0;
                }
                data.add(new Instance(inst.weight(), vals));
            }
            this.m_logistic = new Logistic();
            InstanceSet isData = new InstanceSet();
            isData.addAttribute((Attribute)atts.elementAt(0));
            isData.addAttribute((Attribute)atts.elementAt(1));
            for (int i = 0; i < data.numInstances(); ++i) {
                keel.Dataset.Instance instKEEL = new keel.Dataset.Instance(data.instance(i).toDoubleArray(), isData.getAttributeDefinitions());
                isData.addInstance(instKEEL);
            }
            this.m_logistic.buildClassifier(isData, isData.getAttributeDefinitions());
        }

        public void setKernel(Kernel value) {
            this.m_kernel = value;
        }

        public Kernel getKernel() {
            return this.m_kernel;
        }

        public void buildClassifier(Instances insts, int cl1, int cl2, boolean fitLogistic, int numFolds, int randomSeed) throws Exception {
            int i;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_logistic = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = insts.sumOfWeights();
            this.m_class = new double[insts.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (i = 0; i < this.m_class.length; ++i) {
                if ((int)insts.instance(i).classValue() == cl1) {
                    this.m_class[i] = -1.0;
                    this.m_iLow = i;
                    continue;
                }
                if ((int)insts.instance(i).classValue() == cl2) {
                    this.m_class[i] = 1.0;
                    this.m_iUp = i;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                if (SMO.this.m_KernelIsLinear) {
                    this.m_sparseWeights = new double[0];
                    this.m_sparseIndices = new int[0];
                    this.m_class = null;
                } else {
                    this.m_supportVectors = new SMOset(0);
                    this.m_alpha = new double[0];
                    this.m_class = new double[0];
                }
                if (fitLogistic) {
                    this.fitLogistic(insts, cl1, cl2, numFolds, new Random(randomSeed));
                }
                return;
            }
            this.m_data = insts;
            this.m_weights = (double[])(SMO.this.m_KernelIsLinear ? new double[this.m_data.numAttributes()] : null);
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_kernel.buildKernel(this.m_data);
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            for (i = 0; i < this.m_class.length; ++i) {
                if (this.m_class[i] == 1.0) {
                    this.m_I1.insert(i);
                    continue;
                }
                this.m_I4.insert(i);
            }
            int numChanged = 0;
            boolean examineAll = true;
            while (numChanged > 0 || examineAll) {
                int i2;
                numChanged = 0;
                if (examineAll) {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!this.examineExample(i2)) continue;
                        ++numChanged;
                    }
                } else {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!(this.m_alpha[i2] > 0.0) || !(this.m_alpha[i2] < SMO.this.m_C * this.m_data.instance(i2).weight())) continue;
                        if (this.examineExample(i2)) {
                            ++numChanged;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * SMO.this.m_tol)) continue;
                        numChanged = 0;
                        break;
                    }
                }
                if (examineAll) {
                    examineAll = false;
                    continue;
                }
                if (numChanged != 0) continue;
                examineAll = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (SMO.this.m_KernelIsLinear) {
                this.m_supportVectors = null;
                this.m_class = null;
                this.m_data = !SMO.this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
                double[] sparseWeights = new double[this.m_weights.length];
                int[] sparseIndices = new int[this.m_weights.length];
                int counter = 0;
                for (int i3 = 0; i3 < this.m_weights.length; ++i3) {
                    if (this.m_weights[i3] == 0.0) continue;
                    sparseWeights[counter] = this.m_weights[i3];
                    sparseIndices[counter] = i3;
                    ++counter;
                }
                this.m_sparseWeights = new double[counter];
                this.m_sparseIndices = new int[counter];
                System.arraycopy(sparseWeights, 0, this.m_sparseWeights, 0, counter);
                System.arraycopy(sparseIndices, 0, this.m_sparseIndices, 0, counter);
                this.m_weights = null;
                this.m_alpha = null;
            }
            if (fitLogistic) {
                this.fitLogistic(insts, cl1, cl2, numFolds, new Random(randomSeed));
            }
        }

        public double SVMOutput(int index, Instance inst) throws Exception {
            double result = 0.0;
            if (SMO.this.m_KernelIsLinear) {
                if (this.m_sparseWeights == null) {
                    int n1 = inst.numValues();
                    for (int p = 0; p < n1; ++p) {
                        if (inst.index(p) == SMO.this.m_classIndex) continue;
                        result += this.m_weights[inst.index(p)] * inst.valueSparse(p);
                    }
                } else {
                    int n1 = inst.numValues();
                    int n2 = this.m_sparseWeights.length;
                    int p1 = 0;
                    int p2 = 0;
                    while (p1 < n1 && p2 < n2) {
                        int ind2;
                        int ind1 = inst.index(p1);
                        if (ind1 == (ind2 = this.m_sparseIndices[p2])) {
                            if (ind1 != SMO.this.m_classIndex) {
                                result += inst.valueSparse(p1) * this.m_sparseWeights[p2];
                            }
                            ++p1;
                            ++p2;
                            continue;
                        }
                        if (ind1 > ind2) {
                            ++p2;
                            continue;
                        }
                        ++p1;
                    }
                }
            } else {
                int i = this.m_supportVectors.getNext(-1);
                while (i != -1) {
                    result += this.m_class[i] * this.m_alpha[i] * this.m_kernel.eval(index, i, inst);
                    i = this.m_supportVectors.getNext(i);
                }
            }
            return result -= this.m_b;
        }

        protected boolean examineExample(int i2) throws Exception {
            double F2;
            int i1 = -1;
            double y2 = this.m_class[i2];
            if (this.m_I0.contains(i2)) {
                F2 = this.m_errors[i2];
            } else {
                this.m_errors[i2] = F2 = this.SVMOutput(i2, this.m_data.instance(i2)) + this.m_b - y2;
                if ((this.m_I1.contains(i2) || this.m_I2.contains(i2)) && F2 < this.m_bUp) {
                    this.m_bUp = F2;
                    this.m_iUp = i2;
                } else if ((this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 > this.m_bLow) {
                    this.m_bLow = F2;
                    this.m_iLow = i2;
                }
            }
            boolean optimal = true;
            if ((this.m_I0.contains(i2) || this.m_I1.contains(i2) || this.m_I2.contains(i2)) && this.m_bLow - F2 > 2.0 * SMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iLow;
            }
            if ((this.m_I0.contains(i2) || this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 - this.m_bUp > 2.0 * SMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iUp;
            }
            if (optimal) {
                return false;
            }
            if (this.m_I0.contains(i2)) {
                i1 = this.m_bLow - F2 > F2 - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (i1 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(i1, i2, F2);
        }

        protected boolean takeStep(int i1, int i2, double F2) throws Exception {
            double a2;
            double k22;
            double H;
            double L;
            double C1 = SMO.this.m_C * this.m_data.instance(i1).weight();
            double C2 = SMO.this.m_C * this.m_data.instance(i2).weight();
            if (i1 == i2) {
                return false;
            }
            double alph1 = this.m_alpha[i1];
            double alph2 = this.m_alpha[i2];
            double y1 = this.m_class[i1];
            double y2 = this.m_class[i2];
            double F1 = this.m_errors[i1];
            double s = y1 * y2;
            if (y1 != y2) {
                L = Math.max(0.0, alph2 - alph1);
                H = Math.min(C2, C1 + alph2 - alph1);
            } else {
                L = Math.max(0.0, alph1 + alph2 - C1);
                H = Math.min(C2, alph1 + alph2);
            }
            if (L >= H) {
                return false;
            }
            double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
            double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
            double eta = 2.0 * k12 - k11 - (k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2)));
            if (eta < 0.0) {
                a2 = alph2 - y2 * (F1 - F2) / eta;
                if (a2 < L) {
                    a2 = L;
                } else if (a2 > H) {
                    a2 = H;
                }
            } else {
                double Hobj;
                double f2;
                double v2;
                double gamma = alph1 + s * alph2;
                double f1 = this.SVMOutput(i1, this.m_data.instance(i1));
                double v1 = f1 + this.m_b - y1 * alph1 * k11 - y2 * alph2 * k12;
                double Lobj = gamma - s * L + L - 0.5 * k11 * (gamma - s * L) * (gamma - s * L) - 0.5 * k22 * L * L - s * k12 * (gamma - s * L) * L - y1 * (gamma - s * L) * v1 - y2 * L * (v2 = (f2 = this.SVMOutput(i2, this.m_data.instance(i2))) + this.m_b - y1 * alph1 * k12 - y2 * alph2 * k22);
                a2 = Lobj > (Hobj = gamma - s * H + H - 0.5 * k11 * (gamma - s * H) * (gamma - s * H) - 0.5 * k22 * H * H - s * k12 * (gamma - s * H) * H - y1 * (gamma - s * H) * v1 - y2 * H * v2) + SMO.this.m_eps ? L : (Lobj < Hobj - SMO.this.m_eps ? H : alph2);
            }
            if (Math.abs(a2 - alph2) < SMO.this.m_eps * (a2 + alph2 + SMO.this.m_eps)) {
                return false;
            }
            if (a2 > C2 - m_Del * C2) {
                a2 = C2;
            } else if (a2 <= m_Del * C2) {
                a2 = 0.0;
            }
            double a1 = alph1 + s * (alph2 - a2);
            if (a1 > C1 - m_Del * C1) {
                a1 = C1;
            } else if (a1 <= m_Del * C1) {
                a1 = 0.0;
            }
            if (a1 > 0.0) {
                this.m_supportVectors.insert(i1);
            } else {
                this.m_supportVectors.delete(i1);
            }
            if (a1 > 0.0 && a1 < C1) {
                this.m_I0.insert(i1);
            } else {
                this.m_I0.delete(i1);
            }
            if (y1 == 1.0 && a1 == 0.0) {
                this.m_I1.insert(i1);
            } else {
                this.m_I1.delete(i1);
            }
            if (y1 == -1.0 && a1 == C1) {
                this.m_I2.insert(i1);
            } else {
                this.m_I2.delete(i1);
            }
            if (y1 == 1.0 && a1 == C1) {
                this.m_I3.insert(i1);
            } else {
                this.m_I3.delete(i1);
            }
            if (y1 == -1.0 && a1 == 0.0) {
                this.m_I4.insert(i1);
            } else {
                this.m_I4.delete(i1);
            }
            if (a2 > 0.0) {
                this.m_supportVectors.insert(i2);
            } else {
                this.m_supportVectors.delete(i2);
            }
            if (a2 > 0.0 && a2 < C2) {
                this.m_I0.insert(i2);
            } else {
                this.m_I0.delete(i2);
            }
            if (y2 == 1.0 && a2 == 0.0) {
                this.m_I1.insert(i2);
            } else {
                this.m_I1.delete(i2);
            }
            if (y2 == -1.0 && a2 == C2) {
                this.m_I2.insert(i2);
            } else {
                this.m_I2.delete(i2);
            }
            if (y2 == 1.0 && a2 == C2) {
                this.m_I3.insert(i2);
            } else {
                this.m_I3.delete(i2);
            }
            if (y2 == -1.0 && a2 == 0.0) {
                this.m_I4.insert(i2);
            } else {
                this.m_I4.delete(i2);
            }
            if (SMO.this.m_KernelIsLinear) {
                Instance inst1 = this.m_data.instance(i1);
                for (int p1 = 0; p1 < inst1.numValues(); ++p1) {
                    if (inst1.index(p1) == this.m_data.classIndex()) continue;
                    int n = inst1.index(p1);
                    this.m_weights[n] = this.m_weights[n] + y1 * (a1 - alph1) * inst1.valueSparse(p1);
                }
                Instance inst2 = this.m_data.instance(i2);
                for (int p2 = 0; p2 < inst2.numValues(); ++p2) {
                    if (inst2.index(p2) == this.m_data.classIndex()) continue;
                    int n = inst2.index(p2);
                    this.m_weights[n] = this.m_weights[n] + y2 * (a2 - alph2) * inst2.valueSparse(p2);
                }
            }
            int j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (j != i1 && j != i2) {
                    int n = j;
                    this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * this.m_kernel.eval(i1, j, this.m_data.instance(i1)) + y2 * (a2 - alph2) * this.m_kernel.eval(i2, j, this.m_data.instance(i2)));
                }
                j = this.m_I0.getNext(j);
            }
            int n = i1;
            this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * k11 + y2 * (a2 - alph2) * k12);
            int n2 = i2;
            this.m_errors[n2] = this.m_errors[n2] + (y1 * (a1 - alph1) * k12 + y2 * (a2 - alph2) * k22);
            this.m_alpha[i1] = a1;
            this.m_alpha[i2] = a2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (this.m_errors[j] < this.m_bUp) {
                    this.m_bUp = this.m_errors[j];
                    this.m_iUp = j;
                }
                if (this.m_errors[j] > this.m_bLow) {
                    this.m_bLow = this.m_errors[j];
                    this.m_iLow = j;
                }
                j = this.m_I0.getNext(j);
            }
            if (!this.m_I0.contains(i1)) {
                if (this.m_I3.contains(i1) || this.m_I4.contains(i1)) {
                    if (this.m_errors[i1] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i1];
                        this.m_iLow = i1;
                    }
                } else if (this.m_errors[i1] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i1];
                    this.m_iUp = i1;
                }
            }
            if (!this.m_I0.contains(i2)) {
                if (this.m_I3.contains(i2) || this.m_I4.contains(i2)) {
                    if (this.m_errors[i2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i2];
                        this.m_iLow = i2;
                    }
                } else if (this.m_errors[i2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i2];
                    this.m_iUp = i2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        protected void checkClassifier() throws Exception {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.m_alpha.length; ++i) {
                if (!(this.m_alpha[i] > 0.0)) continue;
                sum += this.m_class[i] * this.m_alpha[i];
            }
            System.err.println("Sum of y(i) * alpha(i): " + sum);
            for (i = 0; i < this.m_alpha.length; ++i) {
                double output = this.SVMOutput(i, this.m_data.instance(i));
                if (Utils.eq(this.m_alpha[i], 0.0) && Utils.sm(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[i] * output);
                }
                if (Utils.gr(this.m_alpha[i], 0.0) && Utils.sm(this.m_alpha[i], SMO.this.m_C * this.m_data.instance(i).weight()) && !Utils.eq(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[i] * output);
                }
                if (!Utils.eq(this.m_alpha[i], SMO.this.m_C * this.m_data.instance(i).weight()) || !Utils.gr(this.m_class[i] * output, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[i] * output);
            }
        }

        public double getB() {
            return this.m_b;
        }

        public SMOset getSupportVectors() {
            return this.m_supportVectors;
        }

        public double[] getLagrangeMultipliers() {
            return this.m_alpha;
        }

        public double[] getClasses() {
            return this.m_class;
        }
    }
}

