/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.FloatOption;
import weka.core.Instance;

public class TargetMean
extends AbstractClassifier
implements Regressor {
    protected long n;
    protected double sum;
    protected double errorSum;
    protected double nError;
    private double fadingErrorFactor;
    private static final long serialVersionUID = 7152547322803559115L;
    public FloatOption fadingErrorFactorOption = new FloatOption("fadingErrorFactor", 'e', "Fading error factor for the TargetMean accumulated error", 0.99, 0.0, 1.0);

    public boolean isRandomizable() {
        return false;
    }

    public double[] getVotesForInstance(Instance inst) {
        double[] currentMean = new double[]{this.n > 0L ? this.sum / (double)this.n : 0.0};
        return currentMean;
    }

    public void resetLearningImpl() {
        this.sum = 0.0;
        this.n = 0L;
        this.errorSum = Double.MAX_VALUE;
        this.nError = 0.0;
    }

    public void trainOnInstanceImpl(Instance inst) {
        this.updateAccumulatedError(inst);
        ++this.n;
        this.sum += inst.classValue();
    }

    protected void updateAccumulatedError(Instance inst) {
        double mean = 0.0;
        this.nError = 1.0 + this.fadingErrorFactor * this.nError;
        if (this.n > 0L) {
            mean = this.sum / (double)this.n;
        }
        this.errorSum = Math.abs(inst.classValue() - mean) + this.fadingErrorFactor * this.errorSum;
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Current Mean: " + this.sum / (double)this.n);
        StringUtils.appendNewline(out);
    }

    public void reset(double currentMean, long numberOfInstances) {
        this.sum = currentMean * (double)numberOfInstances;
        this.n = numberOfInstances;
        this.resetError();
    }

    public double getCurrentError() {
        if (this.nError > 0.0) {
            return this.errorSum / this.nError;
        }
        return Double.MAX_VALUE;
    }

    public TargetMean(TargetMean t) {
        this.n = t.n;
        this.sum = t.sum;
        this.errorSum = t.errorSum;
        this.nError = t.nError;
        this.fadingErrorFactor = t.fadingErrorFactor;
        this.fadingErrorFactorOption = t.fadingErrorFactorOption;
    }

    public TargetMean() {
        this.fadingErrorFactor = this.fadingErrorFactorOption.getValue();
    }

    public void resetError() {
        this.errorSum = 0.0;
        this.nError = 0.0;
    }
}

