## ---- echo = FALSE, message = FALSE-------------------------------------------
knitr::opts_chunk$set(collapse = T, comment = "#>")
options(tibble.print_min = 4L, tibble.print_max = 4L, pillar.sigfig = 5)
library(SDAR)

## ---- eval = FALSE------------------------------------------------------------
#  install.packages("SDAR")

## -----------------------------------------------------------------------------
library(SDAR)     # Load SDAR library
data(saltarin_beds)     # load Saltarin demo dataset
class(saltarin_beds)

# check the content and the structure of Saltarin_beds dataset

nrow(saltarin_beds)     # number of rock layers
ncol(saltarin_beds)     # number of variables recording composition and texture description of each layer
names(saltarin_beds)     # variable names of composition and texture description of each layer

## -----------------------------------------------------------------------------
# header of the mandatory fields of "saltarin_beds" dataset to draw a graphic log using SDAR
head(saltarin_beds[,1:6])

## ---- eval = FALSE------------------------------------------------------------
#  vignette("SDAR_data_model")

## ---- eval = FALSE------------------------------------------------------------
#  install.packages("readxl")

## ---- eval = FALSE------------------------------------------------------------
#  library (readxl)     # load the readxl package
#  my_beds <- read_excel("file_name.xlsx")     # on your working directory
#  my_beds <- read_excel("Path where your Excel file is stored/file_name.xlsx")     # setting full path
#  
#  # Notice that the separator between folders is forward slash (/), as it is on Linux and Mac systems.
#  # When working in Windows, you need to either use the forward slash or using double backslash (\\).
#  my_beds <- read_excel("C:\\Users\\john\\Desktop\\File_name.xlsx")     # full path example in windows systems

## -----------------------------------------------------------------------------
#  Read the SDAR beds external data example (Excel file format)
library (readxl) 
fpath <- system.file("extdata", "SDAR_v0.95_beds_saltarin.xlsx", package = "SDAR")
beds_data <- read_excel(fpath)

nrow(beds_data)   # number of rock layers
names(beds_data)  # variable names of composition and texture description of each layer

## -----------------------------------------------------------------------------
# strata function automatically validates the inputted dataset
# and returns a stratigraphy class object.

validated_beds <- strata(saltarin_beds)

# check the class of the object generated by the strata function
class(validated_beds)

## ---- eval = FALSE------------------------------------------------------------
#  # datum = "base" must be selected when stratigraphic distance above datum
#  # increases upwards (toward younger levels, as a stratigraphic section).
#  outcrop_validated_beds <- strata(my_outcrop_beds, datum = "base")

## ---- eval = FALSE------------------------------------------------------------
#  # Code to generate example presented in Figure 1.
#  library(SDAR)     # load SDAR library
#  data(saltarin_beds)     # load Saltarin beds dataset
#  validated_beds <- strata(saltarin_beds)     # validates the Saltarin_beds dataset
#  plot(validated_beds)     # plot a stratigraphic log with the SDAR default options
#  # The default parameters are: `datum = "top"`, `data.units = "feet"`,
#  # `scale = 100`, and `barscale = 2`

## ---- eval = FALSE------------------------------------------------------------
#  # Code to generate example presented in Figure 2.
#  plot(validated_beds, data.units="meters", scale=300, barscale=5)
#  # plot Saltarin dataset at 1:300 scale in meters (meters was the measure unit in the description
#  # process of Saltarin well), and thickness marks and labels each 5 meters, by default the bar scale is
#  # plotted at the left side of the lithology track.

## ---- eval = FALSE------------------------------------------------------------
#  # Code to generate the example presented in Figure 3.
#  plot(validated_beds, data.units="meters", subset.base=614, subset.top=597)

## ---- eval = FALSE------------------------------------------------------------
#  # Specify sheet by its name
#  my_int_data <- read_excel("file_name.xlsx", sheet= "data")     # on your working directory
#  my_int_data <- read_excel("Path where your Excel file is stored/file_name.xlsx", sheet= "data")  # full path
#  
#  # Specify sheet by its index
#  my_int_data <- read_excel("file_name.xlsx", sheet= 1)
#  
#  # Notice that the separator between folders is forward slash (/), as it is on Linux and Mac systems.
#  # When working in Windows, you need to either use the forward slash or using double backslash (\\).
#  # full path example in windows systems
#  my_int_data <- read_excel("C:\\Users\\john\\Desktop\\File_name.xlsx", sheet= "data")

## -----------------------------------------------------------------------------
#  Read the bioturbation external data example (Saltarin intervals Excel file format)
fpath <- system.file("extdata", "SDAR_v0.95_intervals_saltarin.xlsx", package = "SDAR")
bioturbation_data <- read_excel(fpath, sheet = "bioturbation")     # import bioturbation sheet

nrow(bioturbation_data)   # number of bioturbated intervals
bioturbation_data  # header of Saltarin bioturbation dataset

## -----------------------------------------------------------------------------
# import core_number data
core_number_data <- read_excel(fpath, sheet = "core_number")
# import samples data
samples_data <- read_excel(fpath, sheet = "samples")
# import sedimentary structures data
sed_structures_data <- read_excel(fpath, sheet = "sed_structures")
# import fossils data
fossils_data <- read_excel(fpath, sheet = "fossils")

# import other symbols data
other_symbols_data <- read_excel(fpath, sheet = "other_symbols")
# import lithostratigraphy data
litho_data <- read_excel(fpath, sheet = "lithostra")
# import chronostratigraphy data
crono_data <- read_excel(fpath, sheet = "chronostra")

## ---- eval = FALSE------------------------------------------------------------
#  # Code to generate example presented in Figure 4.
#  plot(validated_beds, data.units="meters",
#      subset.base=664, subset.top=649,
#      bioturbation=bioturbation_data,
#      fossils=fossils_data,
#      sed.structures=sed_structures_data,
#      other.sym=other_symbols_data,
#      samples=samples_data,
#      ncore=core_number_data,
#      lithostrat=litho_data,
#      chronostrat=crono_data,
#      symbols.size=0.8)
#  # For the performance of this example only a subset of the data is plotted. In order to plot
#  # the complete Saltarin Well dataset, suppress subset.base=664, and subset.top=649" parameters

## -----------------------------------------------------------------------------
summary(validated_beds)
summary(validated_beds, grain.size=TRUE)

