## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
# Ensure the temporary library from R CMD check is visible (esp. on Windows)
libdir <- Sys.getenv("R_LIBS")
if (nzchar(libdir)) {
  parts <- strsplit(libdir, .Platform$path.sep, fixed = TRUE)[[1]]
  .libPaths(unique(c(parts, .libPaths())))
}

# now load your package
suppressPackageStartupMessages(library(ecotourism))


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------
library(dplyr)
library(ecotourism)
data("glowworms")
glowworms |> glimpse()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
library(ggplot2)
library(ggthemes)

glowworms |> 
  ggplot() +
    geom_sf(data = oz_lga) +
    geom_point(aes(x = obs_lon, y = obs_lat), color = "red") +
    theme_map()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------

week_order <- c("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday")

glowworms |> 
  ggplot(aes(x = factor(weekday, levels = week_order))) +
    geom_bar() +
    labs(x = "Weekday", y = "Number of Records") +
    theme_minimal()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE, message=FALSE, warning=FALSE----
library(lubridate)
glowworms |>
    dplyr::mutate(month = month(month, label = TRUE, abbr = TRUE)) |>
    ggplot(aes(x = factor(month))) +
    geom_bar() +
    labs(x = "Month", y = "Number of Records") +
    theme_minimal()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
glowworms |>
    ggplot(aes(x = factor(year))) +
    geom_bar() +
    labs(x = "Year", y = "Number of Records")+
    theme_minimal()


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE, fig.width=6, fig.height=4----

# Prepare glowworms occurrence counts per quarter
glowworms_quarterly <- glowworms |>
  mutate(quarter = quarter(date)) |>
  group_by(year, quarter, ws_id) |>
  summarise(occurrence = n(), .groups = "drop")

# tourism quarterly spot data set near glowworms occurrence
tourism_sub <- tourism_quarterly |>
   filter(ws_id %in% glowworms$ws_id)

glowworms_tourism <- glowworms_quarterly |>
  left_join(tourism_sub, by=c("ws_id", "year", "quarter"))

# Simple scatter plot: precipitation vs glowworms occurrence
ggplot(glowworms_tourism, aes(x = quarter, y = occurrence)) +
  geom_jitter(width=0.1) +
  stat_summary(colour="red", geom = "point", size=3) +
  labs(
    title = "Relationship between tourism and glowworms occurrence",
    x = "Quarter",
    y = "Occurrence (jittered)"
  ) +
  theme_minimal()

