/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.net.IDN;
import javax.mail.internet.InternetAddress;

public class IDNEmailAddressConverter {
    public String toASCII(String email) {
        int idx = this.findAtSymbolIndex(email);
        if (idx < 0) {
            return email;
        }
        return this.getLocalPart(email, idx) + '@' + IDN.toASCII(this.getDomainPart(email, idx));
    }

    String toUnicode(InternetAddress address) {
        return address != null ? this.toUnicode(address.getAddress()) : null;
    }

    String toUnicode(String email) {
        int idx = this.findAtSymbolIndex(email);
        if (idx < 0) {
            return email;
        }
        return this.getLocalPart(email, idx) + '@' + IDN.toUnicode(this.getDomainPart(email, idx));
    }

    private String getLocalPart(String email, int idx) {
        return email.substring(0, idx);
    }

    private String getDomainPart(String email, int idx) {
        return email.substring(idx + 1);
    }

    private int findAtSymbolIndex(String value) {
        if (value == null) {
            return -1;
        }
        return value.indexOf(64);
    }
}

