/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DoubleStringPair;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.GenericModelReader;
import opennlp.model.MaxentModel;
import opennlp.model.RealValueFileEventStream;

public class ModelApplier {
    MaxentModel _model;
    ContextGenerator _cg = new BasicContextGenerator(",");
    int counter = 1;
    public static final DecimalFormat ROUNDED_FORMAT = new DecimalFormat("0.000");

    public ModelApplier(MaxentModel m) {
        this._model = m;
    }

    private void eval(Event event) {
        this.eval(event, false);
    }

    private void eval(Event event, boolean real) {
        int i;
        double[] ocs;
        String outcome = event.getOutcome();
        String[] context = event.getContext();
        if (!real) {
            ocs = this._model.eval(context);
        } else {
            float[] values = RealValueFileEventStream.parseContexts(context);
            ocs = this._model.eval(context, values);
        }
        int numOutcomes = ocs.length;
        Object[] result = new DoubleStringPair[numOutcomes];
        for (i = 0; i < numOutcomes; ++i) {
            result[i] = new DoubleStringPair(ocs[i], this._model.getOutcome(i));
        }
        Arrays.sort(result);
        for (i = numOutcomes - 1; i >= 0; --i) {
            System.out.print(((DoubleStringPair)result[i]).stringValue + " " + ((DoubleStringPair)result[i]).doubleValue + " ");
        }
        System.out.println();
    }

    private static void usage() {
        System.err.println("java ModelApplier [-real] modelFile dataFile");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean real = false;
        String type = "maxent";
        int ai = 0;
        if (args.length == 0) {
            ModelApplier.usage();
        }
        if (args.length > 0) {
            while (args[ai].startsWith("-")) {
                if (args[ai].equals("-real")) {
                    real = true;
                } else if (args[ai].equals("-perceptron")) {
                    type = "perceptron";
                } else {
                    ModelApplier.usage();
                }
                ++ai;
            }
            String modelFileName = args[ai++];
            String dataFileName = args[ai++];
            ModelApplier predictor = null;
            try {
                AbstractModel m = new GenericModelReader(new File(modelFileName)).getModel();
                predictor = new ModelApplier(m);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            try {
                BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(new FileReader(new File(dataFileName))), ",");
                while (es.hasNext()) {
                    predictor.eval(es.next(), real);
                }
                return;
            }
            catch (Exception e) {
                System.out.println("Unable to read from specified file: " + modelFileName);
                System.out.println();
                e.printStackTrace();
            }
        }
    }
}

