/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropLessOrEqualXC
extends Propagator<IntVar> {
    private final int constant;

    public PropLessOrEqualXC(IntVar var, int cste) {
        super((Variable[])new IntVar[]{var}, (Priority)PropagatorPriority.UNARY, false, true);
        this.constant = cste;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].updateUpperBound(this.constant, (ICause)this) || ((IntVar[])this.vars)[0].getUB() <= this.constant) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() <= this.constant) {
            return ESat.TRUE;
        }
        if (((IntVar[])this.vars)[0].getLB() > this.constant) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        ((IntVar[])this.vars)[0].intersectLit(-1073741823, this.constant, explanation);
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " <= " + this.constant;
    }
}

