/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor.panels;

import dmLab.array.domain.SDomain;
import dmLab.array.meta.Attribute;
import dmLab.gui.dataEditor.ContainerOperations;
import dmLab.gui.dataEditor.components.GlyphButton;
import dmLab.gui.dataEditor.panels.EventsPanel;
import dmLab.gui.dataEditor.utils.AttributeType;
import dmLab.gui.dataEditor.utils.customTable.AttributesTableSelectionListener;
import dmLab.gui.dataEditor.utils.customTable.CustomTableCellRenderer;
import dmLab.gui.dataEditor.utils.intText.IntTextField;
import dmLab.utils.ArrayUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public final class AttributesPanel
extends JSplitPane
implements ActionListener,
CellEditorListener,
DocumentListener,
ListSelectionListener {
    private JScrollPane scrollAttrPanel;
    private JScrollPane scrollDomainPanel;
    private JTable attributesTable;
    private JTable domainTable;
    private JComboBox typesComboBox;
    private JTabbedPane tabbedPanel;
    private JPanel attrTools;
    public GlyphButton decisionSetButton;
    private GlyphButton moveAtrributeButton;
    private IntTextField moveByTextField;
    public GlyphButton addNewAttributeButton;
    public GlyphButton removeAttributeButton;
    private SDomain[] domains;
    private String[] attrHeaders;
    private String[] domainHeaders;
    private String decisionAttribute;
    private int moveByValue = 1;
    private String[] originalAttrNames;
    private HashMap<String, String> namesMap;
    private int[] attributesTableColumnWidth;
    private int[] domainTableColumnWidth;
    private AttributesTableSelectionListener listener;
    private EventsPanel eventsPanel;
    private ContainerOperations containerOperations;
    private final String decisionToolTipText = "Decision Attribute";
    private Color decisionAttrColor = new Color(255, 128, 128);

    /*
     * WARNING - void declaration
     */
    public AttributesPanel() {
        void var2_2;
        this.namesMap = new HashMap();
        this.attrHeaders = new String[]{"#", "name", "type"};
        this.domainHeaders = new String[]{"#", "domain", "freq"};
        String[] tmp = Attribute.getSupportedTypes();
        AttributeType[] types = new AttributeType[tmp.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new AttributeType(tmp[i]);
        }
        this.typesComboBox = new JComboBox((E[])var2_2);
        AttributesPanel attributesPanel = this;
        this.scrollAttrPanel = new JScrollPane();
        attributesPanel.scrollAttrPanel.setPreferredSize(new Dimension(200, 100));
        attributesPanel.scrollDomainPanel = new JScrollPane();
        attributesPanel.scrollDomainPanel.setPreferredSize(new Dimension(100, 100));
        attributesPanel.tabbedPanel = new JTabbedPane();
        attributesPanel.tabbedPanel.setPreferredSize(new Dimension(100, 100));
        attributesPanel.tabbedPanel.addTab("Domains", null, attributesPanel.scrollDomainPanel, null);
        attributesPanel.attrTools = new JPanel();
        attributesPanel.attrTools.setLayout(null);
        attributesPanel.tabbedPanel.addTab("Tools", null, attributesPanel.attrTools, null);
        attributesPanel.decisionSetButton = new GlyphButton("images/decisionTable.jpg", "Set Decision");
        attributesPanel.decisionSetButton.setToolTipText("Sets Selected Attribute as Decision Attribute.");
        attributesPanel.decisionSetButton.setBounds(10, 10, 50, 40);
        attributesPanel.attrTools.add(attributesPanel.decisionSetButton);
        attributesPanel.moveAtrributeButton = new GlyphButton("images/move.jpg", "Move Attribute");
        attributesPanel.moveAtrributeButton.setToolTipText("Move Attribute by x Positions.");
        attributesPanel.moveAtrributeButton.setBounds(20 + attributesPanel.decisionSetButton.getWidth(), 10, 50, 40);
        attributesPanel.attrTools.add(attributesPanel.moveAtrributeButton);
        attributesPanel.moveAtrributeButton.addActionListener(attributesPanel);
        attributesPanel.moveByTextField = new IntTextField();
        attributesPanel.moveByTextField.setToolTipText("Positions to Move by. Set -1 to move attribute backward by 1 position.");
        attributesPanel.attrTools.add(attributesPanel.moveByTextField);
        attributesPanel.moveByTextField.setBounds(10 + attributesPanel.moveAtrributeButton.getWidth() + attributesPanel.moveAtrributeButton.getX(), attributesPanel.moveAtrributeButton.getY(), 40, 20);
        attributesPanel.moveByTextField.setText(Integer.toString(attributesPanel.moveByValue));
        attributesPanel.moveByTextField.getDocument().addDocumentListener(attributesPanel);
        attributesPanel.addNewAttributeButton = new GlyphButton("images/addNew.jpg", "Add Attribute");
        attributesPanel.addNewAttributeButton.setToolTipText("Add new Attribute.");
        attributesPanel.addNewAttributeButton.setBounds(10, 10 + attributesPanel.decisionSetButton.getY() + attributesPanel.decisionSetButton.getHeight(), 50, 40);
        attributesPanel.attrTools.add(attributesPanel.addNewAttributeButton);
        attributesPanel.removeAttributeButton = new GlyphButton("images/remove.jpg", "Remove Attribute");
        attributesPanel.removeAttributeButton.setToolTipText("Remove Attribute.");
        attributesPanel.removeAttributeButton.setBounds(10 + attributesPanel.addNewAttributeButton.getWidth() + attributesPanel.addNewAttributeButton.getX(), 10 + attributesPanel.decisionSetButton.getY() + attributesPanel.decisionSetButton.getHeight(), 50, 40);
        attributesPanel.attrTools.add(attributesPanel.removeAttributeButton);
        attributesPanel.setOrientation(1);
        AttributesPanel attributesPanel2 = attributesPanel;
        attributesPanel2.add((Component)attributesPanel2.scrollAttrPanel, "left");
        AttributesPanel attributesPanel3 = attributesPanel;
        attributesPanel3.add((Component)attributesPanel3.tabbedPanel, "right");
    }

    private void getAttributesTableColumnWidth(boolean init) {
        this.attributesTableColumnWidth = new int[this.attrHeaders.length];
        for (int i = 0; i < this.attributesTableColumnWidth.length; ++i) {
            if (init) {
                if (i == 0) {
                    this.attributesTableColumnWidth[i] = 30;
                    continue;
                }
                this.attributesTableColumnWidth[i] = 80;
                continue;
            }
            this.attributesTableColumnWidth[i] = this.attributesTable.getColumnModel().getColumn(i).getPreferredWidth();
        }
    }

    private void getDomainTableColumnWidth(boolean init) {
        this.domainTableColumnWidth = new int[this.domainHeaders.length];
        int freqIndex = ArrayUtils.indexOf(this.domainHeaders, "freq");
        for (int i = 1; i < this.domainTableColumnWidth.length; ++i) {
            if (init) {
                if (i == 0) {
                    this.domainTableColumnWidth[i] = 30;
                    continue;
                }
                if (i == freqIndex) {
                    this.domainTableColumnWidth[i] = 40;
                    continue;
                }
                this.domainTableColumnWidth[i] = 80;
                continue;
            }
            this.domainTableColumnWidth[i] = this.domainTable.getColumnModel().getColumn(i).getPreferredWidth();
        }
    }

    private void setDomainTableColumnWidth() {
        if (this.domainTable != null) {
            for (int i = 0; i < this.domainTableColumnWidth.length; ++i) {
                this.domainTable.getColumnModel().getColumn(i).setPreferredWidth(this.domainTableColumnWidth[i]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPointers(ContainerOperations containerOperations, EventsPanel eventsPanel) {
        void var2_2;
        void var1_1;
        this.containerOperations = var1_1;
        this.eventsPanel = var2_2;
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.moveAtrributeButton) {
            AttributesPanel attributesPanel = this;
            int n = attributesPanel.moveByValue;
            object = attributesPanel;
            attributesPanel.attributesTable.setIgnoreRepaint(true);
            TableModel tableModel = ((AttributesPanel)object).attributesTable.getModel();
            int n2 = ((AttributesPanel)object).getAnchorAttributeIndex();
            int n3 = 1;
            if (n > 0) {
                n3 = 0;
            }
            System.out.println("Moving attribute " + ((AttributesPanel)object).getAttrName(n2) + " by " + n + " Positions.");
            while (n != 0) {
                boolean bl;
                int n4 = n3;
                Object object2 = tableModel;
                int n5 = n2;
                Object object3 = object;
                int n6 = 1;
                if (n4 != 0) {
                    n6 = -1;
                }
                if (n5 == 0 && n4 != 0) {
                    bl = false;
                } else if (n5 == object2.getRowCount() - 1 && n4 == 0) {
                    bl = false;
                } else {
                    n4 = ArrayUtils.indexOf(((AttributesPanel)object3).attrHeaders, "name");
                    int n7 = ArrayUtils.indexOf(((AttributesPanel)object3).attrHeaders, "type");
                    String string = object2.getValueAt(n5, n4).toString();
                    String string2 = object2.getValueAt(n5, n7).toString();
                    TableModel tableModel2 = object2;
                    tableModel2.setValueAt(tableModel2.getValueAt(n5 + n6, n4), n5, n4);
                    TableModel tableModel3 = object2;
                    tableModel3.setValueAt(tableModel3.getValueAt(n5 + n6, n7), n5, n7);
                    object2.setValueAt(string, n5 + n6, n4);
                    object2.setValueAt(string2, n5 + n6, n7);
                    object2 = ((AttributesPanel)object3).originalAttrNames[n5];
                    ((AttributesPanel)object3).originalAttrNames[n5] = ((AttributesPanel)object3).originalAttrNames[n5 + n6];
                    ((AttributesPanel)object3).originalAttrNames[n5 + n6] = object2;
                    ((AttributesPanel)object3).attributesTable.getSelectionModel().setAnchorSelectionIndex(n5 + n6);
                    int n8 = n5;
                    ((AttributesPanel)object3).containerOperations.container.swapColumns(n8, n8 + n6);
                    bl = true;
                }
                if (!bl) {
                    n = 0;
                    continue;
                }
                if (n3 != 0) {
                    ++n;
                    --n2;
                    continue;
                }
                --n;
                ++n2;
            }
            ((AttributesPanel)object).attributesTable.setIgnoreRepaint(false);
            ((AttributesPanel)object).eventsPanel.fillEventsTable();
        }
    }

    public final void setAttributes(String[][] attributes) {
        String[] stringArray;
        AttributesPanel attributesPanel;
        Object[][] rows;
        this.namesMap.clear();
        int nameIndex = ArrayUtils.indexOf(this.attrHeaders, "name");
        int typeIndex22 = ArrayUtils.indexOf(this.attrHeaders, "type");
        if (attributes != null) {
            rows = new Object[attributes[0].length][this.attrHeaders.length];
            this.originalAttrNames = new String[attributes[0].length];
            for (int i = 0; i < attributes[0].length; ++i) {
                rows[i][0] = String.valueOf(i + 1);
                rows[i][nameIndex] = attributes[0][i];
                this.originalAttrNames[i] = attributes[0][i];
                rows[i][typeIndex22] = new AttributeType(attributes[1][i]);
            }
        } else {
            rows = new String[1][this.attrHeaders.length];
            this.setDomain(null);
            this.domains = null;
            this.listener = null;
            this.eventsPanel.eventsTable = null;
        }
        if (this.attributesTable == null) {
            this.getAttributesTableColumnWidth(true);
        } else {
            this.getAttributesTableColumnWidth(false);
        }
        this.attributesTable = new JTable(rows, this.attrHeaders);
        this.scrollAttrPanel.setViewportView(this.attributesTable);
        this.attributesTable.setAutoResizeMode(0);
        this.scrollAttrPanel.setWheelScrollingEnabled(true);
        this.attributesTable.getTableHeader().setReorderingAllowed(false);
        DefaultCellEditor editorType = new DefaultCellEditor(this.typesComboBox);
        this.attributesTable.getColumnModel().getColumn(typeIndex22).setCellEditor(editorType);
        this.attributesTable.setSelectionMode(0);
        this.attributesTable.getSelectionModel().addListSelectionListener(this);
        AttributesPanel typeIndex22 = this;
        if (typeIndex22.attributesTable != null) {
            for (int i = 0; i < typeIndex22.attributesTableColumnWidth.length; ++i) {
                typeIndex22.attributesTable.getColumnModel().getColumn(i).setPreferredWidth(typeIndex22.attributesTableColumnWidth[i]);
            }
        }
        JTextField textField = new JTextField();
        textField.setBorder(null);
        DefaultCellEditor editorName = new DefaultCellEditor(textField);
        this.attributesTable.getColumnModel().getColumn(nameIndex).setCellEditor(editorName);
        attributesPanel.addCellEditorListener(this);
        if (stringArray != null) {
            int n;
            this.listener = new AttributesTableSelectionListener(this.attributesTable);
            this.attributesTable.getSelectionModel().addListSelectionListener(this.listener);
            this.listener.setEventsTable(this.eventsPanel.eventsTable);
            this.setDecisionAttribute(rows[rows.length - 1][n].toString());
            attributesPanel = this;
            CustomTableCellRenderer customTableCellRenderer = new CustomTableCellRenderer();
            stringArray = Attribute.getSupportedTypes();
            for (n = 0; n < stringArray.length; ++n) {
                customTableCellRenderer.addMarkedValue(stringArray[n], Attribute.getGUIColor(stringArray[n]));
            }
            n = ArrayUtils.indexOf(attributesPanel.attrHeaders, "type");
            attributesPanel.attributesTable.getColumnModel().getColumn(n).setCellRenderer(customTableCellRenderer);
            this.setAnchorAttributeIndex(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDomains(SDomain[] domains) {
        void var1_1;
        this.domains = var1_1;
    }

    private void setDomain(String[][] domain) {
        int domainIndex = ArrayUtils.indexOf(this.domainHeaders, "domain");
        int freqIndex = ArrayUtils.indexOf(this.domainHeaders, "freq");
        int domainSize = 1;
        if (domain != null) {
            domainSize = domain[0].length;
        }
        Object[][] rows = new String[domainSize][this.domainHeaders.length];
        if (domain != null) {
            for (int i = 0; i < domain[0].length; ++i) {
                rows[i][0] = String.valueOf(i + 1);
                rows[i][domainIndex] = domain[0][i];
                rows[i][freqIndex] = domain[1][i];
            }
        }
        if (this.domainTable == null) {
            this.getDomainTableColumnWidth(true);
        } else {
            this.getDomainTableColumnWidth(false);
        }
        this.domainTable = new JTable(rows, this.domainHeaders);
        this.scrollDomainPanel.setViewportView(this.domainTable);
        this.domainTable.setAutoResizeMode(0);
        this.scrollDomainPanel.setWheelScrollingEnabled(true);
        this.domainTable.getTableHeader().setReorderingAllowed(false);
        this.setDomainTableColumnWidth();
    }

    /*
     * WARNING - void declaration
     */
    public final void setDecisionAttribute(String decisionAttr) {
        void var1_1;
        void var2_2;
        this.decisionAttribute = decisionAttr;
        CustomTableCellRenderer renderer = new CustomTableCellRenderer();
        renderer.addMarkedValue(this.decisionAttribute, this.decisionAttrColor);
        renderer.setMyToolTipText("Decision Attribute");
        renderer.markAnchorRow = true;
        int nameIndex = ArrayUtils.indexOf(this.attrHeaders, "name");
        this.attributesTable.getColumnModel().getColumn((int)var2_2).setCellRenderer((TableCellRenderer)var1_1);
        this.attributesTable.repaint();
    }

    public final String getDecisionAttributeName() {
        return this.decisionAttribute;
    }

    public final String getAnchorAttributeName() {
        AttributesPanel attributesPanel = this;
        return attributesPanel.getAttrName(attributesPanel.getAnchorAttributeIndex());
    }

    public final int getAnchorAttributeIndex() {
        if (this.attributesTable != null) {
            return this.attributesTable.getSelectionModel().getAnchorSelectionIndex();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnchorAttributeIndex(int index) {
        void var1_1;
        int attrIndex;
        if (index < 0) {
            attrIndex = 0;
        } else if (attrIndex >= this.attributesTable.getRowCount()) {
            attrIndex = this.attributesTable.getRowCount() - 1;
        }
        this.attributesTable.getSelectionModel().setAnchorSelectionIndex((int)var1_1);
        this.refreshDomains();
    }

    @Override
    public final void valueChanged(ListSelectionEvent event) {
        ListSelectionModel listSelectionModel;
        Object object = event.getSource();
        if (object == this.attributesTable.getSelectionModel() && !(listSelectionModel = (ListSelectionModel)((EventObject)((Object)listSelectionModel)).getSource()).isSelectionEmpty()) {
            this.refreshDomains();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshDomains() {
        int index = this.getAnchorAttributeIndex();
        if (index == -1) {
            index = 0;
        }
        if (this.domains != null) {
            void var1_1;
            AttributesPanel attributesPanel = this;
            attributesPanel.setDomain(attributesPanel.domains[var1_1].getDomain());
        }
    }

    public final String[][] getAttributes() {
        TableModel model = this.attributesTable.getModel();
        int attrNumber = model.getRowCount();
        int nameIndex = ArrayUtils.indexOf(this.attrHeaders, "name");
        int typeIndex = ArrayUtils.indexOf(this.attrHeaders, "type");
        String[][] attr = new String[2][attrNumber];
        for (int i = 0; i < attrNumber; ++i) {
            attr[0][i] = model.getValueAt(i, nameIndex).toString();
            attr[1][i] = model.getValueAt(i, typeIndex).toString();
        }
        return attr;
    }

    /*
     * WARNING - void declaration
     */
    private String getAttrName(int attrIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        TableModel model = this.attributesTable.getModel();
        int nameIndex = ArrayUtils.indexOf(this.attrHeaders, "name");
        return var2_2.getValueAt((int)var1_1, (int)var3_3).toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String getNewName(String originalName) {
        void var2_2;
        String newName = this.namesMap.get(originalName);
        if (newName == null) {
            void var1_1;
            newName = var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void insertUpdate(DocumentEvent e) {
        void var1_1;
        if (this.moveByTextField.getDocument() == var1_1.getDocument()) {
            this.setLabel();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeUpdate(DocumentEvent e) {
        void var1_1;
        if (this.moveByTextField.getDocument() == var1_1.getDocument()) {
            this.setLabel();
        }
    }

    @Override
    public final void changedUpdate(DocumentEvent e) {
    }

    private void setLabel() {
        if (this.moveByTextField.isValid()) {
            this.moveByValue = this.moveByTextField.getValue();
        }
    }

    @Override
    public final void editingCanceled(ChangeEvent arg0) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void editingStopped(ChangeEvent arg0) {
        void var1_1;
        TableCellEditor editor = (TableCellEditor)arg0.getSource();
        System.out.println("Old Attribute Name: " + this.originalAttrNames[this.getAnchorAttributeIndex()]);
        System.out.println("New Attribute Name: " + editor.getCellEditorValue());
        this.namesMap.put(this.originalAttrNames[this.getAnchorAttributeIndex()], var1_1.getCellEditorValue().toString());
    }
}

